/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.freecam.ui.manual;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import ydmsama.hundred_years_war.freecam.ui.CustomButton;
import ydmsama.hundred_years_war.freecam.ui.CustomUI;
import ydmsama.hundred_years_war.freecam.ui.manual.ManualContentParser;
import ydmsama.hundred_years_war.freecam.ui.manual.ManualNode;
import ydmsama.hundred_years_war.freecam.ui.manual.ManualPage;
import ydmsama.hundred_years_war.freecam.ui.manual.ManualTableOfContentsEntry;
import ydmsama.hundred_years_war.freecam.ui.manual.ManualTree;
import ydmsama.hundred_years_war.freecam.ui.manual.TableOfContentsWidget;

@Environment(value=EnvType.CLIENT)
public class ManualUI
extends class_437 {
    private static final int WINDOW_WIDTH = 350;
    private static final int WINDOW_HEIGHT = 250;
    private static final int TABLE_OF_CONTENTS_WIDTH = 120;
    private int leftPos;
    private int topPos;
    private ManualTree manualTree;
    private ManualNode currentNode;
    private TableOfContentsWidget tocWidget;
    private CustomButton backButton;
    private CustomButton closeButton;
    private List<ManualPage> contentPages = new ArrayList<ManualPage>();
    private int currentPage = 0;
    private int totalPages = 1;
    private CustomButton prevPageButton;
    private CustomButton nextPageButton;
    private static final int CONTENT_MAX_LINES = 12;
    private static final int CONTENT_LINE_HEIGHT = 12;

    public ManualUI() {
        super((class_2561)class_2561.method_43471((String)"ui.hundred_years_war.manual.title"));
        this.manualTree = new ManualTree();
        this.currentNode = this.manualTree.getRoot();
    }

    protected void method_25426() {
        super.method_25426();
        this.leftPos = (this.field_22789 - 350) / 2;
        this.topPos = (this.field_22790 - 250) / 2;
        int tocTop = this.topPos + 20 + 20;
        int tocHeight = 170;
        this.tocWidget = new TableOfContentsWidget(this.field_22787, 120, tocHeight, tocTop, tocTop + tocHeight, 20);
        this.tocWidget.method_25333(this.leftPos + 10);
        this.updateTableOfContents();
        this.method_25429((class_364)this.tocWidget);
        this.backButton = new CustomButton(this.leftPos + 10, this.topPos + 250 - 20 - 10, 60, 20, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.manual.back"), button -> this.navigateBack());
        this.method_37063(this.backButton);
        this.closeButton = new CustomButton(this.leftPos + 350 - 60 - 10, this.topPos + 250 - 20 - 10, 60, 20, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.close"), button -> this.method_25419());
        this.method_37063(this.closeButton);
        int paginationY = this.topPos + 250 - 20 - 20 - 18;
        int paginationCenterX = this.leftPos + 120 + 115;
        this.prevPageButton = new CustomButton(paginationCenterX - 50, paginationY, 20, 20, (class_2561)class_2561.method_43470((String)"\u2190"), button -> this.changePage(-1));
        this.nextPageButton = new CustomButton(paginationCenterX + 30, paginationY, 20, 20, (class_2561)class_2561.method_43470((String)"\u2192"), button -> this.changePage(1));
        this.method_37063(this.prevPageButton);
        this.method_37063(this.nextPageButton);
        this.updateContent();
        this.updateBackButton();
        this.updatePaginationButtons();
    }

    private void updateTableOfContents() {
        this.tocWidget.method_25339();
        for (ManualNode child : this.currentNode.getChildren()) {
            ManualTableOfContentsEntry entry = new ManualTableOfContentsEntry((class_2561)class_2561.method_43471((String)child.getTitleKey()), this.tocWidget, () -> this.navigateTo(child));
            this.tocWidget.addEntry(entry);
        }
        this.tocWidget.method_25307(0.0);
    }

    private void updateContent() {
        this.contentPages.clear();
        this.currentPage = 0;
        class_5250 content = class_2561.method_43471((String)this.currentNode.getContentKey());
        int contentWidth = 200;
        this.contentPages = ManualContentParser.parseContent((class_2561)content, contentWidth, this.field_22793, 12, 12);
        this.totalPages = Math.max(1, this.contentPages.size());
        this.updatePaginationButtons();
    }

    private void updateBackButton() {
        this.backButton.field_22763 = true;
    }

    private void updatePaginationButtons() {
        this.prevPageButton.field_22763 = this.currentPage > 0;
        this.nextPageButton.field_22763 = this.currentPage < this.totalPages - 1;
    }

    private void changePage(int delta) {
        int newPage = this.currentPage + delta;
        if (newPage >= 0 && newPage < this.totalPages) {
            this.currentPage = newPage;
            this.updatePaginationButtons();
        }
    }

    private void navigateTo(ManualNode node) {
        this.currentNode = node;
        this.updateTableOfContents();
        this.updateContent();
        this.updateBackButton();
    }

    private void navigateBack() {
        if (this.currentNode.hasParent()) {
            this.navigateTo(this.currentNode.getParent());
        } else {
            class_310.method_1551().method_1507((class_437)new CustomUI());
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.method_25294(this.leftPos, this.topPos, this.leftPos + 350, this.topPos + 250, -1073741824);
        guiGraphics.method_25294(this.leftPos, this.topPos, this.leftPos + 350, this.topPos + 1, -1);
        guiGraphics.method_25294(this.leftPos, this.topPos + 250 - 1, this.leftPos + 350, this.topPos + 250, -1);
        guiGraphics.method_25294(this.leftPos, this.topPos, this.leftPos + 1, this.topPos + 250, -1);
        guiGraphics.method_25294(this.leftPos + 350 - 1, this.topPos, this.leftPos + 350, this.topPos + 250, -1);
        class_5250 title = class_2561.method_43471((String)this.currentNode.getTitleKey());
        guiGraphics.method_27534(this.field_22793, (class_2561)title, this.leftPos + 175, this.topPos + 10, 0xFFFFFF);
        guiGraphics.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"ui.hundred_years_war.manual.toc"), this.leftPos + 10, this.topPos + 20 + 5, 0xFFFFFF);
        int dividerX = this.leftPos + 120 + 10;
        guiGraphics.method_25294(dividerX, this.topPos + 20 + 20, dividerX + 1, this.topPos + 250 - 10 - 20, -1);
        this.tocWidget.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        int contentX = this.leftPos + 120 + 20;
        int contentY = this.topPos + 20 + 20;
        if (!this.contentPages.isEmpty() && this.currentPage < this.contentPages.size()) {
            ManualPage currentPage = this.contentPages.get(this.currentPage);
            currentPage.render(guiGraphics, contentX, contentY, 0xFFFFFF);
        }
        String pageInfo = String.format("%d/%d", this.currentPage + 1, this.totalPages);
        int pageInfoX = this.leftPos + 120 + 115;
        int pageInfoY = this.topPos + 250 - 20 - 20 - 14;
        guiGraphics.method_25300(this.field_22793, pageInfo, pageInfoX, pageInfoY, 0xFFFFFF);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        if (!this.contentPages.isEmpty() && this.currentPage < this.contentPages.size()) {
            ManualPage currentPage = this.contentPages.get(this.currentPage);
            currentPage.renderTooltips(guiGraphics, mouseX, mouseY, contentX, contentY);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollDelta) {
        if (mouseX >= (double)this.tocWidget.getLeft() && mouseX <= (double)this.tocWidget.getRight() && mouseY >= (double)this.tocWidget.getTop() && mouseY <= (double)this.tocWidget.getBottom()) {
            return this.tocWidget.method_25401(mouseX, mouseY, scrollDelta);
        }
        int contentAreaLeft = this.leftPos + 120 + 10;
        int contentAreaRight = this.leftPos + 350 - 10;
        int contentAreaTop = this.topPos + 20 + 20;
        int contentAreaBottom = this.topPos + 250 - 10 - 20 - 25;
        if (mouseX >= (double)contentAreaLeft && mouseX <= (double)contentAreaRight && mouseY >= (double)contentAreaTop && mouseY <= (double)contentAreaBottom) {
            if (scrollDelta < 0.0) {
                this.changePage(1);
            } else {
                this.changePage(-1);
            }
            return true;
        }
        return super.method_25401(mouseX, mouseY, scrollDelta);
    }

    public void method_25419() {
        class_310.method_1551().method_1507(null);
    }
}

