/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.network.packets;

import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import ydmsama.hundred_years_war.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.entity.utils.FormationManager;
import ydmsama.hundred_years_war.entity.utils.PathingTaskManager;
import ydmsama.hundred_years_war.entity.utils.PathingTaskManagerRegistry;
import ydmsama.hundred_years_war.selection.SelectionSystem;

public class MoveCommandPacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "move_command_packet");
    private final class_239 hitResult;
    private final boolean queueMode;
    private final boolean formationMode;
    private final String formationType;

    public MoveCommandPacket(class_239 hitResult, boolean queueMode, boolean formationMode, String formationType) {
        this.hitResult = hitResult;
        this.queueMode = queueMode;
        this.formationMode = formationMode;
        this.formationType = formationType;
    }

    public MoveCommandPacket(class_2540 buf) {
        this.hitResult = buf.method_17814();
        this.queueMode = buf.readBoolean();
        this.formationMode = buf.readBoolean();
        this.formationType = buf.method_19772();
    }

    public void encode(class_2540 buf) {
        buf.method_17813((class_3965)this.hitResult);
        buf.writeBoolean(this.queueMode);
        buf.writeBoolean(this.formationMode);
        buf.method_10814(this.formationType);
    }

    public static MoveCommandPacket decode(class_2540 buf) {
        return new MoveCommandPacket(buf);
    }

    public static void handle(class_3222 player, MoveCommandPacket packet) {
        class_239 hitResult;
        if (!packet.queueMode) {
            PathingTaskManagerRegistry registry = PathingTaskManagerRegistry.getInstance();
            PathingTaskManager manager = registry.getTaskManager(player.method_5667());
            manager.clearTasks();
        }
        if ((hitResult = packet.hitResult).method_17783() == class_239.class_240.field_1332 || hitResult.method_17783() == class_239.class_240.field_1333) {
            class_2338 targetPos;
            class_3965 blockHitResult = (class_3965)hitResult;
            if (hitResult.method_17783() == class_239.class_240.field_1333) {
                class_243 hitLocation = blockHitResult.method_17784();
                targetPos = new class_2338((int)hitLocation.field_1352, (int)hitLocation.field_1351, (int)hitLocation.field_1350);
            } else {
                targetPos = blockHitResult.method_17777();
            }
            SelectionSystem.Selection selection = SelectionSystem.getSelection(player);
            selection.refreshEntities();
            List<BaseCombatEntity> entities = selection.getEntities();
            if (packet.formationMode) {
                FormationManager.formMove(entities, targetPos, 1, packet.queueMode, packet.formationType);
            } else {
                FormationManager.move(entities, targetPos, 1, packet.queueMode);
            }
        }
    }
}

