/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.network.packets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import ydmsama.hundred_years_war.utils.RelationSystem;
import ydmsama.hundred_years_war.utils.TeamRelationData;

public class RelationResponsePacket {
    public static final class_2960 RELATION_RESPONSE_PACKET_ID = new class_2960("hundred_years_war", "relation_response_packet");
    private final Map<UUID, RelationInfo> relationInfoMap = new HashMap<UUID, RelationInfo>();
    private final Map<UUID, TeamInfo> teamInfoMap = new HashMap<UUID, TeamInfo>();

    public static RelationResponsePacket decode(class_2540 buf) {
        RelationResponsePacket packet = new RelationResponsePacket();
        int playerCount = buf.readInt();
        for (int i = 0; i < playerCount; ++i) {
            UUID uuid = buf.method_10790();
            String playerName = buf.method_19772();
            RelationSystem.RelationType myRelation = RelationSystem.RelationType.valueOf(buf.method_19772());
            RelationSystem.RelationType theirRelation = RelationSystem.RelationType.valueOf(buf.method_19772());
            packet.addRelationInfo(uuid, playerName, myRelation, theirRelation);
        }
        int teamCount = buf.readInt();
        for (int i = 0; i < teamCount; ++i) {
            UUID teamUuid = buf.method_10790();
            String teamName = buf.method_19772();
            RelationSystem.RelationType myRelation = RelationSystem.RelationType.valueOf(buf.method_19772());
            RelationSystem.RelationType theirRelation = RelationSystem.RelationType.valueOf(buf.method_19772());
            int memberCount = buf.readInt();
            HashMap<UUID, TeamRelationData.MemberType> members = new HashMap<UUID, TeamRelationData.MemberType>();
            for (int j = 0; j < memberCount; ++j) {
                UUID memberUuid = buf.method_10790();
                TeamRelationData.MemberType memberType = TeamRelationData.MemberType.valueOf(buf.method_19772());
                members.put(memberUuid, memberType);
            }
            int myTeamsCount = buf.readInt();
            ArrayList<UUID> myTeams = new ArrayList<UUID>();
            for (int j = 0; j < myTeamsCount; ++j) {
                myTeams.add(buf.method_10790());
            }
            packet.addTeamInfo(teamUuid, teamName, myRelation, members, myTeams, theirRelation);
        }
        return packet;
    }

    public void encode(class_2540 buf) {
        buf.writeInt(this.relationInfoMap.size());
        for (Map.Entry<UUID, RelationInfo> entry : this.relationInfoMap.entrySet()) {
            buf.method_10797(entry.getKey());
            buf.method_10814(entry.getValue().getPlayerName());
            buf.method_10814(entry.getValue().getMyRelation().name());
            buf.method_10814(entry.getValue().getTheirRelation().name());
        }
        buf.writeInt(this.teamInfoMap.size());
        for (Map.Entry<UUID, Object> entry : this.teamInfoMap.entrySet()) {
            buf.method_10797(entry.getKey());
            buf.method_10814(((TeamInfo)entry.getValue()).getTeamName());
            buf.method_10814(((TeamInfo)entry.getValue()).getMyRelation().name());
            buf.method_10814(((TeamInfo)entry.getValue()).getTheirRelation().name());
            Map<UUID, TeamRelationData.MemberType> members = ((TeamInfo)entry.getValue()).getMembers();
            buf.writeInt(members.size());
            for (Map.Entry<UUID, TeamRelationData.MemberType> memberEntry : members.entrySet()) {
                buf.method_10797(memberEntry.getKey());
                buf.method_10814(memberEntry.getValue().name());
            }
            List<UUID> myTeams = ((TeamInfo)entry.getValue()).getMyTeams();
            buf.writeInt(myTeams.size());
            for (UUID teamUuid : myTeams) {
                buf.method_10797(teamUuid);
            }
        }
    }

    public void addRelationInfo(UUID uuid, String playerName, RelationSystem.RelationType myRelation, RelationSystem.RelationType theirRelation) {
        this.relationInfoMap.put(uuid, new RelationInfo(playerName, myRelation, theirRelation));
    }

    public void addTeamInfo(UUID teamUuid, String teamName, RelationSystem.RelationType myRelation, Map<UUID, TeamRelationData.MemberType> members, List<UUID> myTeams) {
        this.addTeamInfo(teamUuid, teamName, myRelation, members, myTeams, RelationSystem.RelationType.NEUTRAL);
    }

    public void addTeamInfo(UUID teamUuid, String teamName, RelationSystem.RelationType myRelation, Map<UUID, TeamRelationData.MemberType> members, List<UUID> myTeams, RelationSystem.RelationType theirRelation) {
        this.teamInfoMap.put(teamUuid, new TeamInfo(teamName, myRelation, members, myTeams, theirRelation));
    }

    public Map<UUID, RelationInfo> getRelationInfoMap() {
        return this.relationInfoMap;
    }

    public Map<UUID, TeamInfo> getTeamInfoMap() {
        return this.teamInfoMap;
    }

    public static class RelationInfo {
        private final String playerName;
        private final RelationSystem.RelationType myRelation;
        private final RelationSystem.RelationType theirRelation;

        public RelationInfo(String playerName, RelationSystem.RelationType myRelation, RelationSystem.RelationType theirRelation) {
            this.playerName = playerName;
            this.myRelation = myRelation;
            this.theirRelation = theirRelation;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public RelationSystem.RelationType getMyRelation() {
            return this.myRelation;
        }

        public RelationSystem.RelationType getTheirRelation() {
            return this.theirRelation;
        }
    }

    public static class TeamInfo {
        private final String teamName;
        private final RelationSystem.RelationType myRelation;
        private final Map<UUID, TeamRelationData.MemberType> members;
        private final List<UUID> myTeams;
        private RelationSystem.RelationType theirRelation;

        public TeamInfo(String teamName, RelationSystem.RelationType myRelation, Map<UUID, TeamRelationData.MemberType> members, List<UUID> myTeams) {
            this(teamName, myRelation, members, myTeams, RelationSystem.RelationType.NEUTRAL);
        }

        public TeamInfo(String teamName, RelationSystem.RelationType myRelation, Map<UUID, TeamRelationData.MemberType> members, List<UUID> myTeams, RelationSystem.RelationType theirRelation) {
            this.teamName = teamName;
            this.myRelation = myRelation;
            this.members = members;
            this.myTeams = myTeams;
            this.theirRelation = theirRelation;
        }

        public String getTeamName() {
            return this.teamName;
        }

        public RelationSystem.RelationType getMyRelation() {
            return this.myRelation;
        }

        public Map<UUID, TeamRelationData.MemberType> getMembers() {
            return this.members;
        }

        public List<UUID> getMyTeams() {
            return this.myTeams;
        }

        public RelationSystem.RelationType getTheirRelation() {
            return this.theirRelation;
        }

        public void setTheirRelation(RelationSystem.RelationType theirRelation) {
            this.theirRelation = theirRelation;
        }
    }
}

