/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class TeamApplicationsResponsePacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "team_applications_response");
    private final List<Application> applications;

    public TeamApplicationsResponsePacket(List<Application> applications) {
        this.applications = applications;
    }

    public TeamApplicationsResponsePacket(class_2540 buf) {
        int size = buf.readInt();
        this.applications = new ArrayList<Application>(size);
        for (int i = 0; i < size; ++i) {
            String playerName = buf.method_19772();
            UUID playerUUID = buf.method_10790();
            long applyTime = buf.readLong();
            this.applications.add(new Application(playerName, playerUUID, applyTime));
        }
    }

    public void encode(class_2540 buf) {
        buf.writeInt(this.applications.size());
        for (Application app : this.applications) {
            buf.method_10814(app.getPlayerName());
            buf.method_10797(app.getPlayerUUID());
            buf.writeLong(app.getApplyTime());
        }
    }

    public static TeamApplicationsResponsePacket decode(class_2540 buf) {
        return new TeamApplicationsResponsePacket(buf);
    }

    public List<Application> getApplications() {
        return this.applications;
    }

    public static class Application {
        private final String playerName;
        private final UUID playerUUID;
        private final long applyTime;

        public Application(String playerName, UUID playerUUID, long applyTime) {
            this.playerName = playerName;
            this.playerUUID = playerUUID;
            this.applyTime = applyTime;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public UUID getPlayerUUID() {
            return this.playerUUID;
        }

        public long getApplyTime() {
            return this.applyTime;
        }
    }
}

