/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.network.packets;

import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.network.packets.TeamCreateResponsePacket;
import ydmsama.hundred_years_war.network.packets.TeamInfoRequestPacket;
import ydmsama.hundred_years_war.utils.RelationSystem;
import ydmsama.hundred_years_war.utils.TeamRelationData;

public class TeamCreateRequestPacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "team_create");
    private final String teamName;

    public TeamCreateRequestPacket(String teamName) {
        this.teamName = teamName;
    }

    public TeamCreateRequestPacket(class_2540 buf) {
        this.teamName = buf.method_19772();
    }

    public void encode(class_2540 buf) {
        buf.method_10814(this.teamName);
    }

    public static TeamCreateRequestPacket decode(class_2540 buf) {
        return new TeamCreateRequestPacket(buf);
    }

    public String getTeamName() {
        return this.teamName;
    }

    public static void handle(class_3222 player, TeamCreateRequestPacket packet) {
        String teamName = packet.getTeamName();
        if (teamName == null || teamName.trim().isEmpty()) {
            TeamCreateRequestPacket.sendTeamCreateResponse(player, false, "team_name_empty", null);
            return;
        }
        if (teamName.length() < 3) {
            TeamCreateRequestPacket.sendTeamCreateResponse(player, false, "team_name_too_short", null);
            return;
        }
        if (teamName.length() > 20) {
            TeamCreateRequestPacket.sendTeamCreateResponse(player, false, "team_name_too_long", null);
            return;
        }
        boolean nameExists = false;
        for (UUID existingTeamUUID : RelationSystem.getAllTeams().keySet()) {
            if (!RelationSystem.getTeamRelationData(existingTeamUUID).getTeamName().equals(teamName)) continue;
            nameExists = true;
            break;
        }
        if (nameExists) {
            TeamCreateRequestPacket.sendTeamCreateResponse(player, false, "team_name_exists", null);
            player.method_43496((class_2561)class_2561.method_43471((String)"message.hundred_years_war.team_name_exists"));
            return;
        }
        TeamRelationData teamData = RelationSystem.createTeam(teamName, player.method_5667());
        if (teamData != null) {
            UUID teamUUID = teamData.getUUID();
            TeamCreateRequestPacket.sendTeamCreateResponse(player, true, "team_create_success", teamUUID);
            player.method_43496((class_2561)class_2561.method_43469((String)"message.hundred_years_war.team_created", (Object[])new Object[]{teamName}));
        } else {
            TeamCreateRequestPacket.sendTeamCreateResponse(player, false, "team_name_exists", null);
            player.method_43496((class_2561)class_2561.method_43471((String)"message.hundred_years_war.team_name_exists"));
        }
        TeamInfoRequestPacket.handle(player);
    }

    private static void sendTeamCreateResponse(class_3222 player, boolean success, String message, UUID teamUUID) {
        TeamCreateResponsePacket responsePacket = new TeamCreateResponsePacket(success, message, teamUUID);
        class_2540 responseBuf = PacketByteBufs.create();
        responsePacket.encode(responseBuf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)TeamCreateResponsePacket.ID, (class_2540)responseBuf);
    }
}

