/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.network.packets;

import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.network.packets.TeamInfoRequestPacket;
import ydmsama.hundred_years_war.utils.RelationSystem;
import ydmsama.hundred_years_war.utils.TeamRelationData;

public class TeamJoinRequestPacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "team_join");
    private final UUID teamUUID;

    public TeamJoinRequestPacket(UUID teamUUID) {
        this.teamUUID = teamUUID;
    }

    public TeamJoinRequestPacket(class_2540 buf) {
        this.teamUUID = buf.method_10790();
    }

    public void encode(class_2540 buf) {
        buf.method_10797(this.teamUUID);
    }

    public static TeamJoinRequestPacket decode(class_2540 buf) {
        return new TeamJoinRequestPacket(buf);
    }

    public UUID getTeamUUID() {
        return this.teamUUID;
    }

    public static void handle(class_3222 player, TeamJoinRequestPacket packet) {
        UUID playerUUID = player.method_5667();
        UUID teamUUID = packet.getTeamUUID();
        TeamRelationData teamData = RelationSystem.getTeamRelationData(teamUUID);
        if (teamData == null) {
            player.method_43496((class_2561)class_2561.method_43471((String)"message.hundred_years_war.team_not_found"));
            return;
        }
        if (teamData.isMember(playerUUID)) {
            player.method_43496((class_2561)class_2561.method_43471((String)"message.hundred_years_war.already_in_team"));
            return;
        }
        if (teamData.hasApplication(playerUUID)) {
            player.method_43496((class_2561)class_2561.method_43471((String)"message.hundred_years_war.already_applied"));
            return;
        }
        teamData.addApplication(playerUUID);
        player.method_43496((class_2561)class_2561.method_43469((String)"message.hundred_years_war.application_sent", (Object[])new Object[]{teamData.getTeamName()}));
        for (Map.Entry<UUID, TeamRelationData.MemberType> entry : teamData.getAllMembers().entrySet()) {
            class_3222 member;
            UUID memberUUID = entry.getKey();
            TeamRelationData.MemberType memberType = entry.getValue();
            if (memberType != TeamRelationData.MemberType.OWNER && memberType != TeamRelationData.MemberType.ADMIN || (member = player.method_5682().method_3760().method_14602(memberUUID)) == null) continue;
            member.method_43496((class_2561)class_2561.method_43469((String)"message.hundred_years_war.new_application", (Object[])new Object[]{player.method_5477().getString()}));
        }
        TeamInfoRequestPacket.handle(player);
    }
}

