/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.network.packets;

import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.network.packets.TeamInfoRequestPacket;
import ydmsama.hundred_years_war.utils.RelationSystem;
import ydmsama.hundred_years_war.utils.TeamRelationData;

public class TeamManageRequestPacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "team_manage");
    private final UUID teamUUID;
    private final String actionType;
    private final UUID targetUUID;

    public TeamManageRequestPacket(UUID teamUUID, String actionType, UUID targetUUID) {
        this.teamUUID = teamUUID;
        this.actionType = actionType;
        this.targetUUID = targetUUID;
    }

    public TeamManageRequestPacket(class_2540 buf) {
        this.teamUUID = buf.method_10790();
        this.actionType = buf.method_19772();
        this.targetUUID = buf.method_10790();
    }

    public void encode(class_2540 buf) {
        buf.method_10797(this.teamUUID);
        buf.method_10814(this.actionType);
        buf.method_10797(this.targetUUID);
    }

    public static TeamManageRequestPacket decode(class_2540 buf) {
        return new TeamManageRequestPacket(buf);
    }

    public UUID getTeamUUID() {
        return this.teamUUID;
    }

    public String getActionType() {
        return this.actionType;
    }

    public UUID getTargetUUID() {
        return this.targetUUID;
    }

    public static void handle(class_3222 player, TeamManageRequestPacket packet) {
        UUID playerUUID = player.method_5667();
        UUID teamUUID = packet.getTeamUUID();
        String actionType = packet.getActionType();
        UUID targetUUID = packet.getTargetUUID();
        TeamRelationData teamData = RelationSystem.getTeamRelationData(teamUUID);
        if (teamData == null) {
            player.method_43496((class_2561)class_2561.method_43471((String)"message.hundred_years_war.team_not_found"));
            return;
        }
        TeamRelationData.MemberType playerMemberType = teamData.getMemberType(playerUUID);
        if (playerMemberType != TeamRelationData.MemberType.OWNER && playerMemberType != TeamRelationData.MemberType.ADMIN) {
            player.method_43496((class_2561)class_2561.method_43471((String)"message.hundred_years_war.no_permission"));
            return;
        }
        boolean success = false;
        String messageKey = "";
        switch (actionType) {
            case "accept": {
                if (teamData.hasApplication(targetUUID)) {
                    success = teamData.approveApplication(targetUUID, TeamRelationData.MemberType.MEMBER);
                    messageKey = "message.hundred_years_war.application_accepted";
                    if (!success) break;
                    RelationSystem.joinTeam(targetUUID, teamUUID, TeamRelationData.MemberType.MEMBER);
                    class_3222 targetPlayer = player.method_5682().method_3760().method_14602(targetUUID);
                    if (targetPlayer == null) break;
                    targetPlayer.method_43496((class_2561)class_2561.method_43469((String)"message.hundred_years_war.join_accepted", (Object[])new Object[]{teamData.getTeamName()}));
                    break;
                }
                messageKey = "message.hundred_years_war.no_application";
                break;
            }
            case "reject": {
                if (teamData.hasApplication(targetUUID)) {
                    class_3222 targetPlayer;
                    success = teamData.rejectApplication(targetUUID);
                    messageKey = "message.hundred_years_war.application_rejected";
                    if (!success || (targetPlayer = player.method_5682().method_3760().method_14602(targetUUID)) == null) break;
                    targetPlayer.method_43496((class_2561)class_2561.method_43469((String)"message.hundred_years_war.join_rejected", (Object[])new Object[]{teamData.getTeamName()}));
                    break;
                }
                messageKey = "message.hundred_years_war.no_application";
                break;
            }
            case "promote": {
                if (playerMemberType != TeamRelationData.MemberType.OWNER) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"message.hundred_years_war.owner_only"));
                    return;
                }
                if (teamData.isMember(targetUUID)) {
                    class_3222 targetPlayer;
                    success = teamData.updateMemberType(targetUUID, TeamRelationData.MemberType.ADMIN);
                    messageKey = "message.hundred_years_war.promote_success";
                    if (!success || (targetPlayer = player.method_5682().method_3760().method_14602(targetUUID)) == null) break;
                    targetPlayer.method_43496((class_2561)class_2561.method_43469((String)"message.hundred_years_war.promoted", (Object[])new Object[]{teamData.getTeamName()}));
                    break;
                }
                messageKey = "message.hundred_years_war.not_a_member";
                break;
            }
            case "demote": {
                if (playerMemberType != TeamRelationData.MemberType.OWNER) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"message.hundred_years_war.owner_only"));
                    return;
                }
                if (teamData.isMember(targetUUID) && teamData.getMemberType(targetUUID) == TeamRelationData.MemberType.ADMIN) {
                    class_3222 targetPlayer;
                    success = teamData.updateMemberType(targetUUID, TeamRelationData.MemberType.MEMBER);
                    messageKey = "message.hundred_years_war.demote_success";
                    if (!success || (targetPlayer = player.method_5682().method_3760().method_14602(targetUUID)) == null) break;
                    targetPlayer.method_43496((class_2561)class_2561.method_43469((String)"message.hundred_years_war.demoted", (Object[])new Object[]{teamData.getTeamName()}));
                    break;
                }
                messageKey = "message.hundred_years_war.not_admin";
                break;
            }
            case "remove": {
                if (playerMemberType == TeamRelationData.MemberType.ADMIN && teamData.isMember(targetUUID) && teamData.getMemberType(targetUUID) == TeamRelationData.MemberType.ADMIN) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"message.hundred_years_war.cannot_remove_admin"));
                    return;
                }
                if (teamData.isMember(targetUUID) && teamData.getMemberType(targetUUID) == TeamRelationData.MemberType.OWNER) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"message.hundred_years_war.cannot_remove_owner"));
                    return;
                }
                if (teamData.isMember(targetUUID)) {
                    success = teamData.removeMember(targetUUID);
                    messageKey = "message.hundred_years_war.remove_success";
                    if (!success) break;
                    RelationSystem.setRelation(targetUUID, teamUUID, RelationSystem.RelationType.NEUTRAL);
                    class_3222 targetPlayer = player.method_5682().method_3760().method_14602(targetUUID);
                    if (targetPlayer == null) break;
                    targetPlayer.method_43496((class_2561)class_2561.method_43469((String)"message.hundred_years_war.removed_from_team", (Object[])new Object[]{teamData.getTeamName()}));
                    break;
                }
                messageKey = "message.hundred_years_war.not_a_member";
                break;
            }
            default: {
                player.method_43496((class_2561)class_2561.method_43471((String)"message.hundred_years_war.unknown_action"));
                return;
            }
        }
        if (!messageKey.isEmpty()) {
            player.method_43496((class_2561)class_2561.method_43471((String)messageKey));
        }
        TeamInfoRequestPacket.handle(player);
    }
}

