/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.network.packets;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.network.packets.TeamRelationRequestPacket;
import ydmsama.hundred_years_war.utils.RelationSystem;
import ydmsama.hundred_years_war.utils.TeamRelationData;

public class TeamRelationUpdatePacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "team_relation_update_packet");
    private final UUID teamUUID;
    private final Map<UUID, RelationSystem.RelationType> relationUpdates = new HashMap<UUID, RelationSystem.RelationType>();

    public TeamRelationUpdatePacket(UUID teamUUID) {
        this.teamUUID = teamUUID;
    }

    public void addRelationUpdate(UUID targetUUID, RelationSystem.RelationType relationType) {
        this.relationUpdates.put(targetUUID, relationType);
    }

    public void encode(class_2540 buf) {
        buf.method_10797(this.teamUUID);
        buf.writeInt(this.relationUpdates.size());
        for (Map.Entry<UUID, RelationSystem.RelationType> entry : this.relationUpdates.entrySet()) {
            buf.method_10797(entry.getKey());
            buf.writeInt(entry.getValue().ordinal());
        }
    }

    public static TeamRelationUpdatePacket decode(class_2540 buf) {
        UUID teamUUID = buf.method_10790();
        TeamRelationUpdatePacket packet = new TeamRelationUpdatePacket(teamUUID);
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            UUID targetUUID = buf.method_10790();
            RelationSystem.RelationType relationType = RelationSystem.RelationType.values()[buf.readInt()];
            packet.addRelationUpdate(targetUUID, relationType);
        }
        return packet;
    }

    public static void handleUpdate(class_3222 player, TeamRelationUpdatePacket packet) {
        UUID playerUUID = player.method_5667();
        UUID teamUUID = packet.getTeamUUID();
        TeamRelationData teamData = RelationSystem.getTeamRelationData(teamUUID);
        if (teamData == null) {
            return;
        }
        TeamRelationData.MemberType memberType = teamData.getMemberType(playerUUID);
        if (memberType != TeamRelationData.MemberType.ADMIN && memberType != TeamRelationData.MemberType.OWNER) {
            return;
        }
        for (Map.Entry<UUID, RelationSystem.RelationType> entry : packet.relationUpdates.entrySet()) {
            UUID targetUUID = entry.getKey();
            RelationSystem.RelationType relationType = entry.getValue();
            RelationSystem.setRelation(teamUUID, targetUUID, relationType);
            Set<UUID> ourTeamMembers = teamData.getAllMembers().keySet();
            TeamRelationData targetTeamData = RelationSystem.getTeamRelationData(targetUUID);
            if (targetTeamData != null) {
                Set<UUID> theirTeamMembers = targetTeamData.getAllMembers().keySet();
                for (UUID ourMemberUUID : ourTeamMembers) {
                    RelationSystem.setRelation(ourMemberUUID, targetUUID, relationType);
                    for (UUID theirMemberUUID : theirTeamMembers) {
                        RelationSystem.setRelation(ourMemberUUID, theirMemberUUID, relationType);
                    }
                }
                continue;
            }
            for (UUID memberUUID : ourTeamMembers) {
                RelationSystem.setRelation(memberUUID, targetUUID, relationType);
            }
        }
        TeamRelationRequestPacket.handle(player, teamUUID);
    }

    public UUID getTeamUUID() {
        return this.teamUUID;
    }

    public Map<UUID, RelationSystem.RelationType> getRelationUpdates() {
        return this.relationUpdates;
    }
}

