/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.recruitment;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import ydmsama.hundred_years_war.recruitment.RecruitmentCategory;
import ydmsama.hundred_years_war.recruitment.RecruitmentConditionChecker;
import ydmsama.hundred_years_war.recruitment.data.RecruitmentConfig;

public class RecruitmentConfigManager {
    private static final Map<String, RecruitmentConfig> cachedConfigs = new HashMap<String, RecruitmentConfig>();
    private static boolean isLoaded = false;
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static void loadAllConfigs() {
        System.out.println("\u5f00\u59cb\u52a0\u8f7d\u62db\u52df\u914d\u7f6e...");
        for (RecruitmentCategory category : RecruitmentCategory.values()) {
            RecruitmentConfigManager.loadCategoryConfig(category);
        }
        isLoaded = true;
        System.out.println("\u62db\u52df\u914d\u7f6e\u52a0\u8f7d\u5b8c\u6210");
    }

    private static void loadCategoryConfig(RecruitmentCategory category) {
        String configPath = "/assets/hundred_years_war/recruitment/" + category.getId() + ".json";
        try (InputStream is = RecruitmentConfigManager.class.getResourceAsStream(configPath);){
            if (is == null) {
                System.err.println("\u62db\u52df\u914d\u7f6e\u6587\u4ef6\u672a\u627e\u5230: " + configPath);
                cachedConfigs.put(category.getId(), new RecruitmentConfig());
                return;
            }
            InputStreamReader reader = new InputStreamReader(is);
            RecruitmentConfig config = (RecruitmentConfig)gson.fromJson((Reader)reader, RecruitmentConfig.class);
            cachedConfigs.put(category.getId(), config);
            System.out.println("\u6210\u529f\u52a0\u8f7d\u914d\u7f6e: " + category.getId());
        }
        catch (IOException e) {
            System.err.println("\u52a0\u8f7d\u62db\u52df\u914d\u7f6e\u5931\u8d25: " + configPath);
            e.printStackTrace();
            cachedConfigs.put(category.getId(), new RecruitmentConfig());
        }
    }

    public static void reloadConfigs() {
        System.out.println("\u91cd\u65b0\u52a0\u8f7d\u62db\u52df\u914d\u7f6e...");
        cachedConfigs.clear();
        isLoaded = false;
        RecruitmentConfigManager.loadAllConfigs();
    }

    public static List<RecruitmentConfig.UnitTypeConfig> getAvailableUnitTypes(class_1657 player, RecruitmentCategory category) {
        RecruitmentConfig config;
        if (!isLoaded) {
            RecruitmentConfigManager.loadAllConfigs();
        }
        if ((config = cachedConfigs.get(category.getId())) == null) {
            System.err.println("\u914d\u7f6e\u4e3a\u7a7a\uff0c\u7c7b\u522bID: " + category.getId());
            return new ArrayList<RecruitmentConfig.UnitTypeConfig>();
        }
        if (config.getUnitTypes() == null) {
            System.err.println("unitTypes\u4e3a\u7a7a\uff0c\u7c7b\u522bID: " + category.getId());
            return new ArrayList<RecruitmentConfig.UnitTypeConfig>();
        }
        List<RecruitmentConfig.UnitTypeConfig> unitTypes = config.getUnitTypes().get(category.getId());
        if (unitTypes == null) {
            System.out.println("\u672a\u627e\u5230\u5175\u79cd\u7c7b\u578b\uff0c\u7c7b\u522bID: " + category.getId() + "\uff0c\u53ef\u7528\u952e: " + config.getUnitTypes().keySet());
            return new ArrayList<RecruitmentConfig.UnitTypeConfig>();
        }
        ArrayList<RecruitmentConfig.UnitTypeConfig> availableUnitTypes = new ArrayList<RecruitmentConfig.UnitTypeConfig>();
        for (RecruitmentConfig.UnitTypeConfig unitType : unitTypes) {
            RecruitmentConfig.UnitTypeConfig availableUnitType = new RecruitmentConfig.UnitTypeConfig();
            availableUnitType.setId(unitType.getId());
            availableUnitType.setTranslationKey(unitType.getTranslationKey());
            ArrayList<RecruitmentConfig.ArmyLevelConfig> availableLevels = new ArrayList<RecruitmentConfig.ArmyLevelConfig>();
            for (RecruitmentConfig.ArmyLevelConfig level : unitType.getLevels()) {
                if (!RecruitmentConditionChecker.checkConditions(player, level)) continue;
                availableLevels.add(level);
            }
            if (availableLevels.isEmpty()) continue;
            availableUnitType.setLevels(availableLevels);
            availableUnitTypes.add(availableUnitType);
        }
        System.out.println("\u7c7b\u522b " + category.getId() + " \u53ef\u7528\u5175\u79cd\u6570\u91cf: " + availableUnitTypes.size());
        return availableUnitTypes;
    }

    public static RecruitmentConfig.ArmyLevelConfig getArmyLevelConfig(String categoryId, String unitTypeId, int level) {
        RecruitmentConfig config;
        if (!isLoaded) {
            RecruitmentConfigManager.loadAllConfigs();
        }
        if ((config = cachedConfigs.get(categoryId)) == null || config.getUnitTypes() == null) {
            return null;
        }
        List<RecruitmentConfig.UnitTypeConfig> unitTypes = config.getUnitTypes().get(categoryId);
        if (unitTypes == null) {
            return null;
        }
        for (RecruitmentConfig.UnitTypeConfig unitType : unitTypes) {
            if (!unitType.getId().equals(unitTypeId)) continue;
            for (RecruitmentConfig.ArmyLevelConfig levelConfig : unitType.getLevels()) {
                if (levelConfig.getLevel() != level) continue;
                return levelConfig;
            }
        }
        return null;
    }

    public static boolean canPlayerRecruit(class_1657 player, String categoryId, String unitTypeId, int level) {
        RecruitmentConfig.ArmyLevelConfig armyConfig = RecruitmentConfigManager.getArmyLevelConfig(categoryId, unitTypeId, level);
        if (armyConfig == null) {
            return false;
        }
        if (!RecruitmentConditionChecker.checkConditions(player, armyConfig)) {
            return false;
        }
        int playerExp = RecruitmentConfigManager.getTotalExperience(player);
        return playerExp >= armyConfig.getExpCost();
    }

    public static List<RecruitmentCategory> getAllCategories() {
        return Arrays.asList(RecruitmentCategory.values());
    }

    private static int getTotalExperience(class_1657 player) {
        int currentExp = (int)(player.field_7510 * (float)player.method_7349()) + RecruitmentConfigManager.getTotalExperienceForLevel(player.field_7520);
        return currentExp;
    }

    private static int getTotalExperienceForLevel(int level) {
        if (level < 0) {
            return 0;
        }
        if (level <= 16) {
            return level * level + 6 * level;
        }
        if (level <= 31) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
    }
}

