/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import ydmsama.hundred_years_war.config.ServerModConfig;
import ydmsama.hundred_years_war.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.utils.ServerRelationHelper;

public class BetterMobCombatIntegration {
    private static boolean isBetterMobCombatLoaded = false;
    private static boolean checkPerformed = false;
    private static Class<?> weaponRegistryClass;
    private static Class<?> weaponAttributesClass;
    private static Class<?> weaponAttributesAttackClass;
    private static Class<?> mobCombatHelperClass;
    private static Class<?> mobTargetFinderClass;
    private static Class<?> attackHandClass;
    private static Class<?> mobAttackHelperClass;
    private static Class<?> mobAttackWindupClass;
    private static Class<?> betterMobCombatClass;
    private static Class<?> bmcServerConfigClass;
    private static Method getAttributesMethod;
    private static Method attacksMethod;
    private static Method processAttackMethod;
    private static Method findAttackTargetsMethod;
    private static Method getCurrentAttackMethod;
    private static Method angleMethod;
    private static Method startUpswingMethod;
    private static Method getServerConfigMethod;
    private static Method updateServerConfigMethod;
    private static Field sameEntityTypeField;

    private static void checkAndLoadBetterMobCombat() {
        if (checkPerformed) {
            return;
        }
        try {
            weaponRegistryClass = Class.forName("net.bettercombat.logic.WeaponRegistry");
            weaponAttributesClass = Class.forName("net.bettercombat.api.WeaponAttributes");
            weaponAttributesAttackClass = Class.forName("net.bettercombat.api.WeaponAttributes$Attack");
            mobCombatHelperClass = Class.forName("me.Thelnfamous1.bettermobcombat.logic.MobCombatHelper");
            mobTargetFinderClass = Class.forName("me.Thelnfamous1.bettermobcombat.logic.MobTargetFinder");
            attackHandClass = Class.forName("net.bettercombat.api.AttackHand");
            mobAttackHelperClass = Class.forName("me.Thelnfamous1.bettermobcombat.logic.MobAttackHelper");
            mobAttackWindupClass = Class.forName("me.Thelnfamous1.bettermobcombat.api.MobAttackWindup");
            betterMobCombatClass = Class.forName("me.Thelnfamous1.bettermobcombat.BetterMobCombat");
            bmcServerConfigClass = Class.forName("me.Thelnfamous1.bettermobcombat.config.BMCServerConfig");
            getAttributesMethod = weaponRegistryClass.getMethod("getAttributes", class_1799.class);
            attacksMethod = weaponAttributesClass.getMethod("attacks", new Class[0]);
            processAttackMethod = mobCombatHelperClass.getMethod("processAttack", class_1937.class, class_1308.class, Integer.TYPE, List.class, BiConsumer.class);
            findAttackTargetsMethod = mobTargetFinderClass.getMethod("findAttackTargets", class_1309.class, class_1297.class, weaponAttributesAttackClass, Double.TYPE);
            getCurrentAttackMethod = mobAttackHelperClass.getMethod("getCurrentAttack", class_1309.class, Integer.TYPE);
            angleMethod = weaponAttributesAttackClass.getMethod("angle", new Class[0]);
            startUpswingMethod = mobAttackWindupClass.getMethod("bettermobcombat$startUpswing", weaponAttributesClass, BiConsumer.class);
            getServerConfigMethod = betterMobCombatClass.getMethod("getServerConfig", new Class[0]);
            updateServerConfigMethod = betterMobCombatClass.getMethod("updateServerConfig", bmcServerConfigClass, Boolean.TYPE);
            sameEntityTypeField = bmcServerConfigClass.getField("mobs_check_for_same_entity_type");
            isBetterMobCombatLoaded = true;
            System.out.println("[HundredYearsWar] Better Mob Combat integration loaded successfully");
            if (ServerModConfig.INSTANCE.isEnableBetterMobCombat()) {
                BetterMobCombatIntegration.disableSameEntityTypeCheck();
            }
        }
        catch (Exception e) {
            isBetterMobCombatLoaded = false;
            System.out.println("[HundredYearsWar] Better Mob Combat not found, using default attack system");
        }
        checkPerformed = true;
    }

    public static boolean isBetterMobCombatLoaded() {
        return isBetterMobCombatLoaded;
    }

    public static boolean isActivated() {
        return BetterMobCombatIntegration.isBetterMobCombatLoaded() && ServerModConfig.INSTANCE.isEnableBetterMobCombat();
    }

    public static boolean isBetterCombatWeapon(class_1799 itemStack) {
        if (!isBetterMobCombatLoaded || itemStack == null || itemStack.method_7960()) {
            return false;
        }
        try {
            Object attributes = getAttributesMethod.invoke(null, itemStack);
            if (attributes == null) {
                return false;
            }
            Object attacks = attacksMethod.invoke(attributes, new Object[0]);
            if (attacks == null) {
                return false;
            }
            if (attacks instanceof Object[]) {
                Object[] attackArray = (Object[])attacks;
                return attackArray.length > 0;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean performBetterMobCombatAttack(BaseCombatEntity entity, class_1309 target) {
        if (!ServerModConfig.INSTANCE.isEnableBetterMobCombat()) {
            return false;
        }
        if (!isBetterMobCombatLoaded || !(entity instanceof class_1308)) {
            return false;
        }
        class_1799 mainHandItem = entity.method_6047();
        try {
            Object weaponAttributes = getAttributesMethod.invoke(null, mainHandItem);
            if (weaponAttributes == null) {
                return false;
            }
            Object attacks = attacksMethod.invoke(weaponAttributes, new Object[0]);
            if (attacks == null) {
                return false;
            }
            BiConsumer<class_1308, class_1297> damageApplicator = (mob, entityTarget) -> {
                if (!(entityTarget instanceof BaseCombatEntity) && !(entityTarget instanceof class_1657) || ServerRelationHelper.isEnemyRelation((class_1297)mob, entityTarget)) {
                    mob.method_6121(entityTarget);
                }
            };
            startUpswingMethod.invoke((Object)entity, weaponAttributes, damageApplicator);
            return true;
        }
        catch (Exception e) {
            System.out.println("[HundredYearsWar] Error during Better Mob Combat attack: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private static void ensureEntityFacesTarget(BaseCombatEntity entity, class_1309 target) {
        double targetX = target.method_23317();
        double targetY = target.method_23318() + (double)target.method_5751() * 0.75;
        double targetZ = target.method_23321();
        entity.method_5988().method_6230(targetX, targetY, targetZ, 10.0f, 90.0f);
    }

    public static void resetComboCount(BaseCombatEntity entity) {
        try {
            Class<?> playerAttackPropertiesClass = Class.forName("net.bettercombat.logic.PlayerAttackProperties");
            if (playerAttackPropertiesClass.isInstance((Object)entity)) {
                Method setComboCountMethod = playerAttackPropertiesClass.getMethod("setComboCount", Integer.TYPE);
                setComboCountMethod.invoke((Object)entity, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isWithinBetterCombatRange(BaseCombatEntity entity, class_1309 target) {
        if (!ServerModConfig.INSTANCE.isEnableBetterMobCombat() || !isBetterMobCombatLoaded) {
            return BetterMobCombatIntegration.isWithinDefaultRange(entity, target);
        }
        if (!BetterMobCombatIntegration.isWithinDefaultRange(entity, target)) {
            return false;
        }
        try {
            Method attackMethod;
            Object attack;
            if (target != null) {
                BetterMobCombatIntegration.ensureEntityFacesTarget(entity, target);
            }
            Class<?> mobCombatHelperClass = Class.forName("me.Thelnfamous1.bettermobcombat.logic.MobCombatHelper");
            Method isWithinAttackRangeMethod = mobCombatHelperClass.getMethod("isWithinAttackRange", class_1309.class, class_1297.class, weaponAttributesAttackClass, Double.TYPE);
            Object attackHand = getCurrentAttackMethod.invoke(null, new Object[]{entity, 0});
            if (attackHand != null && (attack = (attackMethod = attackHandClass.getMethod("attack", new Class[0])).invoke(attackHand, new Object[0])) != null) {
                return (Boolean)isWithinAttackRangeMethod.invoke(null, new Object[]{entity, target, attack, Float.valueOf(entity.getAttackReach())});
            }
        }
        catch (Exception e) {
            System.out.println("[HundredYearsWar] Better Mob Combat range check failed: " + e.getMessage());
        }
        return true;
    }

    private static boolean isWithinDefaultRange(BaseCombatEntity entity, class_1309 target) {
        float attackReach;
        double distanceSq = entity.method_5858((class_1297)target);
        return distanceSq <= (double)((attackReach = entity.getAttackReach()) * attackReach);
    }

    public static void disableSameEntityTypeCheck() {
        if (!isBetterMobCombatLoaded) {
            System.out.println("[HundredYearsWar] Better Mob Combat not loaded, cannot disable same entity type check");
            return;
        }
        if (!ServerModConfig.INSTANCE.isEnableBetterMobCombat()) {
            return;
        }
        try {
            Object currentConfig = getServerConfigMethod.invoke(null, new Object[0]);
            if (currentConfig == null) {
                System.out.println("[HundredYearsWar] Failed to get Better Mob Combat server config");
                return;
            }
            boolean currentSameEntityTypeCheck = sameEntityTypeField.getBoolean(currentConfig);
            if (!currentSameEntityTypeCheck) {
                System.out.println("[HundredYearsWar] Better Mob Combat same entity type checks already disabled");
                return;
            }
            sameEntityTypeField.setBoolean(currentConfig, false);
            updateServerConfigMethod.invoke(null, currentConfig, true);
            System.out.println("[HundredYearsWar] Successfully disabled Better Mob Combat same entity type checks via runtime config modification");
        }
        catch (Exception e) {
            System.out.println("[HundredYearsWar] Failed to modify Better Mob Combat runtime config: " + e.getMessage());
            e.printStackTrace();
        }
    }

    static {
        BetterMobCombatIntegration.checkAndLoadBetterMobCombat();
    }
}

