/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.utils;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import ydmsama.hundred_years_war.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.utils.RelationSystem;

@Environment(value=EnvType.CLIENT)
public class ClientRelationHelper {
    private static ClientRelationHelper instance;
    private final Set<UUID> enemyEntityUUIDs = new HashSet<UUID>();
    private final Set<UUID> sharedControlEntityUUIDs = new HashSet<UUID>();

    private ClientRelationHelper() {
    }

    public static ClientRelationHelper getInstance() {
        if (instance == null) {
            instance = new ClientRelationHelper();
        }
        return instance;
    }

    public void clearRelations() {
        this.enemyEntityUUIDs.clear();
        this.sharedControlEntityUUIDs.clear();
    }

    public void updateEnemyRelations(Set<UUID> enemyUUIDs) {
        this.enemyEntityUUIDs.clear();
        this.enemyEntityUUIDs.addAll(enemyUUIDs);
    }

    public void updateSharedControlRelations(Set<UUID> sharedControlUUIDs) {
        this.sharedControlEntityUUIDs.clear();
        this.sharedControlEntityUUIDs.addAll(sharedControlUUIDs);
    }

    public RelationSystem.RelationType getRelationWithPlayer(class_1297 entity) {
        if (entity instanceof BaseCombatEntity) {
            BaseCombatEntity baseCombatEntity = (BaseCombatEntity)entity;
            UUID entityUUID = baseCombatEntity.getOwnerUUID();
            if (this.enemyEntityUUIDs.contains(entityUUID) || entityUUID == null) {
                return RelationSystem.RelationType.HOSTILE;
            }
            if (this.sharedControlEntityUUIDs.contains(entityUUID) || entityUUID.equals(class_310.method_1551().field_1724.method_5667())) {
                return RelationSystem.RelationType.CONTROL;
            }
        }
        return RelationSystem.RelationType.NEUTRAL;
    }
}

