/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_7923;

public class ExpBlacklistManager {
    private static List<String> expBlacklist = new ArrayList<String>();

    public static void loadExpBlacklist() {
        File expBlacklistFile;
        File configDir = new File("config/hundredyearswar");
        if (!configDir.exists()) {
            configDir.mkdirs();
            System.out.println("\u521b\u5efa\u76ee\u5f55: config/hundredyearswar");
        }
        if (!(expBlacklistFile = new File("config/hundredyearswar/exp_blacklist.json5")).exists()) {
            System.out.println("exp_blacklist.json5\u4e0d\u5b58\u5728\uff0c\u521b\u5efa\u9ed8\u8ba4\u7ecf\u9a8c\u9ed1\u540d\u5355");
            ExpBlacklistManager.createDefaultExpBlacklist(expBlacklistFile);
        } else {
            System.out.println("\u627e\u5230\u73b0\u6709exp_blacklist.json5");
        }
        try (FileReader reader = new FileReader(expBlacklistFile);){
            int length;
            StringBuilder content = new StringBuilder();
            char[] buffer = new char[1024];
            while ((length = reader.read(buffer)) != -1) {
                content.append(buffer, 0, length);
            }
            String jsonContent = content.toString().replaceAll("//.*", "");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            expBlacklist = (List)gson.fromJson(jsonContent, new TypeToken<List<String>>(){}.getType());
            System.out.println("\u6210\u529f\u52a0\u8f7d\u7ecf\u9a8c\u9ed1\u540d\u5355: " + expBlacklist);
        }
        catch (IOException e) {
            System.err.println("\u52a0\u8f7dexp_blacklist.json5\u65f6\u51fa\u9519: " + e.getMessage());
            e.printStackTrace();
            expBlacklist = new ArrayList<String>();
        }
    }

    private static void createDefaultExpBlacklist(File expBlacklistFile) {
        try {
            ArrayList<String> defaultBlacklist = new ArrayList<String>();
            defaultBlacklist.add("minecraft:silverfish");
            try (FileWriter writer = new FileWriter(expBlacklistFile);){
                writer.write("// Experience blacklist - these entities won't grant experience when killed by units\n");
                writer.write("// Format: \"namespace:entity_id\"\n");
                writer.write("// Example: \"minecraft:silverfish\" for silverfish\n");
                writer.write("[\n");
                for (int i = 0; i < defaultBlacklist.size(); ++i) {
                    writer.write("  \"" + (String)defaultBlacklist.get(i) + "\"");
                    if (i < defaultBlacklist.size() - 1) {
                        writer.write(",");
                    }
                    writer.write("\n");
                }
                writer.write("]\n");
            }
            expBlacklist = defaultBlacklist;
            System.out.println("\u5df2\u521b\u5efa\u9ed8\u8ba4\u7ecf\u9a8c\u9ed1\u540d\u5355: " + defaultBlacklist);
        }
        catch (IOException e) {
            e.printStackTrace();
            expBlacklist = new ArrayList<String>();
        }
    }

    public static boolean isInExpBlacklist(class_1309 entity) {
        if (entity == null) {
            return false;
        }
        String entityIdString = class_7923.field_41177.method_10221((Object)entity.method_5864()).toString();
        return expBlacklist.contains(entityIdString);
    }

    public static List<String> getExpBlacklist() {
        return new ArrayList<String>(expBlacklist);
    }

    public static void addToBlacklist(String entityId) {
        if (!expBlacklist.contains(entityId)) {
            expBlacklist.add(entityId);
        }
    }

    public static void removeFromBlacklist(String entityId) {
        expBlacklist.remove(entityId);
    }
}

