/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.utils;

import com.google.common.collect.Multimap;
import net.minecraft.class_1304;
import net.minecraft.class_1743;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1819;
import net.minecraft.class_1829;
import net.minecraft.class_3489;
import net.minecraft.class_5134;
import ydmsama.hundred_years_war.item.PikeItem;
import ydmsama.hundred_years_war.registry.HywItemRegistry;

public class WeaponTypeHelper {
    public static boolean isSwordLikeWeapon(class_1799 itemStack) {
        String itemName;
        if (itemStack.method_7960()) {
            return false;
        }
        class_1792 item = itemStack.method_7909();
        if (item instanceof class_1829 && !(item instanceof PikeItem)) {
            return true;
        }
        if (itemStack.method_31573(class_3489.field_42611)) {
            return true;
        }
        String className = item.getClass().getName();
        if (className.contains("tconstruct") && (className.contains("sword") || className.contains("blade"))) {
            return true;
        }
        return WeaponTypeHelper.hasAttackDamageAttribute(itemStack) && !WeaponTypeHelper.isToolLikeItem(itemStack) && ((itemName = itemStack.method_7954().getString().toLowerCase()).contains("sword") || itemName.contains("blade") || itemName.contains("\u5251") || itemName.contains("\u5200") || itemName.contains("katana") || itemName.contains("rapier"));
    }

    public static boolean isAxeLikeWeapon(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return false;
        }
        class_1792 item = itemStack.method_7909();
        if (item instanceof class_1743) {
            return true;
        }
        if (itemStack.method_31573(class_3489.field_42612)) {
            return true;
        }
        String className = item.getClass().getName();
        if (className.contains("tconstruct") && className.contains("axe")) {
            return true;
        }
        String itemName = itemStack.method_7954().getString().toLowerCase();
        return itemName.contains("axe") || itemName.contains("\u65a7") || itemName.contains("hatchet");
    }

    public static boolean isBowLikeWeapon(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return false;
        }
        class_1792 item = itemStack.method_7909();
        if (item instanceof class_1753) {
            return true;
        }
        if (item instanceof class_1811 && !(item instanceof class_1764)) {
            return true;
        }
        String className = item.getClass().getName();
        if (className.contains("tconstruct") && (className.contains("bow") || className.contains("crossbow"))) {
            return true;
        }
        String itemName = itemStack.method_7954().getString().toLowerCase();
        return itemName.contains("bow") || itemName.contains("\u5f13") || itemName.contains("longbow") || itemName.contains("shortbow");
    }

    public static boolean isCrossbowLikeWeapon(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return false;
        }
        class_1792 item = itemStack.method_7909();
        if (item instanceof class_1764) {
            return true;
        }
        String className = item.getClass().getName();
        if (className.contains("tconstruct") && className.contains("crossbow")) {
            return true;
        }
        String itemName = itemStack.method_7954().getString().toLowerCase();
        return itemName.contains("crossbow") || itemName.contains("\u5f29");
    }

    public static boolean isPikeLikeWeapon(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return false;
        }
        class_1792 item = itemStack.method_7909();
        if (item instanceof PikeItem) {
            return true;
        }
        String className = item.getClass().getName();
        if (className.contains("tconstruct") && (className.contains("pike") || className.contains("spear"))) {
            return true;
        }
        String itemName = itemStack.method_7954().getString().toLowerCase();
        return itemName.contains("pike") || itemName.contains("spear") || itemName.contains("\u957f\u77db") || itemName.contains("\u67aa");
    }

    public static boolean isLanceLikeWeapon(class_1799 itemStack) {
        boolean isLance;
        if (itemStack.method_7960()) {
            return false;
        }
        boolean bl = isLance = itemStack.method_31574(HywItemRegistry.WOODEN_LANCE) || itemStack.method_31574(HywItemRegistry.IRON_LANCE) || itemStack.method_31574(HywItemRegistry.GOLDEN_LANCE) || itemStack.method_31574(HywItemRegistry.DIAMOND_LANCE);
        if (isLance) {
            return true;
        }
        String className = itemStack.method_7909().getClass().getName();
        if (className.contains("tconstruct") && className.contains("lance")) {
            return true;
        }
        String itemName = itemStack.method_7954().getString().toLowerCase();
        return itemName.contains("lance") || itemName.contains("\u957f\u77db") || itemName.contains("\u9a91\u67aa");
    }

    public static boolean isShieldLikeItem(class_1799 itemStack) {
        if (itemStack.method_7960()) {
            return false;
        }
        class_1792 item = itemStack.method_7909();
        if (item instanceof class_1819) {
            return true;
        }
        String className = item.getClass().getName();
        if (className.contains("tconstruct") && className.contains("shield")) {
            return true;
        }
        String itemName = itemStack.method_7954().getString().toLowerCase();
        return itemName.contains("shield") || itemName.contains("\u76fe");
    }

    public static boolean isSameWeaponType(class_1799 item1, class_1799 item2) {
        if (item1.method_7960() || item2.method_7960()) {
            return false;
        }
        if (WeaponTypeHelper.isSwordLikeWeapon(item1) && WeaponTypeHelper.isSwordLikeWeapon(item2)) {
            return true;
        }
        if (WeaponTypeHelper.isPikeLikeWeapon(item1) && WeaponTypeHelper.isPikeLikeWeapon(item2)) {
            return true;
        }
        if (WeaponTypeHelper.isBowLikeWeapon(item1) && WeaponTypeHelper.isBowLikeWeapon(item2)) {
            return true;
        }
        if (WeaponTypeHelper.isAxeLikeWeapon(item1) && WeaponTypeHelper.isAxeLikeWeapon(item2)) {
            return true;
        }
        if (WeaponTypeHelper.isCrossbowLikeWeapon(item1) && WeaponTypeHelper.isCrossbowLikeWeapon(item2)) {
            return true;
        }
        if (WeaponTypeHelper.isLanceLikeWeapon(item1) && WeaponTypeHelper.isLanceLikeWeapon(item2)) {
            return true;
        }
        return WeaponTypeHelper.isShieldLikeItem(item1) && WeaponTypeHelper.isShieldLikeItem(item2);
    }

    private static boolean hasAttackDamageAttribute(class_1799 itemStack) {
        try {
            Multimap attributes = itemStack.method_7926(class_1304.field_6173);
            return attributes.containsKey((Object)class_5134.field_23721);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isToolLikeItem(class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        if (item instanceof class_1766) {
            return true;
        }
        return itemStack.method_31573(class_3489.field_42614) || itemStack.method_31573(class_3489.field_42615) || itemStack.method_31573(class_3489.field_42613);
    }
}

