/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.mixins;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.gui.Gui;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class})
public class GuiOverlayMessageMixin {
    private static String lastBaseMessage = null;
    private static Component lastComponent = null;
    private static int messageCount = 1;
    private static long lastMessageTime = 0L;
    private static final long MESSAGE_TIMEOUT = 3000L;
    private static final Pattern COUNT_PATTERN = Pattern.compile("^(.*?)(?:\\*\\d+)?$");
    @Shadow
    private Component f_92990_;
    @Shadow
    private int f_92991_;

    private String extractBaseMessage(String message) {
        Matcher matcher = COUNT_PATTERN.matcher(message);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return message;
    }

    private Component addCountToLastSibling(Component original, int count) {
        if (original.m_7360_().isEmpty()) {
            MutableComponent countedComponent = original.m_6881_();
            String text = countedComponent.getString();
            String baseText = this.extractBaseMessage(text);
            String withCount = baseText + "*" + count;
            return Component.m_237113_((String)withCount).m_6270_(original.m_7383_());
        }
        MutableComponent result = original.m_6881_();
        result.m_7360_().clear();
        for (int i = 0; i < original.m_7360_().size() - 1; ++i) {
            result.m_7220_((Component)((Component)original.m_7360_().get(i)).m_6881_());
        }
        Component lastSibling = (Component)original.m_7360_().get(original.m_7360_().size() - 1);
        Component countedLastSibling = this.addCountToLastSibling(lastSibling, count);
        result.m_7220_(countedLastSibling);
        return result;
    }

    @Inject(method={"setOverlayMessage"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetOverlayMessage(Component component, boolean bl, CallbackInfo ci) {
        long currentTime = System.currentTimeMillis();
        String currentMessage = component.getString();
        String baseMessage = this.extractBaseMessage(currentMessage);
        if (currentTime - lastMessageTime > 3000L) {
            messageCount = 1;
            lastBaseMessage = null;
            lastComponent = null;
        }
        if (lastBaseMessage != null && baseMessage.equals(lastBaseMessage)) {
            Component countedMessage;
            this.f_92990_ = countedMessage = this.addCountToLastSibling(lastComponent, ++messageCount);
            this.f_92991_ = 60;
            lastMessageTime = currentTime;
            ci.cancel();
        } else {
            messageCount = 1;
            lastBaseMessage = baseMessage;
            lastComponent = component;
            lastMessageTime = currentTime;
        }
    }
}

