/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.mixins;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.client.freecam.config.ClientModConfig;
import ydmsama.hundred_years_war.client.freecam.selection.SelectionHandler;
import ydmsama.hundred_years_war.client.freecam.selection.TargetInfo;
import ydmsama.hundred_years_war.client.freecam.ui.wheel.CommandWheelHandler;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.siege.PositionAttackable;

@Mixin(value={LevelRenderer.class})
public abstract class LevelRendererMixin {
    @Shadow
    @Final
    private RenderBuffers f_109464_;
    @Unique
    private static final int TARGET_REMOVAL_CHECK_INTERVAL = 5;
    @Unique
    private int frameCounter = 0;
    @Unique
    private final Map<Entity, Map<TargetInfo, Long>> pendingRemovals = new HashMap<Entity, Map<TargetInfo, Long>>();

    @Shadow
    private void m_109517_(Entity entity, double cameraX, double cameraY, double cameraZ, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers) {
    }

    @Shadow
    protected abstract ParticleStatus m_109767_(boolean var1);

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;checkPoseStack(Lcom/mojang/blaze3d/vertex/PoseStack;)V", ordinal=0)})
    private void onRender(PoseStack matrices, float tickDelta, long limitTime, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f positionMatrix, CallbackInfo ci) {
        double minDistance;
        double thresholdSquared;
        Vec3 playerPos;
        Vec3 cameraPos;
        double distanceSquared;
        if (Freecam.isEnabled() && Freecam.MC.f_91072_.m_105295_() != GameType.SURVIVAL && ClientModConfig.INSTANCE.visual.showPlayer && (distanceSquared = (cameraPos = camera.m_90583_()).m_82557_(playerPos = Freecam.MC.f_91074_.m_146892_())) > (thresholdSquared = (minDistance = ClientModConfig.INSTANCE.visual.playerRenderMinDistance) * minDistance)) {
            this.m_109517_((Entity)Freecam.MC.f_91074_, cameraPos.f_82479_, cameraPos.f_82480_, cameraPos.f_82481_, tickDelta, matrices, (MultiBufferSource)this.f_109464_.m_110104_());
        }
    }

    @Inject(method={"renderEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderEntity(Entity entity, double cameraX, double cameraY, double cameraZ, float tickDelta, PoseStack matrices, MultiBufferSource bufferSource, CallbackInfo ci) {
        Vec3 entityPos;
        double minDistance;
        double thresholdSquared;
        double distanceSquared;
        Vec3 cameraPos;
        if (!Freecam.isEnabled()) {
            return;
        }
        if (entity == Freecam.MC.f_91074_) {
            if (Freecam.MC.f_91072_.m_105295_() == GameType.SURVIVAL) {
                ci.cancel();
                return;
            }
            if (ClientModConfig.INSTANCE.visual.showPlayer) {
                Vec3 playerPos;
                cameraPos = Freecam.MC.f_91063_.m_109153_().m_90583_();
                distanceSquared = cameraPos.m_82557_(playerPos = Freecam.MC.f_91074_.m_146892_());
                if (distanceSquared <= (thresholdSquared = (minDistance = ClientModConfig.INSTANCE.visual.playerRenderMinDistance) * minDistance)) {
                    ci.cancel();
                }
            } else {
                ci.cancel();
            }
        }
        if (entity instanceof BaseCombatEntity && (distanceSquared = (cameraPos = Freecam.MC.f_91063_.m_109153_().m_90583_()).m_82557_(entityPos = entity.m_146892_())) <= (thresholdSquared = (minDistance = ClientModConfig.INSTANCE.visual.playerRenderMinDistance) * minDistance)) {
            ci.cancel();
        }
    }

    @Inject(method={"renderLevel"}, at={@At(value="HEAD")})
    private void onRenderLevel(PoseStack poseStack, float f, long l, boolean bl, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f matrix4f, CallbackInfo ci) {
        ++this.frameCounter;
        if (this.frameCounter >= 5) {
            this.frameCounter = 0;
            this.processTargetRemoval();
        }
        this.renderEntityTargets(poseStack, camera);
    }

    @Unique
    private void processTargetRemoval() {
        CopyOnWriteArraySet<TargetInfo> targets;
        Entity entity;
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return;
        }
        Map<Entity, CopyOnWriteArraySet<TargetInfo>> targetMap = SelectionHandler.getInstance().getCombinedTargetMap();
        if (targetMap.isEmpty()) {
            return;
        }
        HashMap<String, List> formationMap = new HashMap<String, List>();
        for (Map.Entry<Entity, CopyOnWriteArraySet<TargetInfo>> entry : targetMap.entrySet()) {
            entity = entry.getKey();
            if (!(entity instanceof BaseCombatEntity) || (targets = entry.getValue()) == null) continue;
            for (TargetInfo target : targets) {
                String type = target.getType();
                if (!"formTarget".equals(type) && !"formAttackTarget".equals(type)) continue;
                BlockPos targetPos = target.getPosition();
                String formationKey = type + "_" + targetPos.m_123344_();
                formationMap.computeIfAbsent(formationKey, k -> new ArrayList()).add(entity);
            }
        }
        for (Map.Entry<Entity, CopyOnWriteArraySet<TargetInfo>> entry : targetMap.entrySet()) {
            entity = entry.getKey();
            if (!(entity instanceof BaseCombatEntity) || (targets = entry.getValue()) == null || targets.isEmpty()) continue;
            Vec3 formationCenter = entity.m_20182_();
            List formationEntities = Collections.singletonList(entity);
            for (Map.Entry formationEntry : formationMap.entrySet()) {
                if (!((List)formationEntry.getValue()).contains(entity)) continue;
                formationEntities = (List)formationEntry.getValue();
                formationCenter = this.calculateCenterPosition(formationEntities);
                break;
            }
            this.processTargetRemovalForEntity(entity, targets, formationCenter, formationEntities);
        }
    }

    @Unique
    private void processTargetRemovalForEntity(Entity entity, CopyOnWriteArraySet<TargetInfo> targets, Vec3 formationCenter, List<Entity> formationEntities) {
        Iterator<TargetInfo> iterator;
        if (this.pendingRemovals.containsKey(entity)) {
            Map<TargetInfo, Long> removalMap = this.pendingRemovals.get(entity);
            long currentTime = System.currentTimeMillis();
            Iterator<Map.Entry<TargetInfo, Long>> entryIterator = removalMap.entrySet().iterator();
            while (entryIterator.hasNext()) {
                long timeout;
                Map.Entry<TargetInfo, Long> entry = entryIterator.next();
                String type = entry.getKey().getType();
                long l = timeout = (Objects.equals(type, "formTarget") || Objects.equals(type, "formAttackTarget")) && formationEntities.size() > 1 ? 1500L : 500L;
                if (currentTime - entry.getValue() <= timeout) continue;
                targets.remove(entry.getKey());
                entryIterator.remove();
            }
            if (removalMap.isEmpty()) {
                this.pendingRemovals.remove(entity);
            }
        }
        if (!targets.isEmpty() && (iterator = targets.iterator()).hasNext()) {
            TargetInfo firstTarget = iterator.next();
            BlockPos pos = firstTarget.getPosition();
            String type = firstTarget.getType();
            if (!Objects.equals(type, "entityTarget") && !Objects.equals(type, "followTarget")) {
                Vec3 targetPos = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + 0.5);
                if (!Objects.equals(type, "formTarget") && !Objects.equals(type, "formAttackTarget")) {
                    double distance = this.calculateHorizontalDistance(entity.m_20182_(), targetPos);
                    if (!(!(distance < Math.max(((BaseCombatEntity)entity).getArrivalThreshold() * 1.2, 1.0)) || this.pendingRemovals.containsKey(entity) && this.pendingRemovals.get(entity).containsKey(firstTarget))) {
                        this.pendingRemovals.computeIfAbsent(entity, k -> new HashMap()).put(firstTarget, System.currentTimeMillis());
                    }
                } else {
                    double threshold;
                    double distance = this.calculateHorizontalDistance(formationCenter, targetPos);
                    if (!(!(distance < (threshold = this.calculateFormationThreshold(formationEntities))) || this.pendingRemovals.containsKey(entity) && this.pendingRemovals.get(entity).containsKey(firstTarget))) {
                        this.pendingRemovals.computeIfAbsent(entity, k -> new HashMap()).put(firstTarget, System.currentTimeMillis());
                    }
                }
            }
        }
        targets.removeIf(target -> {
            String type = target.getType();
            if (Objects.equals(type, "entityTarget") || Objects.equals(type, "followTarget")) {
                Entity targetEntity = target.getHywTarget();
                return !targetEntity.m_6084_();
            }
            return false;
        });
    }

    @Unique
    private void renderEntityTargets(PoseStack poseStack, Camera camera) {
        boolean shouldRender;
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return;
        }
        boolean bl = shouldRender = Freecam.isEnabled() || CommandWheelHandler.getInstance().shouldRenderCommandEffect();
        if (!shouldRender) {
            return;
        }
        HashMap<String, List> formationMap = new HashMap<String, List>();
        for (Entity entity : level.m_104735_()) {
            if (!(entity instanceof BaseCombatEntity)) continue;
            BaseCombatEntity baseEntity = (BaseCombatEntity)entity;
            CopyOnWriteArraySet<TargetInfo> targets = SelectionHandler.getInstance().getCombinedTargetMap().get(entity);
            if (targets == null) continue;
            for (TargetInfo targetInfo : targets) {
                String type = targetInfo.getType();
                if (!"formTarget".equals(type) && !"formAttackTarget".equals(type)) continue;
                BlockPos targetPos = targetInfo.getPosition();
                String formationKey = type + "_" + targetPos.m_123344_();
                formationMap.computeIfAbsent(formationKey, k -> new ArrayList()).add(entity);
            }
        }
        HashSet<BlockPos> renderedPositions = new HashSet<BlockPos>();
        for (Map.Entry entry : formationMap.entrySet()) {
            List formationEntities = (List)entry.getValue();
            Vec3 formationCenter = this.calculateCenterPosition(formationEntities);
            for (Entity entity : formationEntities) {
                CopyOnWriteArraySet<TargetInfo> targets = SelectionHandler.getInstance().getCombinedTargetMap().get(entity);
                if (targets == null) continue;
                this.renderTargetPositions(poseStack, entity, targets, formationCenter, renderedPositions, formationEntities);
            }
        }
        for (Entity entity : level.m_104735_()) {
            BlockPos bombardTarget;
            SelectionHandler selectionHandler;
            CopyOnWriteArraySet<TargetInfo> copyOnWriteArraySet;
            if (!(entity instanceof BaseCombatEntity)) continue;
            BaseCombatEntity baseEntity = (BaseCombatEntity)entity;
            boolean inFormation = formationMap.values().stream().anyMatch(list -> list.contains(entity));
            if (!inFormation && (copyOnWriteArraySet = SelectionHandler.getInstance().getCombinedTargetMap().get(entity)) != null) {
                List<Entity> singleEntityList = Collections.singletonList(entity);
                this.renderTargetPositions(poseStack, entity, copyOnWriteArraySet, entity.m_20182_(), renderedPositions, singleEntityList);
            }
            if ((selectionHandler = SelectionHandler.getInstance()).getPatrolPointsMap().containsKey(entity)) {
                this.renderPatrolPositions(poseStack, entity, selectionHandler.getPatrolPointsMap().get(entity));
            }
            if (!(entity instanceof PositionAttackable) || !selectionHandler.getSelectedEntities().contains(entity) || (bombardTarget = selectionHandler.getBombardTarget(entity)) == null) continue;
            this.renderBombardTarget(poseStack, entity, bombardTarget);
        }
    }

    @Unique
    public double calculateHorizontalDistance(Vec3 pos1, Vec3 pos2) {
        return Math.sqrt(Math.pow(pos1.m_7096_() - pos2.m_7096_(), 2.0) + Math.pow(pos1.m_7094_() - pos2.m_7094_(), 2.0));
    }

    @Unique
    private Vec3 calculateCenterPosition(List<Entity> selectedEntities) {
        if (selectedEntities.isEmpty()) {
            return Vec3.f_82478_;
        }
        double sumX = 0.0;
        double sumY = 0.0;
        double sumZ = 0.0;
        for (Entity entity : selectedEntities) {
            Vec3 entityPos = entity.m_20182_();
            sumX += entityPos.f_82479_;
            sumY += entityPos.f_82480_;
            sumZ += entityPos.f_82481_;
        }
        double centerX = sumX / (double)selectedEntities.size();
        double centerY = sumY / (double)selectedEntities.size();
        double centerZ = sumZ / (double)selectedEntities.size();
        return new Vec3(centerX, centerY, centerZ);
    }

    @Unique
    private void renderPatrolPositions(PoseStack poseStack, Entity entity, CopyOnWriteArrayList<BlockPos> patrolPoints) {
        boolean shouldRender;
        SelectionHandler selectionHandler = SelectionHandler.getInstance();
        List<Entity> selectedEntities = selectionHandler.getSelectedEntities();
        boolean bl = shouldRender = Freecam.isEnabled() || CommandWheelHandler.getInstance().shouldRenderCommandEffect();
        if (selectedEntities.contains(entity) && shouldRender) {
            Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
            Vec3 cameraPos = camera.m_90583_();
            VertexConsumer vertexConsumer = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110504_());
            Vec3 previousPos = null;
            for (BlockPos patrolPoint : patrolPoints) {
                Vec3 targetPos = new Vec3((double)patrolPoint.m_123341_() + 0.5, (double)patrolPoint.m_123342_() + 1.1, (double)patrolPoint.m_123343_() + 0.5);
                Vec3 centerPos = targetPos.m_82546_(cameraPos);
                double outerMinX = centerPos.m_7096_() - 0.5;
                double outerMinZ = centerPos.m_7094_() - 0.5;
                double outerMaxX = centerPos.m_7096_() + 0.5;
                double outerMaxZ = centerPos.m_7094_() + 0.5;
                double innerMinX = centerPos.m_7096_() - 0.3;
                double innerMinZ = centerPos.m_7094_() - 0.3;
                double innerMaxX = centerPos.m_7096_() + 0.3;
                double innerMaxZ = centerPos.m_7094_() + 0.3;
                AABB outerBox = new AABB(outerMinX, centerPos.m_7098_(), outerMinZ, outerMaxX, centerPos.m_7098_(), outerMaxZ);
                AABB innerBox = new AABB(innerMinX, centerPos.m_7098_(), innerMinZ, innerMaxX, centerPos.m_7098_(), innerMaxZ);
                float r = 0.0f;
                float g = 0.0f;
                float b = 1.0f;
                LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (double)outerBox.f_82288_, (double)outerBox.f_82289_, (double)outerBox.f_82290_, (double)outerBox.f_82291_, (double)outerBox.f_82292_, (double)outerBox.f_82293_, (float)r, (float)g, (float)b, (float)1.0f);
                LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (double)innerBox.f_82288_, (double)innerBox.f_82289_, (double)innerBox.f_82290_, (double)innerBox.f_82291_, (double)innerBox.f_82292_, (double)innerBox.f_82293_, (float)r, (float)g, (float)b, (float)1.0f);
                if (previousPos != null) {
                    Matrix3f normalMatrix = poseStack.m_85850_().m_252943_();
                    vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), (float)previousPos.m_7096_(), (float)previousPos.m_7098_(), (float)previousPos.m_7094_()).m_85950_(r, g, b, 1.0f).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
                    vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), (float)centerPos.m_7096_(), (float)centerPos.m_7098_(), (float)centerPos.m_7094_()).m_85950_(r, g, b, 1.0f).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
                }
                previousPos = centerPos;
            }
        }
    }

    @Unique
    private double calculateFormationThreshold(List<Entity> formationEntities) {
        if (formationEntities.size() == 1) {
            Entity entity = formationEntities.get(0);
            if (entity instanceof BaseCombatEntity) {
                return Math.max(((BaseCombatEntity)entity).getArrivalThreshold() * 1.2, 1.0);
            }
            return 1.0;
        }
        return 8.0;
    }

    @Unique
    private void renderBombardTarget(PoseStack poseStack, Entity entity, BlockPos bombardTarget) {
        boolean shouldRender;
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        VertexConsumer vertexConsumer = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110504_());
        boolean bl = shouldRender = Freecam.isEnabled() || CommandWheelHandler.getInstance().shouldRenderCommandEffect();
        if (SelectionHandler.getInstance().getSelectedEntities().contains(entity) && shouldRender) {
            Vec3 centerPos = new Vec3((double)bombardTarget.m_123341_() + 0.5, (double)bombardTarget.m_123342_() + 0.5, (double)bombardTarget.m_123343_() + 0.5).m_82546_(cameraPos);
            float smallSize = 0.5f;
            float mediumSize = 1.0f;
            float largeSize = 1.5f;
            float red = 1.0f;
            float green = 0.0f;
            float blue = 0.0f;
            float alpha = 1.0f;
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (double)(centerPos.f_82479_ - (double)smallSize), (double)(centerPos.f_82480_ - (double)smallSize), (double)(centerPos.f_82481_ - (double)smallSize), (double)(centerPos.f_82479_ + (double)smallSize), (double)(centerPos.f_82480_ + (double)smallSize), (double)(centerPos.f_82481_ + (double)smallSize), (float)red, (float)green, (float)blue, (float)alpha);
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (double)(centerPos.f_82479_ - (double)largeSize), (double)(centerPos.f_82480_ - (double)largeSize), (double)(centerPos.f_82481_ - (double)largeSize), (double)(centerPos.f_82479_ + (double)largeSize), (double)(centerPos.f_82480_ + (double)largeSize), (double)(centerPos.f_82481_ + (double)largeSize), (float)red, (float)green, (float)blue, (float)alpha);
        }
    }

    @Unique
    private void renderTargetPositions(PoseStack poseStack, Entity entity, CopyOnWriteArraySet<TargetInfo> targets, Vec3 formationCenter, Set<BlockPos> renderedPositions, List<Entity> formationEntities) {
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        VertexConsumer vertexConsumer = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110504_());
        AtomicReference<Vec3> entityPreviousPos = new AtomicReference<Vec3>(entity.m_20182_().m_82546_(cameraPos));
        AtomicReference<Vec3> previousPos = new AtomicReference<Vec3>(new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()).m_82546_(cameraPos));
        for (TargetInfo target : targets) {
            float b;
            float g;
            float r;
            Entity targetEntity;
            boolean shouldRender;
            BlockPos pos = target.getPosition();
            String type = target.getType();
            if (!Objects.equals(type, "entityTarget") && !Objects.equals(type, "followTarget")) {
                float b2;
                float g2;
                float r2;
                boolean shouldRender2;
                Vec3 targetPos = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + 0.5);
                SelectionHandler selectionHandler = SelectionHandler.getInstance();
                List<Entity> selectedEntities = selectionHandler.getSelectedEntities();
                boolean bl = shouldRender2 = Freecam.isEnabled() || CommandWheelHandler.getInstance().shouldRenderCommandEffect();
                if (!selectedEntities.contains(entity) || !shouldRender2) continue;
                Vec3 centerPos = targetPos.m_82546_(cameraPos);
                double outerMinX = centerPos.m_7096_() - 0.5;
                double outerMinZ = centerPos.m_7094_() - 0.5;
                double outerMaxX = centerPos.m_7096_() + 0.5;
                double outerMaxZ = centerPos.m_7094_() + 0.5;
                double innerMinX = centerPos.m_7096_() - 0.3;
                double innerMinZ = centerPos.m_7094_() - 0.3;
                double innerMaxX = centerPos.m_7096_() + 0.3;
                double innerMaxZ = centerPos.m_7094_() + 0.3;
                AABB outerBox = new AABB(outerMinX, centerPos.m_7098_(), outerMinZ, outerMaxX, centerPos.m_7098_(), outerMaxZ);
                AABB innerBox = new AABB(innerMinX, centerPos.m_7098_(), innerMinZ, innerMaxX, centerPos.m_7098_(), innerMaxZ);
                if (Objects.equals(type, "target") || Objects.equals(type, "formTarget")) {
                    r2 = 0.0f;
                    g2 = 1.0f;
                    b2 = 0.0f;
                } else {
                    r2 = 1.0f;
                    g2 = 0.0f;
                    b2 = 0.0f;
                }
                if (!renderedPositions.contains(pos)) {
                    LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (double)outerBox.f_82288_, (double)outerBox.f_82289_, (double)outerBox.f_82290_, (double)outerBox.f_82291_, (double)outerBox.f_82292_, (double)outerBox.f_82293_, (float)r2, (float)g2, (float)b2, (float)1.0f);
                    LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (double)innerBox.f_82288_, (double)innerBox.f_82289_, (double)innerBox.f_82290_, (double)innerBox.f_82291_, (double)innerBox.f_82292_, (double)innerBox.f_82293_, (float)r2, (float)g2, (float)b2, (float)1.0f);
                    renderedPositions.add(pos);
                }
                if (previousPos != null && previousPos.get() != null) {
                    Matrix3f normalMatrix = poseStack.m_85850_().m_252943_();
                    vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), (float)previousPos.get().m_7096_(), (float)previousPos.get().m_7098_(), (float)previousPos.get().m_7094_()).m_85950_(r2, g2, b2, 1.0f).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
                    vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), (float)centerPos.m_7096_(), (float)centerPos.m_7098_(), (float)centerPos.m_7094_()).m_85950_(r2, g2, b2, 1.0f).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
                }
                previousPos.set(centerPos);
                entityPreviousPos.set(centerPos);
                continue;
            }
            SelectionHandler selectionHandler = SelectionHandler.getInstance();
            List<Entity> selectedEntities = selectionHandler.getSelectedEntities();
            boolean bl = shouldRender = Freecam.isEnabled() || CommandWheelHandler.getInstance().shouldRenderCommandEffect();
            if (!selectedEntities.contains(entity) || !shouldRender || !(targetEntity = target.getHywTarget()).m_6084_()) continue;
            Vec3 entityPos = targetEntity.m_20182_().m_82546_(cameraPos);
            if (Objects.equals(type, "entityTarget")) {
                r = 1.0f;
                g = 0.0f;
                b = 0.0f;
            } else if (Objects.equals(type, "followTarget")) {
                r = 0.0f;
                g = 1.0f;
                b = 0.0f;
            } else {
                r = 0.0f;
                g = 1.0f;
                b = 0.0f;
            }
            if (entityPreviousPos.get() != null) {
                Matrix3f normalMatrix = poseStack.m_85850_().m_252943_();
                vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), (float)entityPreviousPos.get().m_7096_(), (float)entityPreviousPos.get().m_7098_(), (float)entityPreviousPos.get().m_7094_()).m_85950_(r, g, b, 1.0f).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
                vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), (float)entityPos.m_7096_(), (float)entityPos.m_7098_(), (float)entityPos.m_7094_()).m_85950_(r, g, b, 1.0f).m_252939_(normalMatrix, 0.0f, 1.0f, 0.0f).m_5752_();
            }
            entityPreviousPos.set(entityPos);
            previousPos.set(new Vec3(targetEntity.m_20185_(), targetEntity.m_20186_(), targetEntity.m_20189_()).m_82546_(cameraPos));
        }
    }
}

