/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.mixins;

import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.client.freecam.config.keys.HotKeyManager;
import ydmsama.hundred_years_war.client.freecam.mixins.KeyMappingAccessor;
import ydmsama.hundred_years_war.client.freecam.selection.SelectionHandler;
import ydmsama.hundred_years_war.client.freecam.ui.UIButtonOverlay;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.client.structure.BuildModeHandler;
import ydmsama.hundred_years_war.main.blocks.BaseStructureCoreBlockEntity;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;

@Mixin(value={MouseHandler.class})
public class MouseHandlerMixin {
    @Shadow
    @Final
    private Minecraft f_91503_;
    @Shadow
    private boolean f_91520_;
    @Unique
    private long leftMousePressTime = 0L;
    @Unique
    private long lastClickTime = 0L;
    @Unique
    private static final long DOUBLE_CLICK_THRESHOLD = 200L;
    @Unique
    private final int pickRange = 200;

    @Inject(method={"onPress"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCustomPress(long window, int button, int action, int mods, CallbackInfo ci) {
        if (this.f_91503_.m_91268_().m_85439_() == window && this.f_91503_.f_91080_ == null && Freecam.isEnabled()) {
            double mouseY;
            double mouseX;
            if (button == 0 && action == 1 && UIButtonOverlay.handleClick(mouseX = ((MouseHandler)this).m_91589_(), mouseY = ((MouseHandler)this).m_91594_())) {
                ci.cancel();
                return;
            }
            if (BuildModeHandler.isBuildModeEnabled()) {
                this.handleBuildModeAction(action, button, ci);
            } else {
                this.handleSelectAndConfirmAction(action, button, ci);
            }
            this.handleMoveAndCancelAction(action, button);
            ci.cancel();
        }
    }

    @Inject(method={"onScroll"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCustomScroll(long window, double xoffset, double yoffset, CallbackInfo ci) {
        if (Freecam.isEnabled()) {
            Freecam.setSpeedMultiplier(Freecam.getSpeedMultiplier() + yoffset * 0.1);
            Freecam.setSpeedMultiplier(Math.max(0.1, Math.min(Freecam.getSpeedMultiplier(), 5.0)));
            ci.cancel();
        }
    }

    @Unique
    private void handleMoveAndCancelAction(int action, int button) {
        if (button == ((KeyMappingAccessor)HotKeyManager.getMoveCommandKey()).getKey().m_84873_()) {
            if (action == 1) {
                if (!Objects.equals(HotKeyManager.getCurrentActive(), "")) {
                    HotKeyManager.setCurrentActive("");
                }
                Freecam.setCamRollHoldTicks(1);
            } else if (action == 0) {
                Freecam.setCamRollHoldTicks(0);
                if (Freecam.isRotateCamera()) {
                    Freecam.MC.f_91067_.m_91602_();
                    GLFW.glfwSetCursorPos((long)Minecraft.m_91087_().m_91268_().m_85439_(), (double)Freecam.getLastMouseX(), (double)Freecam.getLastMouseY());
                    Freecam.deactivateRotateHandler();
                } else if (Objects.equals(HotKeyManager.getCurrentActive(), "")) {
                    this.sendMoveCommand();
                }
            }
        }
    }

    @Unique
    private void handleSelectAndConfirmAction(int action, int button, CallbackInfo ci) {
        if (button == ((KeyMappingAccessor)HotKeyManager.getSelectCommandKey()).getKey().m_84873_()) {
            double mouseX = Freecam.MC.f_91067_.m_91589_();
            double mouseY = Freecam.MC.f_91067_.m_91594_();
            SelectionHandler selectionHandler = SelectionHandler.getInstance();
            if (action == 1) {
                if (selectionHandler.hasSelectedEntities() && !Objects.equals(HotKeyManager.getCurrentActive(), "")) {
                    if (Objects.equals(HotKeyManager.getCurrentActive(), "attack")) {
                        this.sendMoveAttackCommand();
                    } else if (Objects.equals(HotKeyManager.getCurrentActive(), "patrol")) {
                        this.sendPatrolPointCommand();
                    } else if (Objects.equals(HotKeyManager.getCurrentActive(), "bombard")) {
                        this.sendBombardCommand();
                    }
                    if (!HotKeyManager.getQueueMode()) {
                        HotKeyManager.setCurrentActive("");
                    }
                } else {
                    this.leftMousePressTime = System.currentTimeMillis();
                    selectionHandler.startSelection(mouseX, mouseY);
                    if (!HotKeyManager.getQueueMode()) {
                        for (BlockEntity entity : SelectionHandler.getInstance().getSelectedBlockEntities()) {
                            if (!(entity instanceof BaseStructureCoreBlockEntity)) continue;
                            ((BaseStructureCoreBlockEntity)entity).setSelected(false);
                        }
                        SelectionHandler.getInstance().getSelectedBlockEntities().clear();
                        SelectionHandler.getInstance().getSelectedEntities().clear();
                    }
                    ci.cancel();
                }
            } else if (action == 0) {
                long pressDuration = System.currentTimeMillis() - this.leftMousePressTime;
                if (pressDuration < 200L) {
                    this.handleSingleSelection();
                }
                if (selectionHandler.isSelecting()) {
                    selectionHandler.endSelection();
                    ci.cancel();
                }
            }
        }
    }

    @Unique
    private void handleBuildModeAction(int action, int button, CallbackInfo ci) {
        if (button == ((KeyMappingAccessor)HotKeyManager.getSelectCommandKey()).getKey().m_84873_() && action == 1) {
            ClientPacketHandler.sendBuildCommandPacket(BuildModeHandler.getCenterPosition(), BuildModeHandler.getActiveTemplate(), BuildModeHandler.getRotation());
            ci.cancel();
        }
    }

    @Unique
    private void sendPatrolPointCommand() {
        HitResult result = Freecam.getFreeCamera().camPick(200.0, 0.0f, true, false);
        if (result instanceof BlockHitResult) {
            ClientPacketHandler.sendPatrolPointPacket((BlockHitResult)result, HotKeyManager.isQueueMode());
        }
        assert (Minecraft.m_91087_().f_91074_ != null);
        MutableComponent defaultPart1 = Component.m_237115_((String)"msg.hyw.set");
        MutableComponent greenPart = Component.m_237115_((String)"msg.hyw.patrol").m_130940_(ChatFormatting.BLUE);
        MutableComponent defaultPart2 = Component.m_237115_((String)"msg.hyw.point");
        MutableComponent finalMessage = defaultPart1.m_7220_((Component)greenPart).m_7220_((Component)defaultPart2);
        Minecraft.m_91087_().f_91074_.m_5661_((Component)finalMessage, true);
    }

    @Unique
    private void sendMoveCommand() {
        HitResult result1 = Freecam.getFreeCamera().camPickIgnorePuppet(200.0, 0.0f);
        if (result1 instanceof EntityHitResult) {
            ClientPacketHandler.sendFollowTargetPacket((EntityHitResult)result1, HotKeyManager.isQueueMode());
            HotKeyManager.setCurrentActive("");
            MutableComponent message = Component.m_237115_((String)"msg.hyw.send").m_7220_((Component)Component.m_237115_((String)"msg.hyw.followTarget").m_130940_(ChatFormatting.GREEN)).m_7220_((Component)Component.m_237115_((String)"msg.hyw.command"));
            assert (Minecraft.m_91087_().f_91074_ != null);
            Minecraft.m_91087_().f_91074_.m_5661_((Component)message, true);
        } else {
            HitResult result2 = Freecam.getFreeCamera().camPick(200.0, 0.0f, true, false);
            ClientPacketHandler.sendMoveCommandPacket(result2, HotKeyManager.isQueueMode(), HotKeyManager.getFormationMode());
            HotKeyManager.setCurrentActive("");
            assert (Minecraft.m_91087_().f_91074_ != null);
            MutableComponent defaultPart1 = Component.m_237115_((String)"msg.hyw.send");
            MutableComponent greenPart = Component.m_237115_((String)"msg.hyw.move").m_130940_(ChatFormatting.GREEN);
            MutableComponent defaultPart2 = Component.m_237115_((String)"msg.hyw.command");
            MutableComponent finalMessage = defaultPart1.m_7220_((Component)greenPart).m_7220_((Component)defaultPart2);
            Minecraft.m_91087_().f_91074_.m_5661_((Component)finalMessage, true);
        }
    }

    @Unique
    private void sendMoveAttackCommand() {
        HitResult result1 = Freecam.getFreeCamera().camPickIgnorePuppet(200.0, 0.0f);
        if (result1 instanceof EntityHitResult) {
            ClientPacketHandler.sendTargetUpdatePacket(result1, HotKeyManager.isQueueMode());
            MutableComponent message = Component.m_237115_((String)"msg.hyw.send").m_7220_((Component)Component.m_237115_((String)"msg.hyw.attackTarget").m_130940_(ChatFormatting.RED)).m_7220_((Component)Component.m_237115_((String)"msg.hyw.command"));
            assert (Minecraft.m_91087_().f_91074_ != null);
            Minecraft.m_91087_().f_91074_.m_5661_((Component)message, true);
        } else {
            HitResult result2 = Freecam.getFreeCamera().camPick(200.0, 0.0f, true, false);
            ClientPacketHandler.sendMoveAttackCommandPacket(result2, HotKeyManager.isQueueMode(), HotKeyManager.getFormationMode());
            MutableComponent message = Component.m_237115_((String)"msg.hyw.send").m_7220_((Component)Component.m_237115_((String)"msg.hyw.moveAttack").m_130940_(ChatFormatting.RED)).m_7220_((Component)Component.m_237115_((String)"msg.hyw.command"));
            assert (Minecraft.m_91087_().f_91074_ != null);
            Minecraft.m_91087_().f_91074_.m_5661_((Component)message, true);
        }
    }

    @Inject(method={"grabMouse"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectGrabMouse(CallbackInfo ci) {
        if (Freecam.isEnabled() && !Freecam.getShouldGrabMouse()) {
            ci.cancel();
        }
    }

    @Unique
    private void handleSingleSelection() {
        EntityHitResult entityHitResult;
        Object hitEntity;
        long currentTime = System.currentTimeMillis();
        long timeSinceLastClick = currentTime - this.lastClickTime;
        HitResult result = Freecam.getFreeCamera().camPickPrioritizePuppet(200.0, 0.0f);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && result.m_6662_() == HitResult.Type.ENTITY && (hitEntity = (entityHitResult = (EntityHitResult)result).m_82443_()) instanceof BaseCombatEntity) {
            Entity entity;
            if (hitEntity.m_20202_() != null && (entity = hitEntity.m_20202_()) instanceof BaseCombatEntity) {
                BaseCombatEntity vehicle = (BaseCombatEntity)entity;
                hitEntity = vehicle;
            }
            if (HotKeyManager.getQueueMode() && SelectionHandler.getInstance().getSelectedEntities().contains(hitEntity)) {
                SelectionHandler.getInstance().getSelectedEntities().remove(hitEntity);
            } else {
                SelectionHandler.getInstance().getSelectedEntities().add((Entity)hitEntity);
            }
            if (HotKeyManager.isCtrlMode() || timeSinceLastClick < 200L) {
                SelectionHandler.getInstance().selectAllEntitiesOfSameType((Entity)hitEntity);
            }
        }
        this.lastClickTime = currentTime;
    }

    @Unique
    private void sendBombardCommand() {
        HitResult result = Freecam.getFreeCamera().camPick(200.0, 0.0f, true, false);
        ClientPacketHandler.sendBombardPositionPacket(result.m_82450_());
        MutableComponent message = Component.m_237115_((String)"msg.hyw.send").m_7220_((Component)Component.m_237115_((String)"msg.hyw.bombard").m_130940_(ChatFormatting.RED)).m_7220_((Component)Component.m_237115_((String)"msg.hyw.command"));
        assert (Minecraft.m_91087_().f_91074_ != null);
        Minecraft.m_91087_().f_91074_.m_5661_((Component)message, true);
    }
}

