/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.selection;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.client.freecam.selection.SelectionHandler;
import ydmsama.hundred_years_war.client.freecam.selection.TargetInfo;
import ydmsama.hundred_years_war.main.entity.entities.puppets.IPuppet;

public class ClientPuppetStateHandler {
    private static final Map<UUID, Boolean> playerPuppetSelectionStates = new HashMap<UUID, Boolean>();
    private static final Map<UUID, PuppetTargetState> playerPuppetTargetStates = new HashMap<UUID, PuppetTargetState>();

    public static void savePuppetSelectionState() {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        UUID playerUUID = player.m_20148_();
        IPuppet playerPuppet = ClientPuppetStateHandler.findPlayerPuppet(playerUUID);
        if (playerPuppet == null) {
            return;
        }
        Entity puppetEntity = (Entity)playerPuppet;
        SelectionHandler selectionHandler = SelectionHandler.getInstance();
        boolean puppetSelected = false;
        for (Entity selectedEntity : selectionHandler.getSelectedEntities()) {
            if (selectedEntity != puppetEntity) continue;
            puppetSelected = true;
            break;
        }
        if (puppetSelected) {
            playerPuppetSelectionStates.put(playerUUID, true);
        } else {
            playerPuppetSelectionStates.remove(playerUUID);
        }
        ClientPuppetStateHandler.savePuppetTargetState(playerUUID, puppetEntity, selectionHandler);
    }

    private static void savePuppetTargetState(UUID playerUUID, Entity puppetEntity, SelectionHandler selectionHandler) {
        CopyOnWriteArraySet<TargetInfo> targetInfos = selectionHandler.getCombinedTargetMap().get(puppetEntity);
        CopyOnWriteArrayList<BlockPos> patrolPoints = selectionHandler.getPatrolPointsMap().get(puppetEntity);
        BlockPos bombardTarget = selectionHandler.getBombardTargetMap().get(puppetEntity);
        if (targetInfos != null && !targetInfos.isEmpty() || patrolPoints != null && !patrolPoints.isEmpty() || bombardTarget != null) {
            PuppetTargetState targetState = new PuppetTargetState(targetInfos, patrolPoints, bombardTarget);
            playerPuppetTargetStates.put(playerUUID, targetState);
        } else {
            playerPuppetTargetStates.remove(playerUUID);
        }
    }

    public static void restorePuppetSelectionState() {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        UUID playerUUID = player.m_20148_();
        IPuppet playerPuppet = ClientPuppetStateHandler.findPlayerPuppet(playerUUID);
        if (playerPuppet == null) {
            return;
        }
        Entity puppetEntity = (Entity)playerPuppet;
        SelectionHandler selectionHandler = SelectionHandler.getInstance();
        boolean restoredAny = false;
        Boolean wasSelected = playerPuppetSelectionStates.get(playerUUID);
        if (wasSelected != null && wasSelected.booleanValue() && !selectionHandler.getSelectedEntities().contains(puppetEntity)) {
            selectionHandler.getSelectedEntities().add(puppetEntity);
            restoredAny = true;
        }
        boolean restoredTargets = ClientPuppetStateHandler.restorePuppetTargetState(playerUUID, puppetEntity, selectionHandler);
        boolean bl = restoredAny = restoredAny || restoredTargets;
        if (restoredAny && wasSelected != null && wasSelected.booleanValue()) {
            playerPuppetSelectionStates.remove(playerUUID);
        }
    }

    private static boolean restorePuppetTargetState(UUID playerUUID, Entity puppetEntity, SelectionHandler selectionHandler) {
        BlockPos existingBombardTarget;
        CopyOnWriteArrayList<BlockPos> existingPatrolPoints;
        CopyOnWriteArraySet<TargetInfo> existingTargets;
        PuppetTargetState targetState = playerPuppetTargetStates.get(playerUUID);
        if (targetState == null) {
            return false;
        }
        boolean restoredAny = false;
        if (!targetState.targetInfos.isEmpty() && ((existingTargets = selectionHandler.getCombinedTargetMap().get(puppetEntity)) == null || existingTargets.isEmpty())) {
            selectionHandler.getCombinedTargetMap().put(puppetEntity, new CopyOnWriteArraySet<TargetInfo>(targetState.targetInfos));
            restoredAny = true;
        }
        if (!targetState.patrolPoints.isEmpty() && ((existingPatrolPoints = selectionHandler.getPatrolPointsMap().get(puppetEntity)) == null || existingPatrolPoints.isEmpty())) {
            selectionHandler.getPatrolPointsMap().put(puppetEntity, new CopyOnWriteArrayList<BlockPos>(targetState.patrolPoints));
            restoredAny = true;
        }
        if (targetState.bombardTarget != null && (existingBombardTarget = selectionHandler.getBombardTargetMap().get(puppetEntity)) == null) {
            selectionHandler.getBombardTargetMap().put(puppetEntity, targetState.bombardTarget);
            restoredAny = true;
        }
        if (restoredAny) {
            playerPuppetTargetStates.remove(playerUUID);
        }
        return restoredAny;
    }

    public static void checkAndRestorePuppetSelection() {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || !Freecam.isEnabled()) {
            return;
        }
        UUID playerUUID = player.m_20148_();
        if (!playerPuppetSelectionStates.containsKey(playerUUID) && !playerPuppetTargetStates.containsKey(playerUUID)) {
            return;
        }
        ClientPuppetStateHandler.restorePuppetSelectionState();
    }

    private static IPuppet findPlayerPuppet(UUID playerUUID) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return null;
        }
        for (Entity entity : mc.f_91073_.m_104735_()) {
            IPuppet puppet;
            if (!(entity instanceof IPuppet) || !playerUUID.equals((puppet = (IPuppet)entity).getOwnerUUID())) continue;
            return puppet;
        }
        return null;
    }

    public static void clearPlayerState(UUID playerUUID) {
        playerPuppetSelectionStates.remove(playerUUID);
        playerPuppetTargetStates.remove(playerUUID);
    }

    public static void clearAllStates() {
        playerPuppetSelectionStates.clear();
        playerPuppetTargetStates.clear();
    }

    public static boolean hasSavedSelectionState(UUID playerUUID) {
        return playerPuppetSelectionStates.containsKey(playerUUID);
    }

    public static boolean hasSavedTargetState(UUID playerUUID) {
        return playerPuppetTargetStates.containsKey(playerUUID);
    }

    public static boolean hasSavedState(UUID playerUUID) {
        return ClientPuppetStateHandler.hasSavedSelectionState(playerUUID) || ClientPuppetStateHandler.hasSavedTargetState(playerUUID);
    }

    private static class PuppetTargetState {
        public final CopyOnWriteArraySet<TargetInfo> targetInfos;
        public final CopyOnWriteArrayList<BlockPos> patrolPoints;
        public final BlockPos bombardTarget;

        public PuppetTargetState(CopyOnWriteArraySet<TargetInfo> targetInfos, CopyOnWriteArrayList<BlockPos> patrolPoints, BlockPos bombardTarget) {
            this.targetInfos = targetInfos != null ? new CopyOnWriteArraySet<TargetInfo>(targetInfos) : new CopyOnWriteArraySet();
            this.patrolPoints = patrolPoints != null ? new CopyOnWriteArrayList<BlockPos>(patrolPoints) : new CopyOnWriteArrayList();
            this.bombardTarget = bombardTarget;
        }
    }
}

