/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.selection;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.client.freecam.config.keys.HotKeyManager;
import ydmsama.hundred_years_war.client.freecam.mixins.GameRendererAccessor;
import ydmsama.hundred_years_war.client.freecam.selection.ClientPuppetStateHandler;
import ydmsama.hundred_years_war.client.freecam.selection.TargetInfo;
import ydmsama.hundred_years_war.client.freecam.util.FreeCamera;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.client.utils.ClientRelationHelper;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.siege.PositionAttackable;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

public class SelectionHandler {
    private static SelectionHandler instance;
    private boolean isSelecting = false;
    private double startX;
    private double startY;
    private double endX;
    private double endY;
    List<Entity> selectedEntities = new ArrayList<Entity>();
    List<BlockEntity> selectedBlockEntities = new ArrayList<BlockEntity>();
    private final Map<Entity, CopyOnWriteArraySet<TargetInfo>> combinedTargetMap = new ConcurrentHashMap<Entity, CopyOnWriteArraySet<TargetInfo>>();
    private final Map<Entity, CopyOnWriteArrayList<BlockPos>> patrolPointsMap = new ConcurrentHashMap<Entity, CopyOnWriteArrayList<BlockPos>>();
    private final Map<Entity, BlockPos> bombardTargetMap = new ConcurrentHashMap<Entity, BlockPos>();

    private SelectionHandler() {
    }

    public static SelectionHandler getInstance() {
        if (instance == null) {
            instance = new SelectionHandler();
        }
        return instance;
    }

    public void startSelection(double x, double y) {
        this.startX = x;
        this.startY = y;
        this.endX = x;
        this.endY = y;
        this.isSelecting = true;
        this.updateSelection(x, y);
    }

    public void updateSelection(double x, double y) {
        this.updateSelectedEntities();
        this.endX = x;
        this.endY = y;
    }

    public boolean hasSelectedEntities() {
        return !this.selectedEntities.isEmpty();
    }

    public void updateSelectedEntities() {
        if (!this.isSelecting || Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        ArrayList<Entity> entitiesToRemove = new ArrayList<Entity>();
        for (Entity entity : this.selectedEntities) {
            if (this.isEntityInSelectionBox(entity, mc) || HotKeyManager.getQueueMode()) continue;
            entitiesToRemove.add(entity);
        }
        this.selectedEntities.removeAll(entitiesToRemove);
        for (Entity entity : mc.f_91073_.m_104735_()) {
            if (!(entity instanceof BaseCombatEntity) || this.selectedEntities.contains(entity) || entity.m_20159_() || !this.isEntityInSelectionBox(entity, mc) || !this.hasControl(entity) || this.isEntityObstructed(entity, mc) || this.selectedEntities.contains(entity)) continue;
            this.selectedEntities.add(entity);
            if (SelectionHandler.getInstance().getPatrolPointsMap().containsKey(entity)) continue;
            ClientPacketHandler.sendPatrolPointsRequestPacket(entity);
        }
        ClientPuppetStateHandler.checkAndRestorePuppetSelection();
    }

    private boolean isEntityInSelectionBox(Entity entity, Minecraft mc) {
        int[][] edges;
        double[][] selectionBoxCorners;
        AABB boundingBox = entity.m_20191_();
        Vec3[] vertices = new Vec3[]{new Vec3(boundingBox.f_82288_, boundingBox.f_82289_, boundingBox.f_82290_), new Vec3(boundingBox.f_82291_, boundingBox.f_82289_, boundingBox.f_82290_), new Vec3(boundingBox.f_82291_, boundingBox.f_82292_, boundingBox.f_82290_), new Vec3(boundingBox.f_82288_, boundingBox.f_82292_, boundingBox.f_82290_), new Vec3(boundingBox.f_82288_, boundingBox.f_82289_, boundingBox.f_82293_), new Vec3(boundingBox.f_82291_, boundingBox.f_82289_, boundingBox.f_82293_), new Vec3(boundingBox.f_82291_, boundingBox.f_82292_, boundingBox.f_82293_), new Vec3(boundingBox.f_82288_, boundingBox.f_82292_, boundingBox.f_82293_)};
        Matrix4f viewMat = SelectionHandler.buildViewMatrix(mc.f_91063_.m_109153_());
        for (Vec3 vertex : vertices) {
            Vector4f viewPos = new Vector4f((float)vertex.f_82479_, (float)vertex.f_82480_, (float)vertex.f_82481_, 1.0f);
            viewPos.mul((Matrix4fc)viewMat);
            if (!(viewPos.z > 0.0f)) continue;
            return false;
        }
        double[][] screenCoords = new double[8][2];
        for (int i = 0; i < 8; ++i) {
            screenCoords[i] = this.worldToScreen(vertices[i].f_82479_, vertices[i].f_82480_, vertices[i].f_82481_, mc);
        }
        double minX = Math.min(this.startX, this.endX);
        double maxX = Math.max(this.startX, this.endX);
        double minY = Math.min(this.startY, this.endY);
        double maxY = Math.max(this.startY, this.endY);
        boolean allVerticesInside = true;
        for (double[] screenPos : screenCoords) {
            if (!(screenPos[0] < minX || screenPos[0] > maxX || screenPos[1] < minY) && !(screenPos[1] > maxY)) continue;
            allVerticesInside = false;
            break;
        }
        if (allVerticesInside) {
            return true;
        }
        for (double[] corner : selectionBoxCorners = new double[][]{{minX, minY}, {maxX, minY}, {maxX, maxY}, {minX, maxY}}) {
            Vec3 worldPos = this.screenToWorld(corner[0], corner[1], mc);
            if (!boundingBox.m_82390_(worldPos)) continue;
            return true;
        }
        for (int[] edge : edges = new int[][]{{0, 1}, {1, 2}, {2, 3}, {3, 0}, {4, 5}, {5, 6}, {6, 7}, {7, 4}, {0, 4}, {1, 5}, {2, 6}, {3, 7}}) {
            double[] start = screenCoords[edge[0]];
            double[] end = screenCoords[edge[1]];
            if (!this.lineIntersectsRect(start[0], start[1], end[0], end[1], minX, minY, maxX, maxY)) continue;
            return true;
        }
        return false;
    }

    private boolean lineIntersectsRect(double x1, double y1, double x2, double y2, double minX, double minY, double maxX, double maxY) {
        return this.lineIntersectsLine(x1, y1, x2, y2, minX, minY, maxX, minY) || this.lineIntersectsLine(x1, y1, x2, y2, maxX, minY, maxX, maxY) || this.lineIntersectsLine(x1, y1, x2, y2, maxX, maxY, minX, maxY) || this.lineIntersectsLine(x1, y1, x2, y2, minX, maxY, minX, minY);
    }

    private boolean lineIntersectsLine(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        double det1 = this.det(x1, y1, x2, y2, x3, y3);
        double det2 = this.det(x1, y1, x2, y2, x4, y4);
        double det3 = this.det(x3, y3, x4, y4, x1, y1);
        double det4 = this.det(x3, y3, x4, y4, x2, y2);
        return det1 * det2 < 0.0 && det3 * det4 < 0.0;
    }

    private double det(double x1, double y1, double x2, double y2, double x3, double y3) {
        return (x1 - x3) * (y2 - y3) - (y1 - y3) * (x2 - x3);
    }

    private double[] worldToScreen(double worldX, double worldY, double worldZ, Minecraft mc) {
        Camera camera = mc.f_91063_.m_109153_();
        GameRendererAccessor accessor = (GameRendererAccessor)Minecraft.m_91087_().f_91063_;
        double fov = accessor.invokeGetFov(camera, 1.0f, true);
        Matrix4f projMat = mc.f_91063_.m_253088_(fov);
        Matrix4f viewMat = SelectionHandler.buildViewMatrix(camera);
        Vector4f worldCoords = new Vector4f((float)worldX, (float)worldY, (float)worldZ, 1.0f);
        worldCoords.mul((Matrix4fc)viewMat);
        worldCoords.mul((Matrix4fc)projMat);
        if (worldCoords.w() != 0.0f) {
            worldCoords.mul(1.0f / worldCoords.w());
        }
        int width = mc.m_91268_().m_85443_();
        int height = mc.m_91268_().m_85444_();
        double screenX = ((double)worldCoords.x() + 1.0) / 2.0 * (double)width;
        double screenY = (1.0 - (double)worldCoords.y()) / 2.0 * (double)height;
        return new double[]{screenX, screenY};
    }

    private static Matrix4f buildViewMatrix(Camera camera) {
        Matrix4f viewMatrix = new Matrix4f().identity();
        viewMatrix.rotateX((float)Math.toRadians(camera.m_90589_()));
        viewMatrix.rotateY((float)Math.toRadians(camera.m_90590_() + 180.0f));
        viewMatrix.translate((float)(-camera.m_90583_().f_82479_), (float)(-camera.m_90583_().f_82480_), (float)(-camera.m_90583_().f_82481_));
        return viewMatrix;
    }

    public Vec3 screenToWorld(double screenX, double screenY, Minecraft mc) {
        int width = mc.m_91268_().m_85443_();
        int height = mc.m_91268_().m_85444_();
        double normX = 2.0 * screenX / (double)width - 1.0;
        double normY = 1.0 - 2.0 * screenY / (double)height;
        Matrix4f projMat = mc.f_91063_.m_253088_((double)((float)((GameRendererAccessor)mc.f_91063_).invokeGetFov(mc.f_91063_.m_109153_(), 1.0f, true)));
        projMat.invert();
        Vector4f clipCoords = new Vector4f((float)normX, (float)normY, -1.0f, 1.0f);
        clipCoords.mul((Matrix4fc)projMat);
        Vector4f worldCoords = new Vector4f(clipCoords.x, clipCoords.y, -1.0f, 0.0f);
        Matrix4f viewMat = SelectionHandler.buildViewMatrix(mc.f_91063_.m_109153_());
        viewMat.invert();
        worldCoords.mul((Matrix4fc)viewMat);
        Vec3 directionVector = new Vec3((double)worldCoords.x, (double)worldCoords.y, (double)worldCoords.z).m_82541_();
        return directionVector;
    }

    public void endSelection() {
        this.isSelecting = false;
        List<UUID> selectedEntityIds = this.selectedEntities.stream().filter(this::hasControl).map(Entity::m_20148_).collect(Collectors.toList());
        ClientPacketHandler.sendSelectionPacket(selectedEntityIds);
    }

    public boolean hasControl(Entity entity) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player.m_7500_()) {
            return true;
        }
        if (entity instanceof BaseCombatEntity) {
            BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
            UUID entityOwnerUUID = combatEntity.getOwnerUUID();
            if (entityOwnerUUID != null && entityOwnerUUID.equals(player.m_20148_())) {
                return true;
            }
            ClientRelationHelper relationHelper = ClientRelationHelper.getInstance();
            return entityOwnerUUID != null && relationHelper.getRelationWithPlayer(entity) == RelationSystem.RelationType.CONTROL;
        }
        return false;
    }

    public boolean isSelecting() {
        return this.isSelecting;
    }

    public void setSelecting(boolean isSelecting) {
        this.isSelecting = isSelecting;
    }

    public double getStartX() {
        return this.startX;
    }

    public double getStartY() {
        return this.startY;
    }

    public double getEndX() {
        return this.endX;
    }

    public double getEndY() {
        return this.endY;
    }

    public void renderSelectionBox() {
        if (SelectionHandler.getInstance().isSelecting()) {
            RenderSystem.setShader(GameRenderer::m_172811_);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder bufferBuilder = tesselator.m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
            int screenWidth = Freecam.MC.m_91268_().m_85443_();
            int screenHeight = Freecam.MC.m_91268_().m_85444_();
            int guiScreenWidth = Freecam.MC.m_91268_().m_85445_();
            int guiScreenHeight = Freecam.MC.m_91268_().m_85446_();
            double startX = SelectionHandler.getInstance().getStartX() / ((double)screenWidth / (double)guiScreenWidth);
            double startY = SelectionHandler.getInstance().getStartY() / ((double)screenHeight / (double)guiScreenHeight);
            double endX = Freecam.MC.f_91067_.m_91589_() / ((double)screenWidth / (double)guiScreenWidth);
            double endY = Freecam.MC.f_91067_.m_91594_() / ((double)screenHeight / (double)guiScreenHeight);
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            float a = 1.0f;
            bufferBuilder.m_5483_(startX, startY, 0.0).m_85950_(r, g, b, a).m_5752_();
            bufferBuilder.m_5483_(endX, startY, 0.0).m_85950_(r, g, b, a).m_5752_();
            bufferBuilder.m_5483_(endX, startY, 0.0).m_85950_(r, g, b, a).m_5752_();
            bufferBuilder.m_5483_(endX, endY, 0.0).m_85950_(r, g, b, a).m_5752_();
            bufferBuilder.m_5483_(endX, endY, 0.0).m_85950_(r, g, b, a).m_5752_();
            bufferBuilder.m_5483_(startX, endY, 0.0).m_85950_(r, g, b, a).m_5752_();
            bufferBuilder.m_5483_(startX, endY, 0.0).m_85950_(r, g, b, a).m_5752_();
            bufferBuilder.m_5483_(startX, startY, 0.0).m_85950_(r, g, b, a).m_5752_();
            tesselator.m_85914_();
            RenderSystem.disableBlend();
        }
    }

    public List<BlockEntity> getSelectedBlockEntities() {
        return this.selectedBlockEntities;
    }

    public List<Entity> getSelectedEntities() {
        return this.selectedEntities;
    }

    public void setSelectedEntities(List<Entity> selectedEntities) {
        this.selectedEntities = selectedEntities;
    }

    public void updateTargetPos(Entity entity, BlockPos targetPos) {
        TargetInfo targetInfo = new TargetInfo("target", targetPos, null);
        this.combinedTargetMap.computeIfAbsent(entity, k -> new CopyOnWriteArraySet()).add(targetInfo);
    }

    public void updateFormTargetPos(Entity entity, BlockPos targetPos) {
        TargetInfo targetInfo = new TargetInfo("formTarget", targetPos, null);
        this.combinedTargetMap.computeIfAbsent(entity, k -> new CopyOnWriteArraySet()).add(targetInfo);
    }

    public void updateAttackTargetPos(Entity entity, BlockPos targetPos) {
        TargetInfo targetInfo = new TargetInfo("attackTarget", targetPos, null);
        this.combinedTargetMap.computeIfAbsent(entity, k -> new CopyOnWriteArraySet()).add(targetInfo);
    }

    public void updateFormAttackTargetPos(Entity entity, BlockPos targetPos) {
        TargetInfo targetInfo = new TargetInfo("formAttackTarget", targetPos, null);
        this.combinedTargetMap.computeIfAbsent(entity, k -> new CopyOnWriteArraySet()).add(targetInfo);
    }

    public void clearAllTargetPos(Entity entity) {
        this.combinedTargetMap.computeIfPresent(entity, (k, v) -> {
            v.removeIf(info -> "target".equals(info.getType()));
            v.removeIf(info -> "formTarget".equals(info.getType()));
            return v.isEmpty() ? null : v;
        });
    }

    public void clearAllAttackTargetPos(Entity entity) {
        this.combinedTargetMap.computeIfPresent(entity, (k, v) -> {
            v.removeIf(info -> "attackTarget".equals(info.getType()));
            v.removeIf(info -> "formAttackTarget".equals(info.getType()));
            return v.isEmpty() ? null : v;
        });
    }

    public Set<BlockPos> getTargetPos(Entity entity) {
        return this.combinedTargetMap.getOrDefault(entity, new CopyOnWriteArraySet()).stream().filter(info -> "target".equals(info.getType())).map(TargetInfo::getPosition).collect(Collectors.toSet());
    }

    public Set<BlockPos> getAttackTargetPos(Entity entity) {
        return this.combinedTargetMap.getOrDefault(entity, new CopyOnWriteArraySet()).stream().filter(info -> "attackTarget".equals(info.getType())).map(TargetInfo::getPosition).collect(Collectors.toSet());
    }

    public void clearSelectedTargetPos() {
        for (Entity selectedEntity : this.selectedEntities) {
            this.clearAllTargetPos(selectedEntity);
        }
    }

    public void clearSelectedAttackTargetPos() {
        for (Entity selectedEntity : this.selectedEntities) {
            this.clearAllAttackTargetPos(selectedEntity);
        }
    }

    public Map<Entity, CopyOnWriteArraySet<TargetInfo>> getCombinedTargetMap() {
        return this.combinedTargetMap;
    }

    public void updateTarget(Entity attacker, Entity target) {
        TargetInfo targetInfo = new TargetInfo("entityTarget", null, target);
        this.combinedTargetMap.computeIfAbsent(attacker, k -> new CopyOnWriteArraySet()).add(targetInfo);
    }

    public void updateFollowTarget(Entity follower, Entity target) {
        TargetInfo targetInfo = new TargetInfo("followTarget", null, target);
        this.combinedTargetMap.computeIfAbsent(follower, k -> new CopyOnWriteArraySet()).add(targetInfo);
    }

    public void clearAllTargets(Entity attacker) {
        this.combinedTargetMap.computeIfPresent(attacker, (k, v) -> {
            v.removeIf(info -> "entityTarget".equals(info.getType()));
            return v.isEmpty() ? null : v;
        });
    }

    public Set<Entity> getTargets(Entity attacker) {
        return this.combinedTargetMap.getOrDefault(attacker, new CopyOnWriteArraySet()).stream().filter(info -> "entityTarget".equals(info.getType())).map(TargetInfo::getHywTarget).collect(Collectors.toSet());
    }

    public void clearSelectedTargets() {
        for (Entity selectedEntity : this.selectedEntities) {
            this.clearAllTargets(selectedEntity);
        }
    }

    public void clearAllFollowTargets(Entity attacker) {
        this.combinedTargetMap.computeIfPresent(attacker, (k, v) -> {
            v.removeIf(info -> "followTarget".equals(info.getType()));
            return v.isEmpty() ? null : v;
        });
    }

    public void clearSelectedFollowTargets() {
        for (Entity selectedEntity : this.selectedEntities) {
            this.clearAllFollowTargets(selectedEntity);
        }
    }

    public static void clearAllRendering() {
        if (!HotKeyManager.getQueueMode() || !Freecam.isEnabled()) {
            SelectionHandler.getInstance().clearSelectedTargets();
            SelectionHandler.getInstance().clearSelectedTargetPos();
            SelectionHandler.getInstance().clearSelectedAttackTargetPos();
            SelectionHandler.getInstance().clearSelectedFollowTargets();
            SelectionHandler.getInstance().clearSelectedPatrolPoints();
            SelectionHandler.getInstance().clearSelectedBombardTargets();
        }
    }

    public void updatePatrolPoint(Entity entity, BlockPos patrolPoint) {
        this.patrolPointsMap.computeIfAbsent(entity, k -> new CopyOnWriteArrayList()).add(patrolPoint);
    }

    public void clearAllPatrolPoints(Entity entity) {
        this.patrolPointsMap.remove(entity);
    }

    public List<BlockPos> getPatrolPoints(Entity entity) {
        return this.patrolPointsMap.getOrDefault(entity, new CopyOnWriteArrayList());
    }

    public void clearSelectedPatrolPoints() {
        for (Entity selectedEntity : this.selectedEntities) {
            this.clearAllPatrolPoints(selectedEntity);
        }
    }

    public Map<Entity, CopyOnWriteArrayList<BlockPos>> getPatrolPointsMap() {
        return this.patrolPointsMap;
    }

    public void selectAllEntitiesOfSameType(Entity referenceEntity) {
        if (Minecraft.m_91087_().f_91073_ == null || referenceEntity == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        this.startX = 0.0;
        this.startY = 0.0;
        this.endX = mc.m_91268_().m_85443_();
        this.endY = mc.m_91268_().m_85444_();
        ArrayList<Entity> entitiesToAdd = new ArrayList<Entity>();
        assert (mc.f_91073_ != null);
        for (Entity entity : mc.f_91073_.m_104735_()) {
            if (entity.getClass() != referenceEntity.getClass() || this.selectedEntities.contains(entity) || !(entity instanceof BaseCombatEntity) || !(referenceEntity instanceof BaseCombatEntity)) continue;
            UUID referenceUUID = ((BaseCombatEntity)referenceEntity).getOwnerUUID();
            UUID entityUUID = ((BaseCombatEntity)entity).getOwnerUUID();
            if (!this.isEntityInSelectionBox(entity, mc)) continue;
            if (referenceUUID != null) {
                if (!ClientRelationHelper.getInstance().getRelationWithPlayer(entity).equals((Object)RelationSystem.RelationType.CONTROL)) continue;
                entitiesToAdd.add(entity);
                continue;
            }
            if (entityUUID != null) continue;
            entitiesToAdd.add(entity);
        }
        this.selectedEntities.addAll(entitiesToAdd);
        if (!HotKeyManager.getQueueMode()) {
            for (Entity entity : entitiesToAdd) {
                if (SelectionHandler.getInstance().getPatrolPointsMap().containsKey(entity)) continue;
                ClientPacketHandler.sendPatrolPointsRequestPacket(entity);
            }
        }
    }

    private boolean isEntityObstructed(Entity entity, Minecraft mc) {
        if (!(entity instanceof BaseCombatEntity)) {
            return false;
        }
        Camera camera = mc.f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        Vec3 entityPos = entity.m_146892_();
        FreeCamera contextEntity = Freecam.getFreeCamera();
        if (contextEntity == null) {
            return false;
        }
        BlockHitResult blockHitResult = mc.f_91073_.m_45547_(new ClipContext(cameraPos, entityPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)contextEntity));
        return blockHitResult.m_6662_() != HitResult.Type.MISS;
    }

    public Map<Entity, BlockPos> getBombardTargetMap() {
        return this.bombardTargetMap;
    }

    public void updateBombardTarget(Entity entity, BlockPos bombardTarget) {
        if (entity instanceof PositionAttackable) {
            this.bombardTargetMap.put(entity, bombardTarget);
        }
    }

    public BlockPos getBombardTarget(Entity entity) {
        return this.bombardTargetMap.get(entity);
    }

    public void clearBombardTarget(Entity entity) {
        this.bombardTargetMap.remove(entity);
    }

    public void clearSelectedBombardTargets() {
        for (Entity entity : this.selectedEntities) {
            if (!(entity instanceof PositionAttackable)) continue;
            this.clearBombardTarget(entity);
        }
    }
}

