/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.tripod;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.level.dimension.DimensionType;
import org.jetbrains.annotations.Nullable;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.client.freecam.tripod.TripodSlot;
import ydmsama.hundred_years_war.client.freecam.util.FreecamPosition;

public class TripodRegistry {
    private final Map<DimensionType, Map<TripodSlot, FreecamPosition>> tripods = new HashMap<DimensionType, Map<TripodSlot, FreecamPosition>>();

    @Nullable
    public FreecamPosition get(TripodSlot tripod) {
        return this.get(TripodRegistry.dimension(), tripod);
    }

    @Nullable
    public FreecamPosition get(DimensionType dimension, TripodSlot tripod) {
        return Optional.ofNullable(this.tripods.get(dimension)).map(positions -> (FreecamPosition)positions.get((Object)tripod)).orElse(null);
    }

    public void put(TripodSlot tripod, @Nullable FreecamPosition position) {
        this.put(TripodRegistry.dimension(), tripod, position);
    }

    public void put(DimensionType dimension, TripodSlot tripod, @Nullable FreecamPosition position) {
        this.tripods.computeIfAbsent(dimension, TripodRegistry::newEntry).put(tripod, position);
    }

    public void clear() {
        this.tripods.clear();
    }

    private static DimensionType dimension() {
        return Freecam.MC.f_91073_.m_6042_();
    }

    private static Map<TripodSlot, FreecamPosition> newEntry(DimensionType dimension) {
        return new EnumMap<TripodSlot, FreecamPosition>(TripodSlot.class);
    }
}

