/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.client.freecam.ui.CustomButton;
import ydmsama.hundred_years_war.client.freecam.ui.MemberListWidget;
import ydmsama.hundred_years_war.main.network.packets.TeamMembersResponsePacket;

public class MemberListEntry
extends ContainerObjectSelectionList.Entry<MemberListEntry> {
    private final String memberName;
    private final MemberListWidget parent;
    private final List<GuiEventListener> children = new ArrayList<GuiEventListener>();
    private final Minecraft minecraft;
    private CustomButton removeButton;
    private CustomButton roleButton;
    private static final ResourceLocation PERSONAL_ICON = new ResourceLocation("hundred_years_war", "textures/gui/personal.png");
    private static final ResourceLocation ADMIN_ICON = new ResourceLocation("hundred_years_war", "textures/gui/team.png");
    private static final ResourceLocation OWNER_ICON = new ResourceLocation("hundred_years_war", "textures/gui/team.png");
    private static final int ICON_SIZE = 16;
    private MemberRole currentRole;
    private MemberRole originalRole;
    private UUID memberUUID;
    private Consumer<UUID> removeCallback;
    private BiConsumer<UUID, MemberRole> roleChangeCallback;
    private boolean isSelf = false;
    private boolean hasChanged = false;

    public MemberListEntry(String memberName, MemberListWidget parent) {
        this.memberName = memberName;
        this.parent = parent;
        this.minecraft = Minecraft.m_91087_();
        this.currentRole = MemberRole.MEMBER;
        this.originalRole = MemberRole.MEMBER;
        this.roleButton = new CustomButton(0, 0, 60, 20, (Component)Component.m_237115_((String)this.currentRole.getTranslationKey()).m_130938_(style -> style.m_178520_(this.currentRole.getColor())), button -> this.onRoleToggle());
        this.children.add(this.roleButton);
        this.removeButton = new CustomButton(0, 0, 60, 20, (Component)Component.m_237115_((String)"ui.hundred_years_war.remove"), button -> this.onRemoveClick());
        this.children.add(this.removeButton);
        this.removeButton.setColor(-5636096, -3407872, -11206656);
    }

    public static MemberListEntry create(String memberName, UUID memberUUID, boolean isAdmin, boolean isOwner, boolean isSelf, MemberListWidget parent, Consumer<UUID> removeCallback) {
        return MemberListEntry.create(memberName, memberUUID, isAdmin, isOwner, isSelf, parent, removeCallback, null);
    }

    public static MemberListEntry create(String memberName, UUID memberUUID, boolean isAdmin, boolean isOwner, boolean isSelf, MemberListWidget parent, Consumer<UUID> removeCallback, BiConsumer<UUID, MemberRole> roleChangeCallback) {
        MemberListEntry entry = new MemberListEntry(memberName, parent);
        entry.memberUUID = memberUUID;
        entry.isSelf = isSelf;
        entry.removeCallback = removeCallback;
        entry.roleChangeCallback = roleChangeCallback;
        entry.currentRole = isOwner ? MemberRole.OWNER : (isAdmin ? MemberRole.ADMIN : MemberRole.MEMBER);
        entry.originalRole = entry.currentRole;
        entry.updateRoleButton();
        if (roleChangeCallback == null) {
            entry.roleButton.f_93623_ = false;
        }
        if (isSelf || isOwner) {
            entry.removeButton.f_93623_ = false;
        }
        return entry;
    }

    protected void onRemoveClick() {
        if (this.removeCallback != null && this.memberUUID != null) {
            this.removeCallback.accept(this.memberUUID);
        }
    }

    protected void onRoleToggle() {
        if (this.roleChangeCallback != null) {
            this.currentRole = this.currentRole.next();
            this.updateRoleButton();
            this.hasChanged = !this.currentRole.equals((Object)this.originalRole);
            this.roleChangeCallback.accept(this.memberUUID, this.currentRole);
        }
    }

    private void updateRoleButton() {
        this.roleButton.m_93666_((Component)Component.m_237115_((String)this.currentRole.getTranslationKey()).m_130938_(style -> style.m_178520_(this.currentRole.getColor())));
    }

    public MemberRole getCurrentRole() {
        return this.currentRole;
    }

    public MemberRole getOriginalRole() {
        return this.originalRole;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public UUID getMemberUUID() {
        return this.memberUUID;
    }

    public String getMemberName() {
        return this.memberName;
    }

    public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float partialTick) {
        int nameColor = this.currentRole.getColor();
        guiGraphics.m_280488_(this.minecraft.f_91062_, this.memberName + (this.currentRole == MemberRole.OWNER ? " \u2605" : (this.currentRole == MemberRole.ADMIN ? " \u2699" : "")), left + 5, top + 6, nameColor);
        int buttonY = top + 2;
        int removeButtonWidth = 50;
        int roleButtonWidth = 50;
        int roleButtonLeft = left + width - removeButtonWidth - roleButtonWidth - 10;
        int removeButtonLeft = left + width - removeButtonWidth - 5;
        this.roleButton.m_252865_(roleButtonLeft);
        this.roleButton.m_253211_(buttonY);
        this.roleButton.m_93674_(roleButtonWidth);
        this.removeButton.m_252865_(removeButtonLeft);
        this.removeButton.m_253211_(buttonY);
        this.removeButton.m_93674_(removeButtonWidth);
        this.roleButton.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.removeButton.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (GuiEventListener listener : new ArrayList<GuiEventListener>(this.children)) {
            if (!listener.m_6375_(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<? extends GuiEventListener> m_6702_() {
        return this.children;
    }

    @NotNull
    public List<? extends NarratableEntry> m_142437_() {
        ArrayList<NarratableEntry> result = new ArrayList<NarratableEntry>();
        for (GuiEventListener child : this.children) {
            if (!(child instanceof NarratableEntry)) continue;
            result.add((NarratableEntry)child);
        }
        return result;
    }

    public static enum MemberRole {
        MEMBER(0, "ui.hundred_years_war.team_member", 0xFFFFFF),
        ADMIN(1, "ui.hundred_years_war.team_admin", -11162881),
        OWNER(2, "ui.hundred_years_war.team_owner", -22016);

        private final int id;
        private final String translationKey;
        private final int color;

        private MemberRole(int id, String translationKey, int color) {
            this.id = id;
            this.translationKey = translationKey;
            this.color = color;
        }

        public MemberRole next() {
            MemberRole[] values = MemberRole.values();
            return values[(this.id + 1) % values.length];
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public int getColor() {
            return this.color;
        }

        public static MemberRole fromServerRole(TeamMembersResponsePacket.Member.Role role) {
            return switch (role) {
                default -> throw new IncompatibleClassChangeError();
                case TeamMembersResponsePacket.Member.Role.OWNER -> OWNER;
                case TeamMembersResponsePacket.Member.Role.ADMIN -> ADMIN;
                case TeamMembersResponsePacket.Member.Role.MEMBER -> MEMBER;
            };
        }

        public TeamMembersResponsePacket.Member.Role toServerRole() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case OWNER -> TeamMembersResponsePacket.Member.Role.OWNER;
                case ADMIN -> TeamMembersResponsePacket.Member.Role.ADMIN;
                case MEMBER -> TeamMembersResponsePacket.Member.Role.MEMBER;
            };
        }
    }
}

