/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import ydmsama.hundred_years_war.client.freecam.config.keys.HotKeyManager;

public class MouseControlInfoHandler {
    private static MouseControlInfoHandler instance;
    private static final int PADDING = 5;
    private static final int ITEM_HEIGHT = 12;
    private static final float FONT_SCALE = 0.8f;

    private MouseControlInfoHandler() {
    }

    public static MouseControlInfoHandler getInstance() {
        if (instance == null) {
            instance = new MouseControlInfoHandler();
        }
        return instance;
    }

    private String formatKeyName(String keyName, boolean isLeftMouse) {
        if (isLeftMouse) {
            if (keyName.equals("button.mouse.left") || keyName.equalsIgnoreCase("Left Button")) {
                return "LMB";
            }
        } else if (keyName.equals("button.mouse.right") || keyName.equalsIgnoreCase("Right Button")) {
            return "RMB";
        }
        return keyName;
    }

    private Component getLeftMouseShortInfo() {
        String leftKeyName = HotKeyManager.getSelectCommandKey().m_90863_().getString();
        String formattedKeyName = this.formatKeyName(leftKeyName, true);
        return Component.m_237110_((String)"control.hundred_years_war.left_mouse_short", (Object[])new Object[]{formattedKeyName});
    }

    private Component getLeftMouseLongInfo() {
        String leftKeyName = HotKeyManager.getSelectCommandKey().m_90863_().getString();
        String formattedKeyName = this.formatKeyName(leftKeyName, true);
        return Component.m_237110_((String)"control.hundred_years_war.left_mouse_long", (Object[])new Object[]{formattedKeyName});
    }

    private Component getRightMouseShortInfo() {
        String rightKeyName = HotKeyManager.getMoveCommandKey().m_90863_().getString();
        String formattedKeyName = this.formatKeyName(rightKeyName, false);
        return Component.m_237110_((String)"control.hundred_years_war.right_mouse_short", (Object[])new Object[]{formattedKeyName});
    }

    private Component getRightMouseLongInfo() {
        String rightKeyName = HotKeyManager.getMoveCommandKey().m_90863_().getString();
        String formattedKeyName = this.formatKeyName(rightKeyName, false);
        return Component.m_237110_((String)"control.hundred_years_war.right_mouse_long", (Object[])new Object[]{formattedKeyName});
    }

    private Component getMouseWheelInfo() {
        return Component.m_237115_((String)"control.hundred_years_war.mouse_wheel");
    }

    private void drawScaledString(GuiGraphics guiGraphics, Font font, Component text, float x, float y, int color) {
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, 0.0f);
        poseStack.m_85841_(0.8f, 0.8f, 1.0f);
        guiGraphics.m_280430_(font, text, 0, 0, color);
        poseStack.m_85849_();
    }

    private int getScaledWidth(Font font, Component text) {
        return (int)((float)font.m_92852_((FormattedText)text) * 0.8f);
    }

    public void renderMouseControlInfo(GuiGraphics guiGraphics) {
        Minecraft minecraft = Minecraft.m_91087_();
        int screenWidth = minecraft.m_91268_().m_85445_();
        int screenHeight = minecraft.m_91268_().m_85446_();
        Font font = minecraft.f_91062_;
        float scaledItemHeight = 9.6f;
        int listHeight = (int)(5.0f * scaledItemHeight) + 10;
        int startY = screenHeight - listHeight - 5;
        Component rightMouseLongText = this.getRightMouseLongInfo();
        int rightMouseLongY = startY + 5;
        this.drawScaledString(guiGraphics, font, rightMouseLongText, screenWidth - 5 - this.getScaledWidth(font, rightMouseLongText), rightMouseLongY, 0xFFFFFF);
        Component leftMouseLongText = this.getLeftMouseLongInfo();
        int leftMouseLongY = rightMouseLongY + (int)scaledItemHeight;
        this.drawScaledString(guiGraphics, font, leftMouseLongText, screenWidth - 5 - this.getScaledWidth(font, leftMouseLongText), leftMouseLongY, 0xFFFFFF);
        Component rightMouseShortText = this.getRightMouseShortInfo();
        int rightMouseShortY = leftMouseLongY + (int)scaledItemHeight;
        this.drawScaledString(guiGraphics, font, rightMouseShortText, screenWidth - 5 - this.getScaledWidth(font, rightMouseShortText), rightMouseShortY, 0xFFFFFF);
        Component leftMouseShortText = this.getLeftMouseShortInfo();
        int leftMouseShortY = rightMouseShortY + (int)scaledItemHeight;
        this.drawScaledString(guiGraphics, font, leftMouseShortText, screenWidth - 5 - this.getScaledWidth(font, leftMouseShortText), leftMouseShortY, 0xFFFFFF);
        Component mouseWheelText = this.getMouseWheelInfo();
        int mouseWheelY = leftMouseShortY + (int)scaledItemHeight;
        this.drawScaledString(guiGraphics, font, mouseWheelText, screenWidth - 5 - this.getScaledWidth(font, mouseWheelText), mouseWheelY, 0xFFFFFF);
    }
}

