/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.client.freecam.selection.SelectionHandler;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.HywHorseEntity;
import ydmsama.hundred_years_war.main.entity.entities.puppets.IPuppet;

public class SelectionHUD {
    private static final int MARGIN_LEFT = 5;
    private static final int MARGIN_TOP = 5;
    private static final int LINE_HEIGHT = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void render(GuiGraphics guiGraphics) {
        ArrayList<Entity> safeCopy;
        List<Entity> selectedEntitiesWithDuplicates;
        if (!Freecam.isEnabled()) {
            return;
        }
        SelectionHandler selectionHandler = SelectionHandler.getInstance();
        List<Entity> list = selectedEntitiesWithDuplicates = selectionHandler.getSelectedEntities();
        synchronized (list) {
            safeCopy = new ArrayList<Entity>(selectedEntitiesWithDuplicates);
        }
        ArrayList<Entity> selectedEntities = new ArrayList<Entity>(new HashSet<Entity>(safeCopy));
        if (selectedEntities.isEmpty()) {
            return;
        }
        if (selectedEntities.size() == 1) {
            SelectionHUD.renderSingleEntityInfo(guiGraphics, (Entity)selectedEntities.get(0));
        } else {
            SelectionHUD.renderMultipleEntitiesInfo(guiGraphics, selectedEntities);
        }
    }

    private static Entity getEffectiveEntity(Entity entity) {
        if (entity instanceof HywHorseEntity && !entity.m_20197_().isEmpty()) {
            return (Entity)entity.m_20197_().get(0);
        }
        return entity;
    }

    private static void renderSingleEntityInfo(GuiGraphics guiGraphics, Entity entity) {
        Entity effectiveEntity = SelectionHUD.getEffectiveEntity(entity);
        if (!(effectiveEntity instanceof BaseCombatEntity)) {
            return;
        }
        int y = 5;
        String entityType = effectiveEntity.m_6095_().m_20675_();
        MutableComponent typeText = Component.m_237115_((String)"hud.hundred_years_war.unit_type").m_130946_(": ").m_7220_((Component)Component.m_237115_((String)entityType));
        guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)typeText, 5, y, 0xFFFFFF);
        y += 10;
        if (effectiveEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)effectiveEntity;
            MutableComponent healthText = Component.m_237113_((String)String.format("%.1f/%.1f", Float.valueOf(livingEntity.m_21223_()), Float.valueOf(livingEntity.m_21233_())));
            guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)healthText, 5, y, 0xFFFFFF);
            y += 10;
            if (effectiveEntity instanceof BaseCombatEntity) {
                BaseCombatEntity combatEntity = (BaseCombatEntity)effectiveEntity;
                if (!(effectiveEntity instanceof IPuppet)) {
                    MutableComponent levelText = Component.m_237115_((String)"hud.hundred_years_war.level").m_130946_(": ").m_130946_(String.valueOf(combatEntity.getLevel()));
                    guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)levelText, 5, y, 0xFFFFFF);
                    MutableComponent killsText = Component.m_237115_((String)"hud.hundred_years_war.kills").m_130946_(": ").m_130946_(String.valueOf(combatEntity.getKillCount()));
                    guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)killsText, 5, y += 10, 0xFFFFFF);
                }
            }
        }
    }

    private static void renderMultipleEntitiesInfo(GuiGraphics guiGraphics, List<Entity> entities) {
        int y = 5;
        HashMap<String, Integer> entityCounts = new HashMap<String, Integer>();
        int totalEffectiveUnits = 0;
        for (Entity entity : entities) {
            Entity effectiveEntity = SelectionHUD.getEffectiveEntity(entity);
            if (!(effectiveEntity instanceof BaseCombatEntity)) continue;
            String entityType = effectiveEntity.m_6095_().m_20675_();
            entityCounts.merge(entityType, 1, Integer::sum);
            ++totalEffectiveUnits;
        }
        MutableComponent totalText = Component.m_237115_((String)"hud.hundred_years_war.selected_units_count").m_130946_(": ").m_130946_(String.valueOf(totalEffectiveUnits));
        guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)totalText, 5, y, 0xFFFFFF);
        y += 10;
        for (Map.Entry entry : entityCounts.entrySet()) {
            MutableComponent unitText = Component.m_237115_((String)((String)entry.getKey())).m_130946_(": ").m_130946_(String.valueOf(entry.getValue()));
            guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)unitText, 5, y, 0xFFFFFF);
            y += 10;
        }
    }
}

