/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.client.freecam.ui.CustomButton;
import ydmsama.hundred_years_war.client.freecam.ui.TeamApplicationsWidget;

public class TeamApplicationEntry
extends ContainerObjectSelectionList.Entry<TeamApplicationEntry> {
    private final String playerName;
    private final UUID playerUUID;
    private final long applyTime;
    private final TeamApplicationsWidget parent;
    private final List<GuiEventListener> children = new ArrayList<GuiEventListener>();
    private final Minecraft minecraft;
    private CustomButton acceptButton;
    private CustomButton rejectButton;
    private static final ResourceLocation PLAYER_ICON = new ResourceLocation("hundred_years_war", "textures/gui/player.png");
    private static final int ICON_SIZE = 16;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public TeamApplicationEntry(String playerName, UUID playerUUID, long applyTime, TeamApplicationsWidget parent) {
        this.playerName = playerName;
        this.playerUUID = playerUUID;
        this.applyTime = applyTime;
        this.parent = parent;
        this.minecraft = Minecraft.m_91087_();
        this.acceptButton = new CustomButton(0, 0, 50, 20, (Component)Component.m_237115_((String)"ui.hundred_years_war.accept"), button -> {});
        this.rejectButton = new CustomButton(0, 0, 50, 20, (Component)Component.m_237115_((String)"ui.hundred_years_war.reject"), button -> {});
        this.rejectButton.setColor(-5636096, -3407872, -11206656);
        this.children.add(this.acceptButton);
        this.children.add(this.rejectButton);
    }

    public void setAcceptClickHandler(Runnable handler) {
        this.children.remove((Object)this.acceptButton);
        this.acceptButton = new CustomButton(this.acceptButton.m_252754_(), this.acceptButton.m_252907_(), this.acceptButton.m_5711_(), this.acceptButton.m_93694_(), this.acceptButton.m_6035_(), button -> handler.run());
        this.children.add(this.acceptButton);
    }

    public void setRejectClickHandler(Runnable handler) {
        this.children.remove((Object)this.rejectButton);
        this.rejectButton = new CustomButton(this.rejectButton.m_252754_(), this.rejectButton.m_252907_(), this.rejectButton.m_5711_(), this.rejectButton.m_93694_(), this.rejectButton.m_6035_(), button -> handler.run());
        this.rejectButton.setColor(-5636096, -3407872, -11206656);
        this.children.add(this.rejectButton);
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public long getApplyTime() {
        return this.applyTime;
    }

    public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
        if (isHovering) {
            guiGraphics.m_280509_(left, top, left + width, top + height, 0x33FFFFFF);
        }
        Objects.requireNonNull(this.minecraft.f_91062_);
        int textY = top + (height - 9) / 2;
        guiGraphics.m_280488_(this.minecraft.f_91062_, this.playerName, left + 10, textY, 0xFFFFFF);
        int buttonWidth = 50;
        int buttonHeight = 20;
        int buttonY = top + (height - buttonHeight) / 2;
        this.acceptButton.m_252865_(left + width - buttonWidth * 2 - 10);
        this.acceptButton.m_253211_(buttonY);
        this.acceptButton.m_93674_(buttonWidth);
        this.acceptButton.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.rejectButton.m_252865_(left + width - buttonWidth - 5);
        this.rejectButton.m_253211_(buttonY);
        this.rejectButton.m_93674_(buttonWidth);
        this.rejectButton.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    @NotNull
    public List<? extends GuiEventListener> m_6702_() {
        return this.children;
    }

    @NotNull
    public List<? extends NarratableEntry> m_142437_() {
        return this.children.stream().filter(child -> child instanceof NarratableEntry).map(child -> (NarratableEntry)child).collect(Collectors.toList());
    }
}

