/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.client.freecam.ui.CustomButton;
import ydmsama.hundred_years_war.client.freecam.ui.TeamListWidget;

public class TeamListEntry
extends ContainerObjectSelectionList.Entry<TeamListEntry> {
    private final String teamName;
    private final TeamListWidget parent;
    private final List<GuiEventListener> children = new ArrayList<GuiEventListener>();
    private final Minecraft minecraft;
    private CustomButton joinButton;
    private final UUID teamUUID;
    private static final ResourceLocation TEAM_ICON = new ResourceLocation("hundred_years_war", "textures/gui/team.png");
    private static final int ICON_SIZE = 16;
    private int nameColor = 0xFFFFFF;

    public TeamListEntry(String teamName, UUID teamUUID, TeamListWidget parent) {
        this.teamName = teamName;
        this.teamUUID = teamUUID;
        this.parent = parent;
        this.minecraft = Minecraft.m_91087_();
        this.joinButton = new CustomButton(0, 0, 60, 20, (Component)Component.m_237115_((String)"button.hundred_years_war.join"), button -> this.onJoinTeam());
        this.children.add(this.joinButton);
    }

    public void setButtonText(Component text) {
        this.joinButton.m_93666_(text);
    }

    public void setButtonClickHandler(Runnable handler) {
        this.children.remove((Object)this.joinButton);
        this.joinButton = new CustomButton(this.joinButton.m_252754_(), this.joinButton.m_252907_(), this.joinButton.m_5711_(), this.joinButton.m_93694_(), this.joinButton.m_6035_(), button -> handler.run());
        this.children.add(this.joinButton);
    }

    public void setNameColor(int color) {
        this.nameColor = color;
    }

    public UUID getTeamUUID() {
        return this.teamUUID;
    }

    public String getTeamName() {
        return this.teamName;
    }

    protected void onJoinTeam() {
    }

    public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float partialTick) {
        guiGraphics.m_280163_(TEAM_ICON, left + 5, top + 4, 0.0f, 0.0f, 16, 16, 16, 16);
        guiGraphics.m_280488_(this.minecraft.f_91062_, this.teamName, left + 16 + 10, top + 6, this.nameColor);
        int buttonWidth = 60;
        int buttonHeight = 20;
        int buttonX = left + width - buttonWidth - 5;
        int buttonY = top + (height - buttonHeight) / 2;
        this.joinButton.m_252865_(buttonX);
        this.joinButton.m_253211_(buttonY);
        this.joinButton.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    @NotNull
    public List<? extends GuiEventListener> m_6702_() {
        return this.children;
    }

    @NotNull
    public List<? extends NarratableEntry> m_142437_() {
        return this.children.stream().filter(child -> child instanceof NarratableEntry).map(child -> (NarratableEntry)child).collect(Collectors.toList());
    }
}

