/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import ydmsama.hundred_years_war.client.freecam.ui.CustomButton;
import ydmsama.hundred_years_war.client.freecam.ui.CustomConfirmScreen;
import ydmsama.hundred_years_war.client.freecam.ui.MemberListEntry;
import ydmsama.hundred_years_war.client.freecam.ui.MemberListWidget;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.TeamMembersResponsePacket;

public class TeamMembersUI
extends Screen {
    private static final int WINDOW_WIDTH = 240;
    private static final int WINDOW_HEIGHT = 250;
    private final Screen parentScreen;
    private final UUID teamUUID;
    private final String teamName;
    private final String teamOwnerName;
    private final List<String> teamMembers;
    private final List<String> teamAdmins;
    private int leftPos;
    private int topPos;
    private EditBox searchBox;
    private MemberListWidget memberListWidget;
    private CustomButton backButton;
    private CustomButton applyButton;
    private List<MemberInfo> filteredMembers = new ArrayList<MemberInfo>();
    private Map<UUID, MemberListEntry.MemberRole> roleChanges = new HashMap<UUID, MemberListEntry.MemberRole>();
    private boolean hasChanges = false;

    public TeamMembersUI(Screen parentScreen, UUID teamUUID, String teamName, String teamOwnerName, List<String> teamMembers, List<String> teamAdmins) {
        super((Component)Component.m_237115_((String)"ui.hundred_years_war.team_members_ui"));
        this.parentScreen = parentScreen;
        this.teamUUID = teamUUID;
        this.teamName = teamName;
        this.teamOwnerName = teamOwnerName;
        this.teamMembers = teamMembers;
        this.teamAdmins = teamAdmins;
        this.updateMembersList();
        ClientPacketHandler.requestTeamMembers(teamUUID);
        TeamMembersResponsePacket cachedData = ClientPacketHandler.getLatestTeamMembersData();
        if (cachedData != null && cachedData.getTeamUUID().equals(teamUUID)) {
            this.updateMembersFromResponse(cachedData);
        }
    }

    private void updateMembersList() {
        this.filteredMembers.clear();
        for (String memberName : this.teamMembers) {
            boolean isAdmin = this.teamAdmins.contains(memberName);
            boolean isOwner = memberName.equals(this.teamOwnerName);
            UUID memberUUID = UUID.nameUUIDFromBytes(memberName.getBytes());
            this.filteredMembers.add(new MemberInfo(memberName, memberUUID, isAdmin, isOwner));
        }
    }

    private void filterMembers(String filter) {
        System.out.println("\u6267\u884c\u8fc7\u6ee4\uff0c\u8fc7\u6ee4\u6761\u4ef6: " + filter);
        if (filter == null || filter.isEmpty()) {
            this.filteredMembers.clear();
            TeamMembersResponsePacket cachedData = ClientPacketHandler.getLatestTeamMembersData();
            if (cachedData != null && cachedData.getTeamUUID().equals(this.teamUUID)) {
                for (TeamMembersResponsePacket.Member member : cachedData.getMembers()) {
                    String memberName = member.getPlayerName();
                    UUID memberUUID = member.getPlayerUUID();
                    boolean isAdmin = member.getRole() == TeamMembersResponsePacket.Member.Role.ADMIN;
                    boolean isOwner = member.getRole() == TeamMembersResponsePacket.Member.Role.OWNER;
                    this.filteredMembers.add(new MemberInfo(memberName, memberUUID, isAdmin, isOwner));
                }
            } else {
                this.updateMembersList();
            }
        } else {
            String lowerFilter = filter.toLowerCase();
            this.filteredMembers.clear();
            TeamMembersResponsePacket cachedData = ClientPacketHandler.getLatestTeamMembersData();
            if (cachedData != null && cachedData.getTeamUUID().equals(this.teamUUID)) {
                for (TeamMembersResponsePacket.Member member : cachedData.getMembers()) {
                    if (!member.getPlayerName().toLowerCase().contains(lowerFilter)) continue;
                    String memberName = member.getPlayerName();
                    UUID memberUUID = member.getPlayerUUID();
                    boolean isAdmin = member.getRole() == TeamMembersResponsePacket.Member.Role.ADMIN;
                    boolean isOwner = member.getRole() == TeamMembersResponsePacket.Member.Role.OWNER;
                    this.filteredMembers.add(new MemberInfo(memberName, memberUUID, isAdmin, isOwner));
                }
            } else {
                this.filteredMembers = this.teamMembers.stream().filter(name -> name.toLowerCase().contains(lowerFilter)).map(name -> {
                    boolean isAdmin = this.teamAdmins.contains(name);
                    boolean isOwner = name.equals(this.teamOwnerName);
                    UUID memberUUID = UUID.nameUUIDFromBytes(name.getBytes());
                    return new MemberInfo((String)name, memberUUID, isAdmin, isOwner);
                }).collect(Collectors.toList());
            }
        }
        System.out.println("\u8fc7\u6ee4\u540e\u6210\u5458\u6570\u91cf: " + this.filteredMembers.size());
        if (this.memberListWidget != null) {
            this.updateMemberListWidget();
            this.memberListWidget.m_93410_(0.0);
        }
    }

    public void updateMembersFromResponse(TeamMembersResponsePacket packet) {
        if (packet == null || !packet.getTeamUUID().equals(this.teamUUID)) {
            return;
        }
        this.filteredMembers.clear();
        for (TeamMembersResponsePacket.Member member : packet.getMembers()) {
            String memberName = member.getPlayerName();
            UUID memberUUID = member.getPlayerUUID();
            boolean isAdmin = member.getRole() == TeamMembersResponsePacket.Member.Role.ADMIN;
            boolean isOwner = member.getRole() == TeamMembersResponsePacket.Member.Role.OWNER;
            this.filteredMembers.add(new MemberInfo(memberName, memberUUID, isAdmin, isOwner));
        }
        if (this.memberListWidget != null) {
            this.updateMemberListWidget();
            this.memberListWidget.m_93410_(0.0);
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - 240) / 2;
        this.topPos = (this.f_96544_ - 250) / 2;
        this.searchBox = new EditBox(this.f_96547_, this.leftPos + 20, this.topPos + 20 + 25, 200, 20, (Component)Component.m_237115_((String)"ui.hundred_years_war.search"));
        this.searchBox.m_94199_(32);
        this.searchBox.m_94182_(true);
        this.searchBox.m_94190_(true);
        this.searchBox.m_94202_(0xFFFFFF);
        this.searchBox.m_94144_("");
        this.searchBox.m_94151_(s -> {
            System.out.println("\u641c\u7d22\u6846\u8f93\u5165: " + s);
            this.filterMembers((String)s);
        });
        this.m_142416_((GuiEventListener)this.searchBox);
        this.memberListWidget = new MemberListWidget(this.f_96541_, 200, 140, this.topPos + 20 + 50, this.topPos + 250 - 20 - 20 - 5, 24);
        this.memberListWidget.m_93507_(this.leftPos + 20);
        this.m_142416_((GuiEventListener)this.memberListWidget);
        this.backButton = new CustomButton(this.leftPos + 240 - 60 - 10, this.topPos + 250 - 20 - 10, 60, 20, (Component)Component.m_237115_((String)"ui.hundred_years_war.back"), button -> this.m_7379_());
        this.m_142416_(this.backButton);
        this.applyButton = new CustomButton(this.leftPos + 10, this.topPos + 250 - 20 - 10, 60, 20, (Component)Component.m_237115_((String)"ui.hundred_years_war.apply"), button -> this.applyChanges());
        this.applyButton.f_93623_ = true;
        this.m_142416_(this.applyButton);
        this.updateMemberListWidget();
    }

    private void updateMemberListWidget() {
        this.memberListWidget.m_93516_();
        if (this.filteredMembers.isEmpty()) {
            return;
        }
        String currentPlayerName = Minecraft.m_91087_().f_91074_.m_7755_().getString();
        boolean isCurrentPlayerOwnerOrAdmin = this.teamOwnerName.equals(currentPlayerName) || this.teamAdmins.contains(currentPlayerName);
        for (MemberInfo member : this.filteredMembers) {
            boolean canRemove;
            boolean isSelf = member.getName().equals(currentPlayerName);
            boolean canModify = this.teamOwnerName.equals(currentPlayerName);
            boolean bl = canRemove = isCurrentPlayerOwnerOrAdmin && !member.isOwner() && !isSelf;
            MemberListEntry.MemberRole initialRole = member.isOwner() ? MemberListEntry.MemberRole.OWNER : (member.isAdmin() ? MemberListEntry.MemberRole.ADMIN : MemberListEntry.MemberRole.MEMBER);
            MemberListEntry.MemberRole displayRole = this.roleChanges.containsKey(member.getUuid()) ? this.roleChanges.get(member.getUuid()) : initialRole;
            MemberListEntry entry = MemberListEntry.create(member.getName(), member.getUuid(), displayRole == MemberListEntry.MemberRole.ADMIN, displayRole == MemberListEntry.MemberRole.OWNER, isSelf, this.memberListWidget, canRemove ? this::removeMember : null, canModify ? this::onRoleChanged : null);
            this.memberListWidget.addEntry(entry);
        }
    }

    private void onRoleChanged(UUID memberUUID, MemberListEntry.MemberRole newRole) {
        this.roleChanges.put(memberUUID, newRole);
        this.hasChanges = true;
    }

    private void applyChanges() {
        if (!this.validateChanges()) {
            return;
        }
        HashMap<UUID, TeamMembersResponsePacket.Member.Role> serverRoleUpdates = new HashMap<UUID, TeamMembersResponsePacket.Member.Role>();
        for (Map.Entry<UUID, MemberListEntry.MemberRole> entry : this.roleChanges.entrySet()) {
            UUID memberUUID = entry.getKey();
            MemberListEntry.MemberRole clientRole = entry.getValue();
            TeamMembersResponsePacket.Member.Role serverRole = clientRole.toServerRole();
            serverRoleUpdates.put(memberUUID, serverRole);
        }
        ClientPacketHandler.sendTeamMemberRolesUpdate(this.teamUUID, serverRoleUpdates);
        this.roleChanges.clear();
        this.hasChanges = false;
        ClientPacketHandler.requestTeamMembers(this.teamUUID);
        this.f_96541_.m_91152_(this.parentScreen);
    }

    private boolean validateChanges() {
        int ownerCount = 0;
        UUID ownerUUID = null;
        TeamMembersResponsePacket cachedData = ClientPacketHandler.getLatestTeamMembersData();
        if (cachedData == null) {
            this.f_96541_.m_91152_((Screen)new MessageScreen(this, (Component)Component.m_237115_((String)"ui.hundred_years_war.error"), (Component)Component.m_237115_((String)"ui.hundred_years_war.error.data_unavailable")));
            return false;
        }
        HashMap<UUID, MemberListEntry.MemberRole> currentRoles = new HashMap<UUID, MemberListEntry.MemberRole>();
        for (TeamMembersResponsePacket.Member member : cachedData.getMembers()) {
            TeamMembersResponsePacket.Member.Role serverRole = member.getRole();
            MemberListEntry.MemberRole role = MemberListEntry.MemberRole.fromServerRole(serverRole);
            currentRoles.put(member.getPlayerUUID(), role);
            if (role != MemberListEntry.MemberRole.OWNER) continue;
            ownerUUID = member.getPlayerUUID();
        }
        for (Map.Entry entry : this.roleChanges.entrySet()) {
            currentRoles.put((UUID)entry.getKey(), (MemberListEntry.MemberRole)((Object)entry.getValue()));
        }
        for (MemberListEntry.MemberRole memberRole : currentRoles.values()) {
            if (memberRole != MemberListEntry.MemberRole.OWNER) continue;
            ++ownerCount;
        }
        if (ownerCount == 0) {
            this.f_96541_.m_91152_((Screen)new MessageScreen(this, (Component)Component.m_237115_((String)"ui.hundred_years_war.error"), (Component)Component.m_237115_((String)"ui.hundred_years_war.error.require_owner")));
            return false;
        }
        if (ownerCount > 1) {
            this.f_96541_.m_91152_((Screen)new MessageScreen(this, (Component)Component.m_237115_((String)"ui.hundred_years_war.error"), (Component)Component.m_237115_((String)"ui.hundred_years_war.error.too_many_owners")));
            return false;
        }
        return true;
    }

    private void showErrorMessage(String message) {
        this.f_96541_.m_91152_((Screen)new MessageScreen(this, (Component)Component.m_237115_((String)"ui.hundred_years_war.error"), (Component)Component.m_237113_((String)message)));
    }

    private void removeMember(UUID memberUUID) {
        String memberName = "\u6b64\u6210\u5458";
        for (MemberInfo info : this.filteredMembers) {
            if (!info.getUuid().equals(memberUUID)) continue;
            memberName = info.getName();
            break;
        }
        String finalMemberName = memberName;
        this.f_96541_.m_91152_((Screen)new CustomConfirmScreen(this, (Component)Component.m_237115_((String)"ui.hundred_years_war.confirm"), (Component)Component.m_237110_((String)"ui.hundred_years_war.remove_member_confirm", (Object[])new Object[]{finalMemberName}), confirmed -> {
            if (confirmed) {
                ClientPacketHandler.requestTeamManage(this.teamUUID, "remove", memberUUID);
                ClientPacketHandler.requestTeamMembers(this.teamUUID);
            }
            Minecraft.m_91087_().m_91152_((Screen)this);
        }));
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 240, this.topPos + 250, -1073741824);
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 240, this.topPos + 1, -1);
        guiGraphics.m_280509_(this.leftPos, this.topPos + 250 - 1, this.leftPos + 240, this.topPos + 250, -1);
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 1, this.topPos + 250, -1);
        guiGraphics.m_280509_(this.leftPos + 240 - 1, this.topPos, this.leftPos + 240, this.topPos + 250, -1);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.leftPos + 120, this.topPos + 10, 0xFFFFFF);
        if (this.filteredMembers.isEmpty()) {
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"ui.hundred_years_war.no_members"), this.leftPos + 120, this.topPos + 125, 0xFFFFFF);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.searchBox.m_5534_(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.m_7379_();
            return true;
        }
        if (this.searchBox.m_93696_() && this.searchBox.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public void m_7379_() {
        if (this.hasChanges) {
            this.f_96541_.m_91152_((Screen)new CustomConfirmScreen(this, (Component)Component.m_237115_((String)"ui.hundred_years_war.confirm"), (Component)Component.m_237115_((String)"ui.hundred_years_war.unsaved_changes_confirm"), confirmed -> {
                if (confirmed) {
                    Minecraft.m_91087_().m_91152_(this.parentScreen);
                } else {
                    Minecraft.m_91087_().m_91152_((Screen)this);
                }
            }));
            return;
        }
        Minecraft.m_91087_().m_91152_(this.parentScreen);
    }

    public static class MemberInfo {
        private final String name;
        private final UUID uuid;
        private final boolean isAdmin;
        private final boolean isOwner;

        public MemberInfo(String name, UUID uuid, boolean isAdmin, boolean isOwner) {
            this.name = name;
            this.uuid = uuid;
            this.isAdmin = isAdmin;
            this.isOwner = isOwner;
        }

        public String getName() {
            return this.name;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public boolean isAdmin() {
            return this.isAdmin;
        }

        public boolean isOwner() {
            return this.isOwner;
        }
    }

    class MessageScreen
    extends Screen {
        private final Screen parent;
        private final Component message;
        private CustomButton okButton;

        public MessageScreen(Screen parent, Component title, Component message) {
            super(title);
            this.parent = parent;
            this.message = message;
        }

        protected void m_7856_() {
            super.m_7856_();
            this.okButton = new CustomButton((this.f_96543_ - 100) / 2, this.f_96544_ / 2 + 40, 100, 20, (Component)Component.m_237115_((String)"ui.hundred_years_war.ok"), button -> Minecraft.m_91087_().m_91152_(this.parent));
            this.m_142416_(this.okButton);
        }

        public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.m_280273_(guiGraphics);
            guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, this.f_96544_ / 2 - 30, 0xFFFFFF);
            guiGraphics.m_280653_(this.f_96547_, this.message, this.f_96543_ / 2, this.f_96544_ / 2, 0xFFFFFF);
            super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
    }
}

