/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import ydmsama.hundred_years_war.client.freecam.ui.CustomButton;
import ydmsama.hundred_years_war.client.freecam.ui.CustomConfirmScreen;
import ydmsama.hundred_years_war.client.freecam.ui.TeamRelationListEntry;
import ydmsama.hundred_years_war.client.freecam.ui.TeamRelationListWidget;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.TeamRelationResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamRelationUpdatePacket;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

public class TeamRelationUI
extends Screen {
    private static final int WINDOW_WIDTH = 240;
    private static final int WINDOW_HEIGHT = 250;
    private static final int SEARCH_BOX_HEIGHT = 20;
    private static final int PLAYER_ITEM_HEIGHT = 24;
    private static final int PLAYER_LIST_HEIGHT = 150;
    private int leftPos;
    private int topPos;
    private EditBox searchBox;
    private TeamRelationListWidget playerListWidget;
    private String searchText = "";
    private List<PlayerRelationInfo> playerInfoList = new ArrayList<PlayerRelationInfo>();
    private List<PlayerRelationInfo> filteredPlayerInfoList = new ArrayList<PlayerRelationInfo>();
    private CustomButton applyButton;
    private boolean hasChanges = false;
    private final UUID teamUUID;
    private final String teamName;
    private final Screen parentScreen;

    public TeamRelationUI(Screen parentScreen, UUID teamUUID, String teamName) {
        super((Component)Component.m_237115_((String)"ui.hundred_years_war.team_relation_ui"));
        this.parentScreen = parentScreen;
        this.teamUUID = teamUUID;
        this.teamName = teamName;
        ClientPacketHandler.requestTeamRelationData(teamUUID);
    }

    public void onTeamRelationDataUpdate(TeamRelationResponsePacket packet) {
        Object info;
        this.playerInfoList.clear();
        for (Map.Entry<UUID, TeamRelationResponsePacket.RelationInfo> entry : packet.getRelationInfoMap().entrySet()) {
            info = entry.getValue();
            PlayerRelationInfo playerInfo = new PlayerRelationInfo(entry.getKey(), ((TeamRelationResponsePacket.RelationInfo)info).getPlayerName(), ((TeamRelationResponsePacket.RelationInfo)info).getTeamRelation(), ((TeamRelationResponsePacket.RelationInfo)info).getTheirRelation(), TeamRelationListEntry.EntryType.PERSONAL);
            playerInfo.resetChanged();
            this.playerInfoList.add(playerInfo);
        }
        for (Map.Entry<UUID, Object> entry : packet.getTeamInfoMap().entrySet()) {
            info = (TeamRelationResponsePacket.TeamInfo)entry.getValue();
            RelationSystem.RelationType theirRelation = ((TeamRelationResponsePacket.TeamInfo)info).getTheirRelation() != null ? ((TeamRelationResponsePacket.TeamInfo)info).getTheirRelation() : RelationSystem.RelationType.NEUTRAL;
            PlayerRelationInfo teamInfo = new PlayerRelationInfo(entry.getKey(), ((TeamRelationResponsePacket.TeamInfo)info).getTeamName(), ((TeamRelationResponsePacket.TeamInfo)info).getTeamRelation(), theirRelation, TeamRelationListEntry.EntryType.TEAM);
            teamInfo.resetChanged();
            this.playerInfoList.add(teamInfo);
        }
        this.updateFilteredPlayerList();
        if (this.playerListWidget != null) {
            this.updatePlayerList();
        }
        this.hasChanges = false;
        this.updateApplyButton();
        this.f_96541_.f_91065_.m_93076_().m_93785_((Component)Component.m_237115_((String)"message.hundred_years_war.team_relation_settings_updated"));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - 240) / 2;
        this.topPos = (this.f_96544_ - 250) / 2;
        this.searchBox = new EditBox(this.f_96547_, this.leftPos + 10, this.topPos + 20 + 15, 220, 20, (Component)Component.m_237115_((String)"ui.hundred_years_war.search"));
        this.searchBox.m_94199_(50);
        this.searchBox.m_94182_(true);
        this.searchBox.m_94194_(true);
        this.searchBox.m_94202_(0xFFFFFF);
        this.searchBox.m_94144_(this.searchText);
        this.searchBox.m_94151_(this::onSearchTextChanged);
        this.m_142416_((GuiEventListener)this.searchBox);
        int playerListTop = this.topPos + 20 + 15 + 20 + 5;
        this.playerListWidget = new TeamRelationListWidget(this, this.f_96541_, 220, 150, playerListTop, playerListTop + 150, 24);
        this.playerListWidget.m_93507_(this.leftPos + 10);
        this.updateFilteredPlayerList();
        this.updatePlayerList();
        this.m_7787_((GuiEventListener)this.playerListWidget);
        this.applyButton = new CustomButton(this.leftPos + 10, this.topPos + 250 - 20 - 10, 60, 20, (Component)Component.m_237115_((String)"ui.hundred_years_war.apply"), button -> this.applyChanges());
        this.applyButton.f_93623_ = true;
        this.m_142416_(this.applyButton);
        this.m_142416_(new CustomButton(this.leftPos + 240 - 60 - 10, this.topPos + 250 - 20 - 10, 60, 20, (Component)Component.m_237115_((String)"ui.hundred_years_war.back"), button -> this.m_7379_()));
    }

    private void updateApplyButton() {
        if (this.applyButton != null) {
            this.applyButton.f_93623_ = true;
        }
    }

    private void applyChanges() {
        TeamRelationUpdatePacket updatePacket = new TeamRelationUpdatePacket(this.teamUUID);
        for (PlayerRelationInfo info : this.playerInfoList) {
            if (!info.hasChanged()) continue;
            updatePacket.addRelationUpdate(info.getPlayerUUID(), info.getMyRelation());
        }
        ClientPacketHandler.sendTeamRelationUpdate(updatePacket);
        this.f_96541_.f_91065_.m_93076_().m_93785_((Component)Component.m_237115_((String)"message.hundred_years_war.applying_team_relation_settings"));
        this.f_96541_.m_91152_(this.parentScreen);
    }

    private void updateFilteredPlayerList() {
        Map<UUID, PlayerRelationInfo> teamInfoMap = new HashMap<UUID, PlayerRelationInfo>();
        HashMap<UUID, List> teamMembersMap = new HashMap<UUID, List>();
        List<PlayerRelationInfo> soloPlayers = new ArrayList<PlayerRelationInfo>();
        TeamRelationResponsePacket relationData = ClientPacketHandler.getLatestTeamRelationData();
        for (PlayerRelationInfo playerRelationInfo : this.playerInfoList) {
            if (playerRelationInfo.getEntryType() == TeamRelationListEntry.EntryType.TEAM) {
                teamInfoMap.put(playerRelationInfo.getPlayerUUID(), playerRelationInfo);
                teamMembersMap.computeIfAbsent(playerRelationInfo.getPlayerUUID(), k -> new ArrayList());
                continue;
            }
            boolean belongsToTeam = false;
            if (relationData != null) {
                for (Map.Entry<UUID, TeamRelationResponsePacket.TeamInfo> entry2 : relationData.getTeamInfoMap().entrySet()) {
                    UUID uUID = entry2.getKey();
                    TeamRelationResponsePacket.TeamInfo teamInfo = entry2.getValue();
                    if (!teamInfo.getMembers().containsKey(playerRelationInfo.getPlayerUUID())) continue;
                    teamMembersMap.computeIfAbsent(uUID, k -> new ArrayList()).add(playerRelationInfo);
                    belongsToTeam = true;
                    break;
                }
            }
            if (belongsToTeam) continue;
            soloPlayers.add(playerRelationInfo);
        }
        if (!this.searchText.isEmpty()) {
            String searchLower = this.searchText.toLowerCase();
            List list = soloPlayers.stream().filter(info -> info.getPlayerName().toLowerCase().contains(searchLower)).collect(Collectors.toList());
            HashSet<UUID> teamsWithMatchingMembers = new HashSet<UUID>();
            HashMap filteredTeamMembersMap = new HashMap();
            for (Map.Entry entry3 : teamMembersMap.entrySet()) {
                UUID teamUUID = (UUID)entry3.getKey();
                List members = (List)entry3.getValue();
                List filteredMembers = members.stream().filter(info -> info.getPlayerName().toLowerCase().contains(searchLower)).collect(Collectors.toList());
                if (filteredMembers.isEmpty()) continue;
                filteredTeamMembersMap.put(teamUUID, filteredMembers);
                teamsWithMatchingMembers.add(teamUUID);
            }
            Map<UUID, PlayerRelationInfo> map = teamInfoMap.entrySet().stream().filter(entry -> ((PlayerRelationInfo)entry.getValue()).getPlayerName().toLowerCase().contains(searchLower) || teamsWithMatchingMembers.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            soloPlayers = list;
            teamInfoMap = map;
            teamMembersMap = filteredTeamMembersMap;
        }
        this.filteredPlayerInfoList = new ArrayList<PlayerRelationInfo>();
        this.filteredPlayerInfoList.addAll(soloPlayers);
        for (Map.Entry entry4 : teamInfoMap.entrySet()) {
            UUID teamUUID = (UUID)entry4.getKey();
            PlayerRelationInfo teamInfo = (PlayerRelationInfo)entry4.getValue();
            this.filteredPlayerInfoList.add(teamInfo);
            if (!teamMembersMap.containsKey(teamUUID)) continue;
            this.filteredPlayerInfoList.addAll((Collection)teamMembersMap.get(teamUUID));
        }
    }

    private boolean isTeamMember(UUID playerUUID) {
        TeamRelationResponsePacket packet = ClientPacketHandler.getLatestTeamRelationData();
        if (packet != null && packet.getTeamUUID().equals(this.teamUUID)) {
            for (Map.Entry<UUID, TeamRelationResponsePacket.TeamInfo> entry : packet.getTeamInfoMap().entrySet()) {
                if (!entry.getValue().getMembers().containsKey(playerUUID)) continue;
                return true;
            }
        }
        return false;
    }

    private void updatePlayerList() {
        if (this.playerListWidget != null) {
            this.playerListWidget.clearAllEntries();
            HashMap<UUID, Integer> teamIndexMap = new HashMap<UUID, Integer>();
            HashMap teamMembersMap = new HashMap();
            for (int i = 0; i < this.filteredPlayerInfoList.size(); ++i) {
                PlayerRelationInfo info = this.filteredPlayerInfoList.get(i);
                TeamRelationListEntry teamRelationListEntry = TeamRelationListEntry.createForRelationUI(info.getPlayerName(), info.getPlayerUUID(), info.getMyRelation(), info.getTheirRelation(), this.playerListWidget, this::onRelationChanged, info.getEntryType());
                int entryIndex = this.playerListWidget.addEntry(teamRelationListEntry);
                if (info.getEntryType() != TeamRelationListEntry.EntryType.TEAM) continue;
                teamIndexMap.put(info.getPlayerUUID(), entryIndex);
                teamMembersMap.put(info.getPlayerUUID(), new ArrayList());
            }
            TeamRelationResponsePacket relationData = ClientPacketHandler.getLatestTeamRelationData();
            if (relationData != null) {
                block1: for (int i = 0; i < this.filteredPlayerInfoList.size(); ++i) {
                    PlayerRelationInfo playerRelationInfo = this.filteredPlayerInfoList.get(i);
                    if (playerRelationInfo.getEntryType() != TeamRelationListEntry.EntryType.PERSONAL) continue;
                    for (Map.Entry<UUID, TeamRelationResponsePacket.TeamInfo> teamEntry : relationData.getTeamInfoMap().entrySet()) {
                        UUID teamUUID = teamEntry.getKey();
                        TeamRelationResponsePacket.TeamInfo teamInfo = teamEntry.getValue();
                        if (!teamInfo.getMembers().containsKey(playerRelationInfo.getPlayerUUID())) continue;
                        if (!teamIndexMap.containsKey(teamUUID)) continue block1;
                        ((List)teamMembersMap.get(teamUUID)).add(i);
                        continue block1;
                    }
                }
                for (Map.Entry entry : teamMembersMap.entrySet()) {
                    UUID teamUUID = (UUID)entry.getKey();
                    List memberIndices = (List)entry.getValue();
                    this.playerListWidget.setTeamMembers(teamUUID, memberIndices);
                }
            }
        }
    }

    private void onRelationChanged(UUID playerUUID, RelationSystem.RelationType newRelation) {
        for (PlayerRelationInfo info : this.playerInfoList) {
            TeamRelationResponsePacket relationData;
            if (!info.getPlayerUUID().equals(playerUUID)) continue;
            info.setMyRelation(newRelation);
            if (info.getEntryType() != TeamRelationListEntry.EntryType.TEAM || (relationData = ClientPacketHandler.getLatestTeamRelationData()) == null || !relationData.getTeamInfoMap().containsKey(playerUUID)) break;
            TeamRelationResponsePacket.TeamInfo teamInfo = relationData.getTeamInfoMap().get(playerUUID);
            block1: for (UUID memberUUID : teamInfo.getMembers().keySet()) {
                for (PlayerRelationInfo memberInfo : this.playerInfoList) {
                    if (!memberInfo.getPlayerUUID().equals(memberUUID)) continue;
                    memberInfo.setMyRelation(newRelation);
                    this.updateMemberEntryRelation(memberUUID, newRelation);
                    continue block1;
                }
            }
        }
        this.hasChanges = true;
        this.updateApplyButton();
    }

    private void updateMemberEntryRelation(UUID memberUUID, RelationSystem.RelationType newRelation) {
        for (TeamRelationListEntry entry : this.playerListWidget.m_6702_()) {
            if (!entry.getPlayerUUID().equals(memberUUID)) continue;
            entry.setRelation(TeamRelationListEntry.convertFromSystemRelation(newRelation));
            break;
        }
    }

    private void onSearchTextChanged(String text) {
        this.searchText = text;
        this.updateFilteredPlayerList();
        this.updatePlayerList();
        if (this.playerListWidget != null) {
            this.playerListWidget.m_93410_(0.0);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 240, this.topPos + 250, -1073741824);
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 240, this.topPos + 1, -1);
        guiGraphics.m_280509_(this.leftPos, this.topPos + 250 - 1, this.leftPos + 240, this.topPos + 250, -1);
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 1, this.topPos + 250, -1);
        guiGraphics.m_280509_(this.leftPos + 240 - 1, this.topPos, this.leftPos + 240, this.topPos + 250, -1);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.leftPos + 120, this.topPos + 10, 0xFFFFFF);
        guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)this.teamName), this.leftPos + 120, this.topPos + 10 + 15, 0xFFFFFF);
        guiGraphics.m_280488_(this.f_96547_, Component.m_237115_((String)"ui.hundred_years_war.search").getString().split("\\.\\.\\.")[0], this.leftPos + 10, this.topPos + 20 + 5, 0xFFFFFF);
        if (this.playerListWidget != null) {
            this.playerListWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        if (this.filteredPlayerInfoList.isEmpty()) {
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"ui.hundred_years_war.no_members_found"), this.leftPos + 120, this.topPos + 20 + 60, 0xBBBBBB);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.playerListWidget != null && this.playerListWidget.m_5953_(mouseX, mouseY) && this.playerListWidget.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.playerListWidget.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.playerListWidget != null && this.playerListWidget.m_5953_(mouseX, mouseY)) {
            return this.playerListWidget.m_6050_(mouseX, mouseY, delta);
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox.m_93696_() && this.searchBox.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 256) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.searchBox.m_93696_() && this.searchBox.m_5534_(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    public void m_7379_() {
        if (this.hasChanges) {
            Minecraft.m_91087_().m_91152_((Screen)new CustomConfirmScreen(this, (Component)Component.m_237115_((String)"ui.hundred_years_war.confirm"), (Component)Component.m_237115_((String)"ui.hundred_years_war.unsaved_changes_confirm"), this::closeConfirmed));
        } else {
            this.closeConfirmed(true);
        }
    }

    private void closeConfirmed(boolean confirmed) {
        if (confirmed) {
            Minecraft.m_91087_().m_91152_(this.parentScreen);
        } else {
            Minecraft.m_91087_().m_91152_((Screen)this);
        }
    }

    public static class PlayerRelationInfo {
        private final UUID playerUUID;
        private final String playerName;
        private RelationSystem.RelationType myRelation;
        private final RelationSystem.RelationType theirRelation;
        private boolean hasChanged = false;
        private final TeamRelationListEntry.EntryType entryType;

        public PlayerRelationInfo(UUID playerUUID, String playerName, RelationSystem.RelationType myRelation, RelationSystem.RelationType theirRelation) {
            this(playerUUID, playerName, myRelation, theirRelation, TeamRelationListEntry.EntryType.PERSONAL);
        }

        public PlayerRelationInfo(UUID playerUUID, String playerName, RelationSystem.RelationType myRelation, RelationSystem.RelationType theirRelation, TeamRelationListEntry.EntryType entryType) {
            this.playerUUID = playerUUID;
            this.playerName = playerName;
            this.myRelation = myRelation;
            this.theirRelation = theirRelation;
            this.entryType = entryType;
        }

        public UUID getPlayerUUID() {
            return this.playerUUID;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public RelationSystem.RelationType getMyRelation() {
            return this.myRelation;
        }

        public void setMyRelation(RelationSystem.RelationType relation) {
            if (this.myRelation != relation) {
                this.myRelation = relation;
                this.hasChanged = true;
            }
        }

        public RelationSystem.RelationType getTheirRelation() {
            return this.theirRelation;
        }

        public boolean hasChanged() {
            return this.hasChanged;
        }

        public void resetChanged() {
            this.hasChanged = false;
        }

        public TeamRelationListEntry.EntryType getEntryType() {
            return this.entryType;
        }
    }
}

