/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui.manual;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import ydmsama.hundred_years_war.client.freecam.ui.manual.ManualImage;

public class ManualPage {
    private final MultiLineLabel textLabel;
    private final List<ManualImage> images = new ArrayList<ManualImage>();
    private final int width;
    private final int lineHeight;

    public ManualPage(String text, List<ManualImage> images, int width, Font font, int lineHeight) {
        Component textComponent = ManualPage.parseFormattedText(text);
        this.textLabel = MultiLineLabel.m_94341_((Font)font, (FormattedText)textComponent, (int)width);
        this.images.addAll(images);
        this.width = width;
        this.lineHeight = lineHeight;
    }

    private static Component parseFormattedText(String text) {
        Pattern formatPattern = Pattern.compile("\u00a7([0-9a-fk-or])");
        MutableComponent result = Component.m_237119_();
        int lastIndex = 0;
        ChatFormatting currentColor = null;
        boolean bold = false;
        boolean italic = false;
        boolean underlined = false;
        boolean strikethrough = false;
        boolean obfuscated = false;
        Matcher matcher = formatPattern.matcher(text);
        while (matcher.find()) {
            char formatCode;
            String beforeFormat = text.substring(lastIndex, matcher.start());
            if (!beforeFormat.isEmpty()) {
                MutableComponent textPart = Component.m_237113_((String)beforeFormat);
                textPart = ManualPage.applyCurrentFormatting(textPart, currentColor, bold, italic, underlined, strikethrough, obfuscated);
                result.m_7220_((Component)textPart);
            }
            if ((formatCode = matcher.group(1).charAt(0)) >= '0' && formatCode <= '9' || formatCode >= 'a' && formatCode <= 'f') {
                currentColor = ManualPage.getChatFormatting(formatCode);
                obfuscated = false;
                strikethrough = false;
                underlined = false;
                italic = false;
                bold = false;
            } else if (formatCode == 'r') {
                currentColor = null;
                obfuscated = false;
                strikethrough = false;
                underlined = false;
                italic = false;
                bold = false;
            } else {
                switch (formatCode) {
                    case 'l': {
                        bold = true;
                        break;
                    }
                    case 'o': {
                        italic = true;
                        break;
                    }
                    case 'n': {
                        underlined = true;
                        break;
                    }
                    case 'm': {
                        strikethrough = true;
                        break;
                    }
                    case 'k': {
                        obfuscated = true;
                    }
                }
            }
            lastIndex = matcher.end();
        }
        String remainingText = text.substring(lastIndex);
        if (!remainingText.isEmpty()) {
            MutableComponent textPart = Component.m_237113_((String)remainingText);
            textPart = ManualPage.applyCurrentFormatting(textPart, currentColor, bold, italic, underlined, strikethrough, obfuscated);
            result.m_7220_((Component)textPart);
        }
        return result;
    }

    private static MutableComponent applyCurrentFormatting(MutableComponent component, ChatFormatting color, boolean bold, boolean italic, boolean underlined, boolean strikethrough, boolean obfuscated) {
        if (color != null) {
            component = component.m_130940_(color);
        }
        if (bold) {
            component = component.m_130940_(ChatFormatting.BOLD);
        }
        if (italic) {
            component = component.m_130940_(ChatFormatting.ITALIC);
        }
        if (underlined) {
            component = component.m_130940_(ChatFormatting.UNDERLINE);
        }
        if (strikethrough) {
            component = component.m_130940_(ChatFormatting.STRIKETHROUGH);
        }
        if (obfuscated) {
            component = component.m_130940_(ChatFormatting.OBFUSCATED);
        }
        return component;
    }

    private static ChatFormatting getChatFormatting(char code) {
        switch (code) {
            case '0': {
                return ChatFormatting.BLACK;
            }
            case '1': {
                return ChatFormatting.DARK_BLUE;
            }
            case '2': {
                return ChatFormatting.DARK_GREEN;
            }
            case '3': {
                return ChatFormatting.DARK_AQUA;
            }
            case '4': {
                return ChatFormatting.DARK_RED;
            }
            case '5': {
                return ChatFormatting.DARK_PURPLE;
            }
            case '6': {
                return ChatFormatting.GOLD;
            }
            case '7': {
                return ChatFormatting.GRAY;
            }
            case '8': {
                return ChatFormatting.DARK_GRAY;
            }
            case '9': {
                return ChatFormatting.BLUE;
            }
            case 'a': {
                return ChatFormatting.GREEN;
            }
            case 'b': {
                return ChatFormatting.AQUA;
            }
            case 'c': {
                return ChatFormatting.RED;
            }
            case 'd': {
                return ChatFormatting.LIGHT_PURPLE;
            }
            case 'e': {
                return ChatFormatting.YELLOW;
            }
            case 'f': {
                return ChatFormatting.WHITE;
            }
            case 'k': {
                return ChatFormatting.OBFUSCATED;
            }
            case 'l': {
                return ChatFormatting.BOLD;
            }
            case 'm': {
                return ChatFormatting.STRIKETHROUGH;
            }
            case 'n': {
                return ChatFormatting.UNDERLINE;
            }
            case 'o': {
                return ChatFormatting.ITALIC;
            }
            case 'r': {
                return ChatFormatting.RESET;
            }
        }
        return null;
    }

    public void render(GuiGraphics guiGraphics, int x, int y, int color) {
        this.textLabel.m_6508_(guiGraphics, x, y, this.lineHeight, color);
        for (ManualImage image : this.images) {
            image.render(guiGraphics, x, y);
        }
    }

    public void renderTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        for (ManualImage image : this.images) {
            image.renderTooltip(guiGraphics, mouseX, mouseY, x, y);
        }
    }

    public int getLineCount() {
        return this.textLabel.m_5770_();
    }
}

