/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui.manual;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.client.freecam.ui.manual.TableOfContentsWidget;

public class ManualTableOfContentsEntry
extends ContainerObjectSelectionList.Entry<ManualTableOfContentsEntry> {
    private final Component title;
    private final TableOfContentsWidget parent;
    private final List<GuiEventListener> children = new ArrayList<GuiEventListener>();
    private final Minecraft minecraft;
    private final Runnable onClick;
    private boolean isHovered = false;
    private int scrollOffset = 0;
    private long lastScrollTime = 0L;
    private static final int SCROLL_INTERVAL_MS = 30;
    private static final int SCROLL_PADDING = 10;

    public ManualTableOfContentsEntry(Component title, TableOfContentsWidget parent, Runnable onClick) {
        this.title = title;
        this.parent = parent;
        this.onClick = onClick;
        this.minecraft = Minecraft.m_91087_();
    }

    public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float partialTick) {
        this.isHovered = isHovered;
        int textColor = isHovered ? 0xFFFFFF : 0xDDDDDD;
        int availableWidth = width - 10;
        int textWidth = this.minecraft.f_91062_.m_92852_((FormattedText)this.title);
        if (isHovered) {
            guiGraphics.m_280509_(left, top, left + width, top + height, 0x40FFFFFF);
        }
        int textY = top + (height - 8) / 2;
        if (isHovered && textWidth > availableWidth) {
            long now = System.currentTimeMillis();
            if (now - this.lastScrollTime >= 30L) {
                this.lastScrollTime = now;
                ++this.scrollOffset;
                int fullCycle = textWidth + 10;
                if (this.scrollOffset > fullCycle) {
                    this.scrollOffset = 0;
                }
            }
            guiGraphics.m_280430_(this.minecraft.f_91062_, this.title, left + 5 - this.scrollOffset, textY, textColor);
            guiGraphics.m_280430_(this.minecraft.f_91062_, this.title, left + 5 - this.scrollOffset + textWidth + 10, textY, textColor);
        } else {
            this.scrollOffset = 0;
            this.lastScrollTime = System.currentTimeMillis();
            guiGraphics.m_280430_(this.minecraft.f_91062_, this.title, left + 5, textY, textColor);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isHovered && button == 0) {
            this.onClick.run();
            return true;
        }
        return false;
    }

    @NotNull
    public List<? extends GuiEventListener> m_6702_() {
        return this.children;
    }

    @NotNull
    public List<? extends NarratableEntry> m_142437_() {
        ArrayList<NarratableEntry> result = new ArrayList<NarratableEntry>();
        for (GuiEventListener child : this.children) {
            if (!(child instanceof NarratableEntry)) continue;
            result.add((NarratableEntry)child);
        }
        return result;
    }
}

