/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui.manual;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import ydmsama.hundred_years_war.client.freecam.ui.CustomButton;
import ydmsama.hundred_years_war.client.freecam.ui.CustomUI;
import ydmsama.hundred_years_war.client.freecam.ui.manual.ManualContentParser;
import ydmsama.hundred_years_war.client.freecam.ui.manual.ManualNode;
import ydmsama.hundred_years_war.client.freecam.ui.manual.ManualPage;
import ydmsama.hundred_years_war.client.freecam.ui.manual.ManualTableOfContentsEntry;
import ydmsama.hundred_years_war.client.freecam.ui.manual.ManualTree;
import ydmsama.hundred_years_war.client.freecam.ui.manual.TableOfContentsWidget;

public class ManualUI
extends Screen {
    private static final int WINDOW_WIDTH = 350;
    private static final int WINDOW_HEIGHT = 250;
    private static final int TABLE_OF_CONTENTS_WIDTH = 120;
    private int leftPos;
    private int topPos;
    private ManualTree manualTree;
    private ManualNode currentNode;
    private TableOfContentsWidget tocWidget;
    private CustomButton backButton;
    private CustomButton closeButton;
    private List<ManualPage> contentPages = new ArrayList<ManualPage>();
    private int currentPage = 0;
    private int totalPages = 1;
    private CustomButton prevPageButton;
    private CustomButton nextPageButton;
    private static final int CONTENT_MAX_LINES = 12;
    private static final int CONTENT_LINE_HEIGHT = 12;

    public ManualUI() {
        super((Component)Component.m_237115_((String)"ui.hundred_years_war.manual.title"));
        this.manualTree = new ManualTree();
        this.currentNode = this.manualTree.getRoot();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - 350) / 2;
        this.topPos = (this.f_96544_ - 250) / 2;
        int tocTop = this.topPos + 20 + 20;
        int tocHeight = 170;
        this.tocWidget = new TableOfContentsWidget(this.f_96541_, 120, tocHeight, tocTop, tocTop + tocHeight, 20);
        this.tocWidget.m_93507_(this.leftPos + 10);
        this.updateTableOfContents();
        this.m_7787_((GuiEventListener)this.tocWidget);
        this.backButton = new CustomButton(this.leftPos + 10, this.topPos + 250 - 20 - 10, 60, 20, (Component)Component.m_237115_((String)"ui.hundred_years_war.manual.back"), button -> this.navigateBack());
        this.m_142416_(this.backButton);
        this.closeButton = new CustomButton(this.leftPos + 350 - 60 - 10, this.topPos + 250 - 20 - 10, 60, 20, (Component)Component.m_237115_((String)"ui.hundred_years_war.close"), button -> this.m_7379_());
        this.m_142416_(this.closeButton);
        int paginationY = this.topPos + 250 - 20 - 20 - 18;
        int paginationCenterX = this.leftPos + 120 + 115;
        this.prevPageButton = new CustomButton(paginationCenterX - 50, paginationY, 20, 20, (Component)Component.m_237113_((String)"\u2190"), button -> this.changePage(-1));
        this.nextPageButton = new CustomButton(paginationCenterX + 30, paginationY, 20, 20, (Component)Component.m_237113_((String)"\u2192"), button -> this.changePage(1));
        this.m_142416_(this.prevPageButton);
        this.m_142416_(this.nextPageButton);
        this.updateContent();
        this.updateBackButton();
        this.updatePaginationButtons();
    }

    private void updateTableOfContents() {
        this.tocWidget.m_93516_();
        for (ManualNode child : this.currentNode.getChildren()) {
            ManualTableOfContentsEntry entry = new ManualTableOfContentsEntry((Component)Component.m_237115_((String)child.getTitleKey()), this.tocWidget, () -> this.navigateTo(child));
            this.tocWidget.addEntry(entry);
        }
        this.tocWidget.m_93410_(0.0);
    }

    private void updateContent() {
        this.contentPages.clear();
        this.currentPage = 0;
        MutableComponent content = Component.m_237115_((String)this.currentNode.getContentKey());
        int contentWidth = 200;
        this.contentPages = ManualContentParser.parseContent((Component)content, contentWidth, this.f_96547_, 12, 12);
        this.totalPages = Math.max(1, this.contentPages.size());
        this.updatePaginationButtons();
    }

    private void updateBackButton() {
        this.backButton.f_93623_ = true;
    }

    private void updatePaginationButtons() {
        this.prevPageButton.f_93623_ = this.currentPage > 0;
        this.nextPageButton.f_93623_ = this.currentPage < this.totalPages - 1;
    }

    private void changePage(int delta) {
        int newPage = this.currentPage + delta;
        if (newPage >= 0 && newPage < this.totalPages) {
            this.currentPage = newPage;
            this.updatePaginationButtons();
        }
    }

    private void navigateTo(ManualNode node) {
        this.currentNode = node;
        this.updateTableOfContents();
        this.updateContent();
        this.updateBackButton();
    }

    private void navigateBack() {
        if (this.currentNode.hasParent()) {
            this.navigateTo(this.currentNode.getParent());
        } else {
            Minecraft.m_91087_().m_91152_((Screen)new CustomUI());
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 350, this.topPos + 250, -1073741824);
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 350, this.topPos + 1, -1);
        guiGraphics.m_280509_(this.leftPos, this.topPos + 250 - 1, this.leftPos + 350, this.topPos + 250, -1);
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 1, this.topPos + 250, -1);
        guiGraphics.m_280509_(this.leftPos + 350 - 1, this.topPos, this.leftPos + 350, this.topPos + 250, -1);
        MutableComponent title = Component.m_237115_((String)this.currentNode.getTitleKey());
        guiGraphics.m_280653_(this.f_96547_, (Component)title, this.leftPos + 175, this.topPos + 10, 0xFFFFFF);
        guiGraphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"ui.hundred_years_war.manual.toc"), this.leftPos + 10, this.topPos + 20 + 5, 0xFFFFFF);
        int dividerX = this.leftPos + 120 + 10;
        guiGraphics.m_280509_(dividerX, this.topPos + 20 + 20, dividerX + 1, this.topPos + 250 - 10 - 20, -1);
        this.tocWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        int contentX = this.leftPos + 120 + 20;
        int contentY = this.topPos + 20 + 20;
        if (!this.contentPages.isEmpty() && this.currentPage < this.contentPages.size()) {
            ManualPage currentPage = this.contentPages.get(this.currentPage);
            currentPage.render(guiGraphics, contentX, contentY, 0xFFFFFF);
        }
        String pageInfo = String.format("%d/%d", this.currentPage + 1, this.totalPages);
        int pageInfoX = this.leftPos + 120 + 115;
        int pageInfoY = this.topPos + 250 - 20 - 20 - 14;
        guiGraphics.m_280137_(this.f_96547_, pageInfo, pageInfoX, pageInfoY, 0xFFFFFF);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        if (!this.contentPages.isEmpty() && this.currentPage < this.contentPages.size()) {
            ManualPage currentPage = this.contentPages.get(this.currentPage);
            currentPage.renderTooltips(guiGraphics, mouseX, mouseY, contentX, contentY);
        }
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        if (mouseX >= (double)this.tocWidget.getLeft() && mouseX <= (double)this.tocWidget.getRight() && mouseY >= (double)this.tocWidget.getTop() && mouseY <= (double)this.tocWidget.getBottom()) {
            return this.tocWidget.m_6050_(mouseX, mouseY, scrollDelta);
        }
        int contentAreaLeft = this.leftPos + 120 + 10;
        int contentAreaRight = this.leftPos + 350 - 10;
        int contentAreaTop = this.topPos + 20 + 20;
        int contentAreaBottom = this.topPos + 250 - 10 - 20 - 25;
        if (mouseX >= (double)contentAreaLeft && mouseX <= (double)contentAreaRight && mouseY >= (double)contentAreaTop && mouseY <= (double)contentAreaBottom) {
            if (scrollDelta < 0.0) {
                this.changePage(1);
            } else {
                this.changePage(-1);
            }
            return true;
        }
        return super.m_6050_(mouseX, mouseY, scrollDelta);
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(null);
    }
}

