/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui.wheel;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.client.freecam.selection.SelectionHandler;
import ydmsama.hundred_years_war.client.freecam.ui.wheel.CommandWheelHandler;
import ydmsama.hundred_years_war.client.freecam.ui.wheel.CommandWheelNode;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.client.utils.TraceHelper;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.network.packets.RecruitmentDataResponsePacket;
import ydmsama.hundred_years_war.main.recruitment.PlayerRecruitmentData;
import ydmsama.hundred_years_war.main.recruitment.data.RecruitmentConfig;

public class CommandWheelTree {
    private final CommandWheelNode root;
    private CommandWheelNode currentNode;
    private CommandWheelNode formationNode;
    private CommandWheelNode followNode;
    private CommandWheelNode attackNode;

    public CommandWheelTree() {
        this.currentNode = this.root = new CommandWheelNode("wheel.hundred_years_war.root");
        this.initCommands();
    }

    private void initCommands() {
        CommandWheelNode moveNode = new CommandWheelNode("wheel.hundred_years_war.move", node -> this.executeMove());
        this.root.addChild(moveNode);
        this.attackNode = new CommandWheelNode("wheel.hundred_years_war.attack", node -> this.executeAttack());
        this.attackNode.setDynamic(true);
        this.attackNode.setState("attack");
        this.root.addChild(this.attackNode);
        CommandWheelNode holdNode = new CommandWheelNode("wheel.hundred_years_war.hold", node -> this.executeHold());
        this.root.addChild(holdNode);
        CommandWheelNode followNode = new CommandWheelNode("wheel.hundred_years_war.follow", node -> this.executeFollow());
        this.root.addChild(followNode);
        CommandWheelNode formationModeNode = new CommandWheelNode("wheel.hundred_years_war.formation_mode", node -> this.toggleFormationMode((CommandWheelNode)node));
        formationModeNode.setDynamic(true);
        formationModeNode.setState(CommandWheelHandler.getInstance().isFormationMode() ? "on" : "off");
        this.root.addChild(formationModeNode);
        String currentFormation = CommandWheelHandler.getInstance().getCurrentFormation();
        this.formationNode = new CommandWheelNode("wheel.hundred_years_war.formation", node -> this.navigateTo((CommandWheelNode)node));
        if (currentFormation != null && !currentFormation.isEmpty()) {
            this.formationNode.setDynamic(true);
            this.formationNode.setState(currentFormation);
        }
        this.root.addChild(this.formationNode);
        CommandWheelNode backToRootNode = new CommandWheelNode("wheel.hundred_years_war.back", node -> this.navigateTo(this.root));
        this.formationNode.addChild(backToRootNode);
        this.formationNode.addChild(new CommandWheelNode("wheel.hundred_years_war.formation.loose", node -> this.executeFormationChange("loose")));
        this.formationNode.addChild(new CommandWheelNode("wheel.hundred_years_war.formation.tight", node -> this.executeFormationChange("tight")));
        this.formationNode.addChild(new CommandWheelNode("wheel.hundred_years_war.formation.line", node -> this.executeFormationChange("line")));
        this.formationNode.addChild(new CommandWheelNode("wheel.hundred_years_war.formation.circle", node -> this.executeFormationChange("circle")));
        this.formationNode.addChild(new CommandWheelNode("wheel.hundred_years_war.formation.wedge", node -> this.executeFormationChange("wedge")));
        CommandWheelNode entityManageNode = new CommandWheelNode("wheel.hundred_years_war.entity_manage", node -> this.executeEntityManagement());
        entityManageNode.setDynamic(true);
        entityManageNode.setState(this.determineEntityManagementState());
        this.root.addChild(entityManageNode);
        CommandWheelNode dismissNode = new CommandWheelNode("wheel.hundred_years_war.dismiss", node -> this.executeDismiss());
        this.root.addChild(dismissNode);
        CommandWheelNode selectSquadRootNode = new CommandWheelNode("wheel.hundred_years_war.select_squad");
        this.root.addChild(selectSquadRootNode);
        selectSquadRootNode.setAction(node -> this.navigateTo((CommandWheelNode)node));
        CommandWheelNode backFromSelectSquad = new CommandWheelNode("wheel.hundred_years_war.back", node -> this.navigateTo(this.root));
        selectSquadRootNode.addChild(backFromSelectSquad);
        int i = 1;
        while (i <= 7) {
            int squadNum = i++;
            CommandWheelNode numNode = new CommandWheelNode("wheel.hundred_years_war.squad_number." + squadNum, node -> {
                ClientPacketHandler.sendSelectSquadPacket(squadNum);
                CommandWheelHandler.getInstance().recordCommandTime();
                CommandWheelHandler.getInstance().closeCommandWheel();
            });
            selectSquadRootNode.addChild(numNode);
        }
        CommandWheelNode createSquadRootNode = new CommandWheelNode("wheel.hundred_years_war.create_squad");
        this.root.addChild(createSquadRootNode);
        createSquadRootNode.setAction(node -> this.navigateTo((CommandWheelNode)node));
        CommandWheelNode backFromCreateSquad = new CommandWheelNode("wheel.hundred_years_war.back", node -> this.navigateTo(this.root));
        createSquadRootNode.addChild(backFromCreateSquad);
        int i2 = 1;
        while (i2 <= 7) {
            int squadNum = i2++;
            CommandWheelNode numNode = new CommandWheelNode("wheel.hundred_years_war.squad_number." + squadNum, node -> {
                ClientPacketHandler.sendSquadCreatePacket(squadNum);
                CommandWheelHandler.getInstance().recordCommandTime();
                CommandWheelHandler.getInstance().closeCommandWheel();
            });
            createSquadRootNode.addChild(numNode);
        }
        CommandWheelNode recruitmentConfigNode = new CommandWheelNode("wheel.hundred_years_war.recruitment_config", node -> this.navigateTo((CommandWheelNode)node));
        recruitmentConfigNode.setDynamic(true);
        String currentDisplayKey = this.getCurrentRecruitmentDisplayKey();
        recruitmentConfigNode.setState(currentDisplayKey);
        this.root.addChild(recruitmentConfigNode);
        this.buildRecruitmentCategoryMenu(recruitmentConfigNode);
    }

    public CommandWheelNode getRoot() {
        return this.root;
    }

    public CommandWheelNode getCurrentNode() {
        return this.currentNode;
    }

    public void navigateTo(CommandWheelNode node) {
        this.currentNode = node;
    }

    public boolean navigateBack() {
        if (this.currentNode.hasParent()) {
            this.currentNode = this.currentNode.getParent();
            return true;
        }
        return false;
    }

    public List<CommandWheelNode> getCurrentPageNodes(int pageIndex, int pageSize) {
        List<CommandWheelNode> allNodes = this.currentNode.getChildren();
        int startIndex = pageIndex * pageSize;
        int endIndex = Math.min(startIndex + pageSize, allNodes.size());
        if (startIndex >= allNodes.size()) {
            return new ArrayList<CommandWheelNode>();
        }
        return allNodes.subList(startIndex, endIndex);
    }

    public int getTotalPages(int pageSize) {
        int totalNodes = this.currentNode.getChildren().size();
        return (int)Math.ceil((double)totalNodes / (double)pageSize);
    }

    private void executeMove() {
        CommandWheelHandler handler = CommandWheelHandler.getInstance();
        HitResult hitResult = handler.getLastHitResult();
        if (hitResult != null && hitResult.m_6662_() == HitResult.Type.ENTITY) {
            hitResult = TraceHelper.blockRayTrace(200.0);
        }
        if (hitResult != null) {
            boolean queueMode = false;
            boolean formationMode = handler.isFormationMode();
            ClientPacketHandler.sendMoveCommandPacket(hitResult, queueMode, formationMode);
            handler.recordCommandTime();
        }
        handler.closeCommandWheel();
    }

    private void executeAttack() {
        CommandWheelHandler handler = CommandWheelHandler.getInstance();
        HitResult hitResult = handler.getLastHitResult();
        if (hitResult != null) {
            boolean queueMode = false;
            if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
                ClientPacketHandler.sendTargetUpdatePacket(hitResult, queueMode);
            } else {
                boolean formationMode = handler.isFormationMode();
                ClientPacketHandler.sendMoveAttackCommandPacket(hitResult, queueMode, formationMode);
            }
            handler.recordCommandTime();
        }
        handler.closeCommandWheel();
    }

    private void executeHold() {
        CommandWheelHandler handler = CommandWheelHandler.getInstance();
        ClientPacketHandler.sendCommandPacket("hold", false);
        handler.recordCommandTime();
        handler.closeCommandWheel();
    }

    private void executeFollow() {
        CommandWheelHandler handler = CommandWheelHandler.getInstance();
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null) {
            EntityHitResult selfHitResult = new EntityHitResult((Entity)minecraft.f_91074_, minecraft.f_91074_.m_20182_());
            boolean queueMode = false;
            ClientPacketHandler.sendFollowTargetPacket(selfHitResult, queueMode);
            handler.setFollowing(true);
            handler.recordCommandTime();
        }
        handler.closeCommandWheel();
    }

    private void toggleFormationMode(CommandWheelNode node) {
        CommandWheelHandler handler = CommandWheelHandler.getInstance();
        handler.toggleFormationMode();
        node.setState(handler.isFormationMode() ? "on" : "off");
    }

    private void executeFormationChange(String formationType) {
        CommandWheelHandler.getInstance().setCurrentFormation(formationType);
        this.formationNode.setState(formationType);
        this.navigateTo(this.root);
    }

    private String determineEntityManagementState() {
        Entity entity;
        HitResult hitResult = CommandWheelHandler.getInstance().performWheelRayTrace();
        if (hitResult != null && hitResult.m_6662_() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)hitResult).m_82443_()) instanceof BaseCombatEntity && SelectionHandler.getInstance().hasControl(entity)) {
            List<Entity> selectedEntities = SelectionHandler.getInstance().getSelectedEntities();
            if (selectedEntities.contains(entity)) {
                return "remove_entity";
            }
            return "add_entity";
        }
        return "add_nearby";
    }

    private void executeEntityManagement() {
        HitResult hitResult;
        CommandWheelHandler handler = CommandWheelHandler.getInstance();
        String state = this.determineEntityManagementState();
        if ("add_nearby".equals(state)) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null) {
                this.addNearbyEntities(mc.f_91074_.m_20183_(), 20);
            }
        } else if ("add_entity".equals(state)) {
            SelectionHandler selectionHandler;
            ArrayList<Entity> selectedEntities;
            Entity entity;
            HitResult hitResult2 = handler.performWheelRayTrace();
            if (hitResult2 != null && hitResult2.m_6662_() == HitResult.Type.ENTITY && (entity = ((EntityHitResult)hitResult2).m_82443_()) instanceof BaseCombatEntity && SelectionHandler.getInstance().hasControl(entity) && !this.isEntityOnBaseCombatEntityVehicle(entity) && !(selectedEntities = new ArrayList<Entity>((selectionHandler = SelectionHandler.getInstance()).getSelectedEntities())).contains(entity)) {
                selectedEntities.add(entity);
                selectionHandler.setSelectedEntities(selectedEntities);
                List<UUID> selectedEntityIds = selectedEntities.stream().map(Entity::m_20148_).collect(Collectors.toList());
                ClientPacketHandler.sendSelectionPacket(selectedEntityIds);
            }
        } else if ("remove_entity".equals(state) && (hitResult = handler.performWheelRayTrace()) != null && hitResult.m_6662_() == HitResult.Type.ENTITY) {
            Entity entity = ((EntityHitResult)hitResult).m_82443_();
            SelectionHandler selectionHandler = SelectionHandler.getInstance();
            ArrayList<Entity> selectedEntities = new ArrayList<Entity>(selectionHandler.getSelectedEntities());
            if (selectedEntities.contains(entity)) {
                selectedEntities.remove(entity);
                selectionHandler.setSelectedEntities(selectedEntities);
                List<UUID> selectedEntityIds = selectedEntities.stream().map(Entity::m_20148_).collect(Collectors.toList());
                ClientPacketHandler.sendSelectionPacket(selectedEntityIds);
            }
        }
        handler.recordCommandTime();
        handler.closeCommandWheel();
    }

    private boolean isEntityOnBaseCombatEntityVehicle(Entity entity) {
        Entity vehicle = entity.m_20202_();
        return vehicle instanceof BaseCombatEntity;
    }

    private void addNearbyEntities(BlockPos centerPos, int radius) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91073_ == null || minecraft.f_91074_ == null) {
            return;
        }
        Vec3 center = new Vec3((double)centerPos.m_123341_(), (double)centerPos.m_123342_(), (double)centerPos.m_123343_());
        AABB box = new AABB(center.f_82479_ - (double)radius, center.f_82480_ - (double)radius, center.f_82481_ - (double)radius, center.f_82479_ + (double)radius, center.f_82480_ + (double)radius, center.f_82481_ + (double)radius);
        List entitiesInRange = minecraft.f_91073_.m_6443_(Entity.class, box, entity -> entity instanceof BaseCombatEntity && SelectionHandler.getInstance().hasControl((Entity)entity) && !this.isEntityOnBaseCombatEntityVehicle((Entity)entity));
        if (!entitiesInRange.isEmpty()) {
            SelectionHandler selectionHandler = SelectionHandler.getInstance();
            ArrayList<Entity> currentSelection = new ArrayList<Entity>(selectionHandler.getSelectedEntities());
            for (Entity entity2 : entitiesInRange) {
                if (currentSelection.contains(entity2)) continue;
                currentSelection.add(entity2);
            }
            selectionHandler.setSelectedEntities(currentSelection);
            List<UUID> selectedEntityIds = currentSelection.stream().map(Entity::m_20148_).collect(Collectors.toList());
            ClientPacketHandler.sendSelectionPacket(selectedEntityIds);
        }
    }

    private void executeDismiss() {
        CommandWheelHandler handler = CommandWheelHandler.getInstance();
        SelectionHandler selectionHandler = SelectionHandler.getInstance();
        int entityCount = selectionHandler.getSelectedEntities().size();
        selectionHandler.setSelectedEntities(new ArrayList<Entity>());
        ClientPacketHandler.sendSelectionPacket(new ArrayList<UUID>());
        handler.recordCommandTime();
        handler.closeCommandWheel();
    }

    public void updateDynamicNodes() {
        for (CommandWheelNode node : this.currentNode.getChildren()) {
            if (!node.isDynamic()) continue;
            this.updateDynamicNodeState(node);
        }
    }

    private void updateDynamicNodeState(CommandWheelNode node) {
        String titleKey = node.getTitleKey();
        if ("wheel.hundred_years_war.formation_mode".equals(titleKey)) {
            node.setState(CommandWheelHandler.getInstance().isFormationMode() ? "on" : "off");
        } else if ("wheel.hundred_years_war.formation".equals(titleKey)) {
            String currentFormation = CommandWheelHandler.getInstance().getCurrentFormation();
            if (currentFormation != null && !currentFormation.isEmpty()) {
                node.setState(currentFormation);
            }
        } else if ("wheel.hundred_years_war.entity_manage".equals(titleKey)) {
            String state = this.determineEntityManagementState();
            node.setState(state);
        } else if ("wheel.hundred_years_war.attack".equals(titleKey)) {
            String state = this.determineAttackState();
            node.setState(state);
        } else if ("wheel.hundred_years_war.recruitment_config".equals(titleKey)) {
            String currentDisplayKey = this.getCurrentRecruitmentDisplayKey();
            node.setState(currentDisplayKey);
        }
    }

    private String determineAttackState() {
        HitResult hitResult = CommandWheelHandler.getInstance().getLastHitResult();
        if (hitResult != null && hitResult.m_6662_() == HitResult.Type.ENTITY) {
            return "attack_entity";
        }
        return "attack";
    }

    public CommandWheelNode getAttackNode() {
        return this.attackNode;
    }

    public void updateNodesOnTick() {
        if (this.attackNode != null && this.attackNode.isDynamic()) {
            String state = this.determineAttackState();
            this.attackNode.setState(state);
        }
    }

    private String getCurrentRecruitmentDisplayKey() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null) {
            try {
                PlayerRecruitmentData.RecruitmentSelection selection = PlayerRecruitmentData.getPlayerSelection((Player)minecraft.f_91074_);
                return selection.getDisplayTranslationKey();
            }
            catch (Exception e) {
                return "militia_i";
            }
        }
        return "militia_i";
    }

    private void buildRecruitmentCategoryMenu(CommandWheelNode recruitmentNode) {
        CommandWheelNode backFromRecruitment = new CommandWheelNode("wheel.hundred_years_war.back", node -> this.navigateTo(this.root));
        recruitmentNode.addChild(backFromRecruitment);
        CommandWheelNode meleeInfantryNode = new CommandWheelNode("recruitment.hundred_years_war.category.melee_infantry", node -> {
            ClientPacketHandler.requestRecruitmentData("melee_infantry");
            this.navigateTo((CommandWheelNode)node);
        });
        recruitmentNode.addChild(meleeInfantryNode);
        this.buildEmptyRecruitmentSubMenu(meleeInfantryNode, "melee_infantry", recruitmentNode);
        CommandWheelNode meleeCavalryNode = new CommandWheelNode("recruitment.hundred_years_war.category.melee_cavalry", node -> {
            ClientPacketHandler.requestRecruitmentData("melee_cavalry");
            this.navigateTo((CommandWheelNode)node);
        });
        recruitmentNode.addChild(meleeCavalryNode);
        this.buildEmptyRecruitmentSubMenu(meleeCavalryNode, "melee_cavalry", recruitmentNode);
        CommandWheelNode rangedInfantryNode = new CommandWheelNode("recruitment.hundred_years_war.category.ranged_infantry", node -> {
            ClientPacketHandler.requestRecruitmentData("ranged_infantry");
            this.navigateTo((CommandWheelNode)node);
        });
        recruitmentNode.addChild(rangedInfantryNode);
        this.buildEmptyRecruitmentSubMenu(rangedInfantryNode, "ranged_infantry", recruitmentNode);
        CommandWheelNode rangedCavalryNode = new CommandWheelNode("recruitment.hundred_years_war.category.ranged_cavalry", node -> {
            ClientPacketHandler.requestRecruitmentData("ranged_cavalry");
            this.navigateTo((CommandWheelNode)node);
        });
        recruitmentNode.addChild(rangedCavalryNode);
        this.buildEmptyRecruitmentSubMenu(rangedCavalryNode, "ranged_cavalry", recruitmentNode);
        CommandWheelNode siegeNode = new CommandWheelNode("recruitment.hundred_years_war.category.siege", node -> {
            ClientPacketHandler.requestRecruitmentData("siege");
            this.navigateTo((CommandWheelNode)node);
        });
        recruitmentNode.addChild(siegeNode);
        this.buildEmptyRecruitmentSubMenu(siegeNode, "siege", recruitmentNode);
        CommandWheelNode specialNode = new CommandWheelNode("recruitment.hundred_years_war.category.special", node -> {
            ClientPacketHandler.requestRecruitmentData("special");
            this.navigateTo((CommandWheelNode)node);
        });
        recruitmentNode.addChild(specialNode);
        this.buildEmptyRecruitmentSubMenu(specialNode, "special", recruitmentNode);
        CommandWheelNode presetsNode = new CommandWheelNode("recruitment.hundred_years_war.category.presets", node -> {
            ClientPacketHandler.requestRecruitmentData("presets");
            this.navigateTo((CommandWheelNode)node);
        });
        recruitmentNode.addChild(presetsNode);
        this.buildEmptyRecruitmentSubMenu(presetsNode, "presets", recruitmentNode);
    }

    private void buildEmptyRecruitmentSubMenu(CommandWheelNode categoryNode, String categoryId, CommandWheelNode parentNode) {
        CommandWheelNode backToCategory = new CommandWheelNode("wheel.hundred_years_war.back", node -> this.navigateTo(parentNode));
        categoryNode.addChild(backToCategory);
        CommandWheelNode loadingNode = new CommandWheelNode("wheel.hundred_years_war.loading", node -> ClientPacketHandler.requestRecruitmentData(categoryId));
        categoryNode.addChild(loadingNode);
    }

    public void refreshRecruitmentMenu(String categoryId) {
        CommandWheelNode categoryNode = this.findRecruitmentCategoryNode(categoryId);
        if (categoryNode != null) {
            this.updateRecruitmentCategoryMenu(categoryNode, categoryId);
        }
    }

    private CommandWheelNode findRecruitmentCategoryNode(String categoryId) {
        CommandWheelNode recruitmentNode = this.getRecruitmentConfigNode();
        if (recruitmentNode != null) {
            String translationKey = "recruitment.hundred_years_war.category." + categoryId;
            for (CommandWheelNode child : recruitmentNode.getChildren()) {
                if (!translationKey.equals(child.getTitleKey())) continue;
                return child;
            }
        }
        return null;
    }

    public CommandWheelNode getRecruitmentConfigNode() {
        for (CommandWheelNode child : this.root.getChildren()) {
            if (!"wheel.hundred_years_war.recruitment_config".equals(child.getTitleKey())) continue;
            return child;
        }
        return null;
    }

    public void updateRecruitmentCategoryMenu(CommandWheelNode categoryNode, String categoryId) {
        categoryNode.getChildren().clear();
        CommandWheelNode backToRecruitment = new CommandWheelNode("wheel.hundred_years_war.back", node -> this.navigateTo(categoryNode.getParent()));
        categoryNode.addChild(backToRecruitment);
        Map<String, RecruitmentDataResponsePacket> allData = ClientPacketHandler.getAllRecruitmentData();
        RecruitmentDataResponsePacket data = allData.get(categoryId);
        if (data != null) {
            System.out.println("\u6536\u5230\u62db\u52df\u7c7b\u522b\u6570\u636e\uff0c\u7c7b\u522b\uff1a" + categoryId + ", \u5175\u79cd\u6570\u91cf\uff1a" + data.getUnitTypes().size());
            if (!data.getUnitTypes().isEmpty()) {
                for (RecruitmentConfig.UnitTypeConfig unitType : data.getUnitTypes()) {
                    CommandWheelNode unitTypeNode = new CommandWheelNode(unitType.getTranslationKey(), node -> this.navigateTo((CommandWheelNode)node));
                    categoryNode.addChild(unitTypeNode);
                    this.buildUnitTypeMenu(unitTypeNode, categoryId, unitType);
                    System.out.println("\u6784\u5efa\u5175\u79cd\u83dc\u5355: " + unitType.getTranslationKey() + ", \u7b49\u7ea7\u6570\u91cf: " + unitType.getLevels().size());
                }
            } else {
                CommandWheelNode noUnitsNode = new CommandWheelNode("ui.hundred_years_war.no_units_available", node -> {});
                categoryNode.addChild(noUnitsNode);
                System.out.println("\u7c7b\u522b " + categoryId + " \u6ca1\u6709\u53ef\u7528\u5175\u79cd");
            }
        } else {
            CommandWheelNode loadingNode = new CommandWheelNode("wheel.hundred_years_war.loading", node -> ClientPacketHandler.requestRecruitmentData(categoryId));
            categoryNode.addChild(loadingNode);
            System.out.println("\u7c7b\u522b " + categoryId + " \u6570\u636e\u672a\u5230\u8fbe\uff0c\u663e\u793a\u52a0\u8f7d\u4e2d");
        }
    }

    private void buildUnitTypeMenu(CommandWheelNode unitTypeNode, String categoryId, RecruitmentConfig.UnitTypeConfig unitType) {
        CommandWheelNode backToCategory = new CommandWheelNode("wheel.hundred_years_war.back", node -> this.navigateTo(unitTypeNode.getParent()));
        unitTypeNode.addChild(backToCategory);
        for (RecruitmentConfig.ArmyLevelConfig level : unitType.getLevels()) {
            CommandWheelNode levelNode = new CommandWheelNode(level.getTranslationKey(), node -> {
                this.selectRecruitmentConfig(categoryId, unitType.getId(), level.getLevel());
                this.navigateTo(this.root);
            });
            levelNode.setDynamic(true);
            levelNode.setState(String.valueOf(level.getExpCost()));
            unitTypeNode.addChild(levelNode);
        }
    }

    private void selectRecruitmentConfig(String categoryId, String unitTypeId, int level) {
        ClientPacketHandler.sendRecruitmentConfigUpdate(categoryId, unitTypeId, level);
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null) {
            PlayerRecruitmentData.RecruitmentSelection selection = new PlayerRecruitmentData.RecruitmentSelection();
            selection.setCategoryId(categoryId);
            selection.setUnitTypeId(unitTypeId);
            selection.setLevel(level);
            PlayerRecruitmentData.setPlayerSelection((Player)minecraft.f_91074_, selection);
            this.updateRecruitmentConfigNodeDisplay();
        }
        CommandWheelHandler.getInstance().closeCommandWheel();
    }

    private void updateRecruitmentConfigNodeDisplay() {
        for (CommandWheelNode child : this.root.getChildren()) {
            if (!"wheel.hundred_years_war.recruitment_config".equals(child.getTitleKey())) continue;
            String currentDisplayKey = this.getCurrentRecruitmentDisplayKey();
            child.setState(currentDisplayKey);
            break;
        }
    }
}

