/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.util;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.KeyboardInput;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.client.freecam.config.ClientModConfig;
import ydmsama.hundred_years_war.client.freecam.mixins.ClientLevelAccessor;
import ydmsama.hundred_years_war.client.freecam.selection.SelectionHandler;
import ydmsama.hundred_years_war.client.freecam.util.FreecamPosition;
import ydmsama.hundred_years_war.client.renderer.blockentity.BaseStructureCoreRenderer;
import ydmsama.hundred_years_war.main.blocks.BaseStructureCoreBlockEntity;
import ydmsama.hundred_years_war.main.entity.entities.puppets.IPuppet;
import ydmsama.hundred_years_war.main.mixins.EntityAccessor;

public class FreeCamera
extends LocalPlayer {
    private static final ClientPacketListener NETWORK_HANDLER = new ClientPacketListener(Freecam.MC, Freecam.MC.f_91080_, Objects.requireNonNull(Freecam.MC.m_91403_()).m_104910_(), Freecam.MC.m_91089_(), new GameProfile(UUID.randomUUID(), "FreeCamera"), Freecam.MC.m_261007_().m_285995_(false, null, null)){

        public void m_104955_(Packet<?> packet) {
        }
    };

    public FreeCamera(int id) {
        super(Freecam.MC, Freecam.MC.f_91073_, NETWORK_HANDLER, Freecam.MC.f_91074_.m_108630_(), Freecam.MC.f_91074_.m_108631_(), false, false);
        this.m_20234_(id);
        this.m_20124_(Pose.SWIMMING);
        this.m_150110_().f_35935_ = true;
        this.f_108618_ = new KeyboardInput(Freecam.MC.f_91066_);
    }

    public void m_20359_(Entity entity) {
        this.applyPosition(new FreecamPosition(entity));
    }

    public void applyPosition(FreecamPosition position) {
        this.m_7678_(position.x, position.y, position.z, position.yaw, position.pitch);
        this.f_108586_ = this.m_146909_();
        this.f_108585_ = this.m_146908_();
        this.f_108588_ = this.f_108586_;
        this.f_108587_ = this.f_108585_;
    }

    public void applyPerspective(ClientModConfig.Perspective perspective, boolean checkCollision) {
        FreecamPosition position = new FreecamPosition((Entity)this);
        switch (perspective) {
            case INSIDE: {
                break;
            }
            case FIRST_PERSON: {
                this.moveForwardUntilCollision(position, 0.4, checkCollision);
                break;
            }
            case THIRD_PERSON_MIRROR: {
                position.mirrorRotation();
            }
            case THIRD_PERSON: {
                this.moveUpwardUntilCollision(position, 0.0, checkCollision);
                this.moveForwardUntilCollision(position, -4.0, checkCollision);
            }
        }
    }

    private boolean moveForwardUntilCollision(FreecamPosition position, double distance, boolean checkCollision) {
        if (!checkCollision) {
            position.moveForward(distance);
            this.applyPosition(position);
            return true;
        }
        return this.moveForwardUntilCollision(position, distance);
    }

    private boolean moveForwardUntilCollision(FreecamPosition position, double maxDistance) {
        boolean negative = maxDistance < 0.0;
        maxDistance = negative ? -1.0 * maxDistance : maxDistance;
        double increment = 0.1;
        for (double distance = 0.0; distance < maxDistance; distance += increment) {
            FreecamPosition oldPosition = new FreecamPosition((Entity)this);
            position.moveForward(negative ? -1.0 * increment : increment);
            this.applyPosition(position);
            if (this.wouldNotSuffocateAtTargetPose(this.m_20089_())) continue;
            this.applyPosition(oldPosition);
            return distance > 0.0;
        }
        return true;
    }

    protected boolean wouldNotSuffocateAtTargetPose(Pose pose) {
        AABB boundingBox = this.m_6972_(pose).m_20393_(this.m_20182_());
        return ((EntityAccessor)((Object)this)).getLevel().m_45756_((Entity)this, boundingBox);
    }

    public boolean moveUpwardUntilCollision(FreecamPosition position, double distance, boolean checkCollision) {
        if (!checkCollision) {
            position.moveUpward(distance);
            this.applyPosition(position);
            return true;
        }
        return this.moveUpwardUntilCollision(position, distance);
    }

    private boolean moveUpwardUntilCollision(FreecamPosition position, double maxDistance) {
        boolean negative = maxDistance < 0.0;
        maxDistance = negative ? -1.0 * maxDistance : maxDistance;
        double increment = 0.1;
        for (double distance = 0.0; distance < maxDistance; distance += increment) {
            FreecamPosition oldPosition = new FreecamPosition((Entity)this);
            position.moveUpward(negative ? -1.0 * increment : increment);
            this.applyPosition(position);
            if (this.wouldNotSuffocateAtTargetPose(this.m_20089_())) continue;
            this.applyPosition(oldPosition);
            return distance > 0.0;
        }
        return true;
    }

    public void spawn() {
        if (this.f_108545_ != null) {
            ClientLevelAccessor accessor = (ClientLevelAccessor)this.f_108545_;
            accessor.callAddEntity(this.m_19879_(), (Entity)this);
        }
    }

    public void despawn() {
        if (this.f_108545_ != null && this.f_108545_.m_6815_(this.m_19879_()) != null) {
            this.f_108545_.m_171642_(this.m_19879_(), Entity.RemovalReason.DISCARDED);
        }
    }

    protected void m_7840_(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
    }

    public float m_21324_(float tickDelta) {
        return Freecam.MC.f_91074_.m_21324_(tickDelta);
    }

    public int m_21212_() {
        return Freecam.MC.f_91074_.m_21212_();
    }

    public boolean m_6117_() {
        return Freecam.MC.f_91074_.m_6117_();
    }

    public boolean m_6147_() {
        return false;
    }

    public boolean m_20069_() {
        return false;
    }

    public MobEffectInstance m_21124_(MobEffect effect) {
        return Freecam.MC.f_91074_.m_21124_(effect);
    }

    public PushReaction m_7752_() {
        return ClientModConfig.INSTANCE.collision.ignoreAll ? PushReaction.IGNORE : PushReaction.NORMAL;
    }

    public boolean m_7337_(Entity other) {
        return false;
    }

    public void m_20124_(Pose pose) {
        super.m_20124_(Pose.SWIMMING);
    }

    public boolean m_108635_() {
        return false;
    }

    protected boolean m_7602_() {
        this.f_36076_ = this.m_204029_(FluidTags.f_13131_);
        return this.f_36076_;
    }

    protected void m_5841_() {
    }

    public void m_8107_() {
        if (ClientModConfig.INSTANCE.movement.flightMode.equals((Object)ClientModConfig.FlightMode.DEFAULT)) {
            this.m_150110_().m_35943_(0.0f);
            Freecam.doEdgeMotion();
        } else {
            this.m_150110_().m_35943_((float)ClientModConfig.INSTANCE.movement.verticalSpeed / 10.0f);
        }
        super.m_8107_();
        this.m_150110_().f_35935_ = true;
        this.m_6853_(false);
    }

    @NotNull
    public HitResult camPick(double d, float f, boolean bl, boolean ent) {
        return this.performRaycast(d, f, bl, ent, PuppetSelectionStrategy.NORMAL);
    }

    @NotNull
    public HitResult camPickPrioritizePuppet(double d, float f) {
        return this.performRaycast(d, f, false, true, PuppetSelectionStrategy.PRIORITIZE);
    }

    @NotNull
    public HitResult camPickIgnorePuppet(double d, float f) {
        return this.performRaycast(d, f, false, true, PuppetSelectionStrategy.IGNORE);
    }

    @NotNull
    private HitResult performRaycast(double distance, float partialTicks, boolean includeFluid, boolean includeEntities, PuppetSelectionStrategy puppetStrategy) {
        HitResult blockHitResult;
        Vec3 eyePos = this.m_20299_(partialTicks);
        Vec3 direction = SelectionHandler.getInstance().screenToWorld(Freecam.MC.f_91067_.m_91589_(), Freecam.MC.f_91067_.m_91594_(), Freecam.MC);
        Vec3 endPos = eyePos.m_82520_(direction.f_82479_ * distance, direction.f_82480_ * distance, direction.f_82481_ * distance);
        if (includeEntities) {
            HitResult entityHitResult = this.performEntityRaycast(eyePos, endPos, puppetStrategy);
            if (entityHitResult != null) {
                return entityHitResult;
            }
            HitResult blockEntityHitResult = this.performBlockEntityRaycast(eyePos, endPos, direction);
            if (blockEntityHitResult != null) {
                return blockEntityHitResult;
            }
        }
        if ((blockHitResult = this.performBlockRaycast(eyePos, endPos, includeFluid)).m_6662_() != HitResult.Type.MISS) {
            return blockHitResult;
        }
        return BlockHitResult.m_82426_((Vec3)endPos, (Direction)Direction.m_122366_((double)direction.f_82479_, (double)direction.f_82480_, (double)direction.f_82481_), (BlockPos)new BlockPos((int)endPos.f_82479_, (int)endPos.f_82480_, (int)endPos.f_82481_));
    }

    private HitResult performEntityRaycast(Vec3 eyePos, Vec3 endPos, PuppetSelectionStrategy puppetStrategy) {
        EntityHitResults results = new EntityHitResults();
        List entities = this.m_9236_().m_45933_((Entity)this, new AABB(eyePos, endPos).m_82400_(1.0));
        for (Entity entity : entities) {
            AABB entityBoundingBox;
            Optional hitPoint;
            if (!this.shouldConsiderEntity(entity) || !(hitPoint = (entityBoundingBox = entity.m_20191_()).m_82371_(eyePos, endPos)).isPresent()) continue;
            double distance = eyePos.m_82554_((Vec3)hitPoint.get());
            if (entity instanceof IPuppet) {
                IPuppet puppet = (IPuppet)entity;
                this.handlePuppetEntity(puppet, (Vec3)hitPoint.get(), distance, puppetStrategy, results, eyePos, endPos);
                continue;
            }
            if (!(distance < results.nearestOtherEntityDistance)) continue;
            results.nearestOtherEntityDistance = distance;
            results.nearestOtherEntityHitResult = new EntityHitResult(entity, (Vec3)hitPoint.get());
        }
        return this.selectEntityHitResult(puppetStrategy, results.nearestPuppetHitResult, results.nearestOtherEntityHitResult);
    }

    private boolean shouldConsiderEntity(Entity entity) {
        if (entity == this) {
            return false;
        }
        if (entity == Freecam.MC.f_91074_ && ClientModConfig.INSTANCE.visual.showPlayer) {
            double minDistance;
            double thresholdSquared;
            Vec3 playerPos;
            Vec3 cameraPos = Freecam.MC.f_91063_.m_109153_().m_90583_();
            double distanceSquared = cameraPos.m_82557_(playerPos = Freecam.MC.f_91074_.m_146892_());
            return distanceSquared > (thresholdSquared = (minDistance = ClientModConfig.INSTANCE.visual.playerRenderMinDistance) * minDistance);
        }
        return true;
    }

    private void handlePuppetEntity(IPuppet puppet, Vec3 hitPoint, double distance, PuppetSelectionStrategy strategy, EntityHitResults results, Vec3 eyePos, Vec3 endPos) {
        switch (strategy) {
            case PRIORITIZE: {
                if (!(distance < results.nearestPuppetDistance)) break;
                results.nearestPuppetDistance = distance;
                results.nearestPuppetHitResult = new EntityHitResult((Entity)puppet, hitPoint);
                break;
            }
            case IGNORE: {
                double playerDistance;
                AABB playerBoundingBox;
                Optional playerHitPoint;
                Entity firstPassenger = puppet.m_146895_();
                if (!(firstPassenger instanceof Player) || !(playerHitPoint = (playerBoundingBox = firstPassenger.m_20191_()).m_82371_(eyePos, endPos)).isPresent() || !((playerDistance = eyePos.m_82554_((Vec3)playerHitPoint.get())) < results.nearestOtherEntityDistance)) break;
                results.nearestOtherEntityDistance = playerDistance;
                results.nearestOtherEntityHitResult = new EntityHitResult(firstPassenger, (Vec3)playerHitPoint.get());
                break;
            }
            default: {
                if (!(distance < results.nearestOtherEntityDistance)) break;
                results.nearestOtherEntityDistance = distance;
                results.nearestOtherEntityHitResult = new EntityHitResult((Entity)puppet, hitPoint);
            }
        }
    }

    private HitResult selectEntityHitResult(PuppetSelectionStrategy strategy, HitResult puppetResult, HitResult otherResult) {
        switch (strategy) {
            case PRIORITIZE: {
                return puppetResult != null ? puppetResult : otherResult;
            }
        }
        return otherResult;
    }

    private HitResult performBlockEntityRaycast(Vec3 eyePos, Vec3 endPos, Vec3 direction) {
        BlockHitResult nearestBlockEntityHitResult = null;
        double nearestBlockEntityDistance = Double.MAX_VALUE;
        for (BaseStructureCoreBlockEntity blockEntity : BaseStructureCoreRenderer.getRenderedEntities()) {
            double distance;
            Optional optional;
            AABB boundingBox = blockEntity.getAbsoluteBoundingBox();
            if (boundingBox == null || !(optional = boundingBox.m_82371_(eyePos, endPos)).isPresent() || !((distance = eyePos.m_82554_((Vec3)optional.get())) < nearestBlockEntityDistance)) continue;
            nearestBlockEntityDistance = distance;
            nearestBlockEntityHitResult = new BlockHitResult((Vec3)optional.get(), Direction.m_122366_((double)direction.f_82479_, (double)direction.f_82480_, (double)direction.f_82481_), blockEntity.m_58899_(), false);
        }
        return nearestBlockEntityHitResult;
    }

    private HitResult performBlockRaycast(Vec3 eyePos, Vec3 endPos, boolean includeFluid) {
        ClipContext clipContext = new ClipContext(eyePos, endPos, ClipContext.Block.COLLIDER, includeFluid ? ClipContext.Fluid.ANY : ClipContext.Fluid.NONE, (Entity)this);
        return this.m_9236_().m_45547_(clipContext);
    }

    public float m_21223_() {
        return Freecam.MC.f_91074_ != null ? Freecam.MC.f_91074_.m_21223_() : super.m_21223_();
    }

    public int m_20146_() {
        return Freecam.MC.f_91074_ != null ? Freecam.MC.f_91074_.m_20146_() : super.m_20146_();
    }

    public int m_21230_() {
        return Freecam.MC.f_91074_ != null ? Freecam.MC.f_91074_.m_21230_() : super.m_21230_();
    }

    public FoodData m_36324_() {
        return Freecam.MC.f_91074_ != null ? Freecam.MC.f_91074_.m_36324_() : super.m_36324_();
    }

    public float m_6103_() {
        return Freecam.MC.f_91074_ != null ? Freecam.MC.f_91074_.m_6103_() : super.m_6103_();
    }

    public void syncToCamera(Camera cam) {
        Vec3 pos = cam.m_90583_();
        this.m_7678_(pos.f_82479_, pos.f_82480_ - 0.4, pos.f_82481_, cam.m_90590_(), cam.m_90589_());
        this.f_108586_ = this.m_146909_();
        this.f_108585_ = this.m_146908_();
        this.f_108588_ = this.f_108586_;
        this.f_108587_ = this.f_108585_;
    }

    public static enum PuppetSelectionStrategy {
        NORMAL,
        PRIORITIZE,
        IGNORE;

    }

    private static class EntityHitResults {
        HitResult nearestPuppetHitResult = null;
        HitResult nearestOtherEntityHitResult = null;
        double nearestPuppetDistance = Double.MAX_VALUE;
        double nearestOtherEntityDistance = Double.MAX_VALUE;

        private EntityHitResults() {
        }
    }
}

