/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.models;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import ydmsama.hundred_years_war.client.models.animation.HorseIdleAnimation;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;

public class HywHorseModel
extends HierarchicalModel<BaseCombatEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("hundred_years_war", "horsemodel"), "main");
    private final boolean scaleHead = true;
    private final float babyYHeadOffset = 16.2f;
    private final float babyZHeadOffset = 1.36f;
    private final float babyHeadScale = 2.7272f;
    private final float babyBodyScale = 2.0f;
    private final float bodyYOffset = 20.0f;
    private final ModelPart root;
    protected final ModelPart body;
    protected final ModelPart headParts;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightHindBabyLeg;
    private final ModelPart leftHindBabyLeg;
    private final ModelPart rightFrontBabyLeg;
    private final ModelPart leftFrontBabyLeg;
    private final ModelPart tail;
    private final ModelPart[] saddleParts;
    private final ModelPart[] ridingParts;

    public HywHorseModel(ModelPart root) {
        this.root = root;
        this.body = root.m_171324_("body");
        this.headParts = root.m_171324_("head_parts");
        this.rightHindLeg = root.m_171324_("right_hind_leg");
        this.leftHindLeg = root.m_171324_("left_hind_leg");
        this.rightFrontLeg = root.m_171324_("right_front_leg");
        this.leftFrontLeg = root.m_171324_("left_front_leg");
        this.rightHindBabyLeg = root.m_171324_("right_hind_baby_leg");
        this.leftHindBabyLeg = root.m_171324_("left_hind_baby_leg");
        this.rightFrontBabyLeg = root.m_171324_("right_front_baby_leg");
        this.leftFrontBabyLeg = root.m_171324_("left_front_baby_leg");
        this.tail = this.body.m_171324_("tail");
        ModelPart modelPart2 = this.body.m_171324_("saddle");
        ModelPart modelPart3 = this.headParts.m_171324_("left_saddle_mouth");
        ModelPart modelPart4 = this.headParts.m_171324_("right_saddle_mouth");
        ModelPart modelPart5 = this.headParts.m_171324_("left_saddle_line");
        ModelPart modelPart6 = this.headParts.m_171324_("right_saddle_line");
        ModelPart modelPart7 = this.headParts.m_171324_("head_saddle");
        ModelPart modelPart8 = this.headParts.m_171324_("mouth_saddle_wrap");
        this.saddleParts = new ModelPart[]{modelPart2, modelPart3, modelPart4, modelPart7, modelPart8};
        this.ridingParts = new ModelPart[]{modelPart5, modelPart6};
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        PartDefinition body = partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-5.0f, -8.0f, -17.0f, 10.0f, 10.0f, 22.0f, new CubeDeformation(0.05f)), PartPose.m_171419_((float)0.0f, (float)11.0f, (float)5.0f));
        PartDefinition headParts = partDefinition.m_171599_("head_parts", CubeListBuilder.m_171558_().m_171514_(0, 35).m_171481_(-2.05f, -6.0f, -2.0f, 4.0f, 12.0f, 7.0f), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-12.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        PartDefinition head = headParts.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171488_(-3.0f, -11.0f, -2.0f, 6.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.f_171404_);
        headParts.m_171599_("mane", CubeListBuilder.m_171558_().m_171514_(56, 36).m_171488_(-1.0f, -11.0f, 5.01f, 2.0f, 16.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.f_171404_);
        headParts.m_171599_("upper_mouth", CubeListBuilder.m_171558_().m_171514_(0, 25).m_171488_(-2.0f, -11.0f, -7.0f, 4.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.f_171404_);
        partDefinition.m_171599_("left_hind_leg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171480_().m_171488_(-3.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)14.0f, (float)7.0f));
        partDefinition.m_171599_("right_hind_leg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171488_(-1.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)14.0f, (float)7.0f));
        partDefinition.m_171599_("left_front_leg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171480_().m_171488_(-3.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)14.0f, (float)-12.0f));
        partDefinition.m_171599_("right_front_leg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171488_(-1.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)14.0f, (float)-12.0f));
        CubeDeformation cubeDeformation2 = new CubeDeformation(0.0f).m_171471_(0.0f, 5.5f, 0.0f);
        partDefinition.m_171599_("left_hind_baby_leg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171480_().m_171488_(-3.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, cubeDeformation2), PartPose.m_171419_((float)4.0f, (float)14.0f, (float)7.0f));
        partDefinition.m_171599_("right_hind_baby_leg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171488_(-1.0f, -1.01f, -1.0f, 4.0f, 11.0f, 4.0f, cubeDeformation2), PartPose.m_171419_((float)-4.0f, (float)14.0f, (float)7.0f));
        partDefinition.m_171599_("left_front_baby_leg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171480_().m_171488_(-3.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, cubeDeformation2), PartPose.m_171419_((float)4.0f, (float)14.0f, (float)-12.0f));
        partDefinition.m_171599_("right_front_baby_leg", CubeListBuilder.m_171558_().m_171514_(48, 21).m_171488_(-1.0f, -1.01f, -1.9f, 4.0f, 11.0f, 4.0f, cubeDeformation2), PartPose.m_171419_((float)-4.0f, (float)14.0f, (float)-12.0f));
        body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(42, 36).m_171488_(-1.5f, 0.0f, 0.0f, 3.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-5.0f, (float)2.0f, (float)0.5235988f, (float)0.0f, (float)0.0f));
        body.m_171599_("saddle", CubeListBuilder.m_171558_().m_171514_(26, 0).m_171488_(-5.0f, -8.0f, -9.0f, 10.0f, 9.0f, 9.0f, new CubeDeformation(0.5f)), PartPose.f_171404_);
        headParts.m_171599_("left_saddle_mouth", CubeListBuilder.m_171558_().m_171514_(29, 5).m_171488_(2.0f, -9.0f, -6.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.f_171404_);
        headParts.m_171599_("right_saddle_mouth", CubeListBuilder.m_171558_().m_171514_(29, 5).m_171488_(-3.0f, -9.0f, -6.0f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.f_171404_);
        headParts.m_171599_("left_saddle_line", CubeListBuilder.m_171558_().m_171514_(32, 2).m_171481_(3.1f, -6.0f, -8.0f, 0.0f, 3.0f, 16.0f), PartPose.m_171430_((float)-0.5235988f, (float)0.0f, (float)0.0f));
        headParts.m_171599_("right_saddle_line", CubeListBuilder.m_171558_().m_171514_(32, 2).m_171481_(-3.1f, -6.0f, -8.0f, 0.0f, 3.0f, 16.0f), PartPose.m_171430_((float)-0.5235988f, (float)0.0f, (float)0.0f));
        headParts.m_171599_("head_saddle", CubeListBuilder.m_171558_().m_171514_(1, 1).m_171488_(-3.0f, -11.0f, -1.9f, 6.0f, 5.0f, 6.0f, new CubeDeformation(0.22f)), PartPose.f_171404_);
        headParts.m_171599_("mouth_saddle_wrap", CubeListBuilder.m_171558_().m_171514_(19, 0).m_171488_(-2.0f, -11.0f, -4.0f, 4.0f, 5.0f, 2.0f, new CubeDeformation(0.2f)), PartPose.f_171404_);
        head.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(19, 16).m_171488_(0.55f, -13.0f, 4.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(-0.001f)), PartPose.f_171404_);
        head.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(19, 16).m_171488_(-2.55f, -13.0f, 4.0f, 2.0f, 3.0f, 1.0f, new CubeDeformation(-0.001f)), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            poseStack.m_85836_();
            Objects.requireNonNull(this);
            float scale = 1.5f / this.babyHeadScale;
            poseStack.m_85841_(scale, scale, scale);
            poseStack.m_252880_(0.0f, this.babyYHeadOffset / 16.0f, this.babyZHeadOffset / 16.0f);
            this.headParts().forEach(modelPart -> modelPart.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha));
            poseStack.m_85849_();
            poseStack.m_85836_();
            scale = 1.0f / this.babyBodyScale;
            poseStack.m_85841_(scale, scale, scale);
            poseStack.m_252880_(0.0f, this.bodyYOffset / 16.0f, 0.0f);
            this.bodyParts().forEach(modelPart -> modelPart.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha));
            poseStack.m_85849_();
        } else {
            this.headParts().forEach(modelPart -> modelPart.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha));
            this.bodyParts().forEach(modelPart -> modelPart.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha));
        }
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.headParts);
    }

    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg, (Object)this.rightHindBabyLeg, (Object)this.leftHindBabyLeg, (Object)this.rightFrontBabyLeg, (Object)this.leftFrontBabyLeg);
    }

    public void setupAnim(BaseCombatEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        boolean bl = true;
        boolean bl2 = entity.m_20160_();
        for (ModelPart modelPart : this.saddleParts) {
            modelPart.f_104207_ = bl;
        }
        for (ModelPart modelPart : this.ridingParts) {
            modelPart.f_104207_ = bl2 && bl;
        }
        float i = Mth.m_14189_((float)0.0f, (float)entity.f_20884_, (float)entity.f_20883_);
        float j = Mth.m_14189_((float)0.0f, (float)entity.f_20886_, (float)entity.f_20885_);
        float k = Mth.m_14179_((float)0.0f, (float)entity.f_19860_, (float)entity.m_146909_());
        float l = j - i;
        float m = k * ((float)Math.PI / 180);
        if (l > 20.0f) {
            l = 20.0f;
        }
        if (l < -20.0f) {
            l = -20.0f;
        }
        if (limbSwingAmount > 0.2f) {
            m += Mth.m_14089_((float)(limbSwing * 0.8f)) * 0.15f * limbSwingAmount;
        }
        float n = 0.0f;
        float o = 0.0f;
        float p = 1.0f - o;
        float q = 0.0f;
        boolean bl3 = false;
        float r = (float)entity.f_19797_ + ageInTicks;
        this.headParts.f_104201_ = 4.0f;
        this.headParts.f_104202_ = -12.0f;
        this.body.f_104203_ = 0.0f;
        this.headParts.f_104203_ = 0.5235988f + m;
        this.headParts.f_104204_ = l * ((float)Math.PI / 180);
        float s = entity.m_20069_() ? 0.2f : 1.0f;
        float t = Mth.m_14089_((float)(s * limbSwing * 0.6662f + (float)Math.PI));
        float u = t * 0.8f * limbSwingAmount;
        float v = (1.0f - Math.max(o, n)) * (0.5235988f + m + q * Mth.m_14031_((float)r) * 0.05f);
        this.headParts.f_104203_ = o * (0.2617994f + m) + n * (2.1816616f + Mth.m_14031_((float)r) * 0.05f) + v;
        this.headParts.f_104204_ = o * l * ((float)Math.PI / 180) + (1.0f - Math.max(o, n)) * this.headParts.f_104204_;
        this.headParts.f_104201_ = o * -4.0f + n * 11.0f + (1.0f - Math.max(o, n)) * this.headParts.f_104201_;
        this.headParts.f_104202_ = o * -4.0f + n * -12.0f + (1.0f - Math.max(o, n)) * this.headParts.f_104202_;
        this.body.f_104203_ = o * -0.7853982f + p * this.body.f_104203_;
        float w = 0.2617994f * o;
        float x = Mth.m_14089_((float)(r * 0.6f + (float)Math.PI));
        this.leftFrontLeg.f_104201_ = 2.0f * o + 14.0f * p;
        this.leftFrontLeg.f_104202_ = -6.0f * o - 10.0f * p;
        this.rightFrontLeg.f_104201_ = this.leftFrontLeg.f_104201_;
        this.rightFrontLeg.f_104202_ = this.leftFrontLeg.f_104202_;
        float legSwingMultiplier = 1.2f;
        float frontLegSwing = t * 0.8f * limbSwingAmount * legSwingMultiplier * p;
        float hindLegSwing = t * 0.8f * limbSwingAmount * legSwingMultiplier * p;
        this.leftFrontLeg.f_104203_ = w + frontLegSwing;
        this.rightFrontLeg.f_104203_ = w - frontLegSwing;
        this.leftHindLeg.f_104203_ = w - hindLegSwing;
        this.rightHindLeg.f_104203_ = w + hindLegSwing;
        this.tail.f_104203_ = 0.5235988f + limbSwingAmount * 0.75f;
        this.tail.f_104201_ = -5.0f + limbSwingAmount;
        this.tail.f_104202_ = 2.0f + limbSwingAmount * 2.0f;
        this.tail.f_104204_ = bl3 ? Mth.m_14089_((float)(r * 0.7f)) : 0.0f;
        this.rightHindBabyLeg.f_104201_ = this.rightHindLeg.f_104201_;
        this.rightHindBabyLeg.f_104202_ = this.rightHindLeg.f_104202_;
        this.rightHindBabyLeg.f_104203_ = this.rightHindLeg.f_104203_;
        this.leftHindBabyLeg.f_104201_ = this.leftHindLeg.f_104201_;
        this.leftHindBabyLeg.f_104202_ = this.leftHindLeg.f_104202_;
        this.leftHindBabyLeg.f_104203_ = this.leftHindLeg.f_104203_;
        this.rightFrontBabyLeg.f_104201_ = this.rightFrontLeg.f_104201_;
        this.rightFrontBabyLeg.f_104202_ = this.rightFrontLeg.f_104202_;
        this.rightFrontBabyLeg.f_104203_ = this.rightFrontLeg.f_104203_;
        this.leftFrontBabyLeg.f_104201_ = this.leftFrontLeg.f_104201_;
        this.leftFrontBabyLeg.f_104202_ = this.leftFrontLeg.f_104202_;
        this.leftFrontBabyLeg.f_104203_ = this.leftFrontLeg.f_104203_;
        boolean bl4 = false;
        this.rightHindLeg.f_104207_ = !bl4;
        this.leftHindLeg.f_104207_ = !bl4;
        this.rightFrontLeg.f_104207_ = !bl4;
        this.leftFrontLeg.f_104207_ = !bl4;
        this.rightHindBabyLeg.f_104207_ = bl4;
        this.leftHindBabyLeg.f_104207_ = bl4;
        this.rightFrontBabyLeg.f_104207_ = bl4;
        this.leftFrontBabyLeg.f_104207_ = bl4;
        this.m_233381_(entity.idleAnimationState, HorseIdleAnimation.idle, ageInTicks);
    }

    public ModelPart getBody() {
        return this.body;
    }

    public ModelPart getHeadParts() {
        return this.headParts;
    }

    public ModelPart getLeftFrontLeg() {
        return this.leftFrontLeg;
    }

    public ModelPart getLeftHindLeg() {
        return this.leftHindLeg;
    }

    public ModelPart getRightFrontLeg() {
        return this.rightFrontLeg;
    }

    public ModelPart getRightHindLeg() {
        return this.rightHindLeg;
    }

    public ModelPart getLeftFrontBabyLeg() {
        return this.leftFrontBabyLeg;
    }

    public ModelPart getLeftHindBabyLeg() {
        return this.leftHindBabyLeg;
    }

    public ModelPart getRightFrontBabyLeg() {
        return this.rightFrontBabyLeg;
    }

    public ModelPart getRightHindBabyLeg() {
        return this.rightHindBabyLeg;
    }

    public void copyPropertiesTo(HywHorseModel other) {
        super.m_102624_((EntityModel)other);
        other.body.m_104315_(this.body);
        other.headParts.m_104315_(this.headParts);
        other.rightHindLeg.m_104315_(this.rightHindLeg);
        other.leftHindLeg.m_104315_(this.leftHindLeg);
        other.rightFrontLeg.m_104315_(this.rightFrontLeg);
        other.leftFrontLeg.m_104315_(this.leftFrontLeg);
        other.rightHindBabyLeg.m_104315_(this.rightHindBabyLeg);
        other.leftHindBabyLeg.m_104315_(this.leftHindBabyLeg);
        other.rightFrontBabyLeg.m_104315_(this.rightFrontBabyLeg);
        other.leftFrontBabyLeg.m_104315_(this.leftFrontBabyLeg);
        other.tail.m_104315_(this.tail);
    }
}

