/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.network;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.client.freecam.config.keys.HotKeyManager;
import ydmsama.hundred_years_war.client.freecam.selection.SelectionHandler;
import ydmsama.hundred_years_war.client.freecam.ui.RelationUI;
import ydmsama.hundred_years_war.client.freecam.ui.TeamApplicationsUI;
import ydmsama.hundred_years_war.client.freecam.ui.TeamCreateUI;
import ydmsama.hundred_years_war.client.freecam.ui.TeamInfoUI;
import ydmsama.hundred_years_war.client.freecam.ui.TeamJoinUI;
import ydmsama.hundred_years_war.client.freecam.ui.TeamMembersUI;
import ydmsama.hundred_years_war.client.freecam.ui.TeamRelationUI;
import ydmsama.hundred_years_war.client.freecam.ui.TeamUI;
import ydmsama.hundred_years_war.client.freecam.ui.manual.ManualUI;
import ydmsama.hundred_years_war.client.freecam.ui.wheel.CommandWheelHandler;
import ydmsama.hundred_years_war.client.freecam.ui.wheel.CommandWheelTree;
import ydmsama.hundred_years_war.client.freecam.ui.wheel.CommandWheelUI;
import ydmsama.hundred_years_war.client.structure.BuildModeRenderer;
import ydmsama.hundred_years_war.client.utils.ClientRelationHelper;
import ydmsama.hundred_years_war.main.entity.entities.siege.PositionAttackable;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.BombardPositionPacket;
import ydmsama.hundred_years_war.main.network.packets.BuildCommandPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandStaffAddEntityPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandStaffAttackPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandStaffFollowPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandStaffMovePacket;
import ydmsama.hundred_years_war.main.network.packets.FollowTargetPacket;
import ydmsama.hundred_years_war.main.network.packets.MoveAttackCommandPacket;
import ydmsama.hundred_years_war.main.network.packets.MoveCommandPacket;
import ydmsama.hundred_years_war.main.network.packets.PatrolPointPacket;
import ydmsama.hundred_years_war.main.network.packets.PatrolPointsRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.RecruitmentConfigUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.RecruitmentDataRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.RecruitmentDataResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.RelationRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.RelationResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.RelationSyncPacket;
import ydmsama.hundred_years_war.main.network.packets.RelationUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.SelectionPacket;
import ydmsama.hundred_years_war.main.network.packets.SiegeModeTogglePacket;
import ydmsama.hundred_years_war.main.network.packets.SquadCreatePacket;
import ydmsama.hundred_years_war.main.network.packets.SquadSelectPacket;
import ydmsama.hundred_years_war.main.network.packets.StructureSizePacket;
import ydmsama.hundred_years_war.main.network.packets.TargetUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamApplicationsRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamApplicationsResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamCreateRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamCreateResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamInfoRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamInfoResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamJoinRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamLeaveRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamListRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamListResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamManageRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamMembersRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamMembersResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamRelationRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamRelationResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamRelationUpdatePacket;

public class ClientPacketHandler {
    private static RelationResponsePacket latestRelationData;
    private static TeamInfoResponsePacket latestTeamData;
    private static TeamListResponsePacket latestTeamListData;
    private static TeamApplicationsResponsePacket latestTeamApplicationsData;
    private static TeamMembersResponsePacket latestTeamMembersData;
    private static TeamRelationResponsePacket latestTeamRelationData;
    private static Map<String, RecruitmentDataResponsePacket> latestRecruitmentData;

    public static RelationResponsePacket getLatestRelationData() {
        return latestRelationData;
    }

    public static TeamInfoResponsePacket getLatestTeamData() {
        return latestTeamData;
    }

    public static TeamListResponsePacket getLatestTeamListData() {
        return latestTeamListData;
    }

    public static TeamApplicationsResponsePacket getLatestTeamApplicationsData() {
        return latestTeamApplicationsData;
    }

    public static TeamMembersResponsePacket getLatestTeamMembersData() {
        return latestTeamMembersData;
    }

    public static TeamRelationResponsePacket getLatestTeamRelationData() {
        return latestTeamRelationData;
    }

    public static RecruitmentDataResponsePacket getLatestRecruitmentData(String categoryId) {
        return latestRecruitmentData.get(categoryId);
    }

    public static Map<String, RecruitmentDataResponsePacket> getAllRecruitmentData() {
        return latestRecruitmentData;
    }

    public static void onStructureSize(StructureSizePacket packet) {
        Vec3i size = packet.getSize();
        Minecraft.m_91087_().execute(() -> BuildModeRenderer.updateStructureSize(size));
    }

    public static void onRelationResponse(RelationResponsePacket packet) {
        latestRelationData = packet;
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> {
            Screen patt3950$temp = mc.f_91080_;
            if (patt3950$temp instanceof RelationUI) {
                RelationUI ui = (RelationUI)patt3950$temp;
                ui.onRelationDataUpdate(packet);
            }
        });
    }

    public static void onTeamInfoResponse(TeamInfoResponsePacket packet) {
        latestTeamData = packet;
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> {
            Screen patt4303$temp = mc.f_91080_;
            if (patt4303$temp instanceof TeamUI) {
                TeamUI ui = (TeamUI)patt4303$temp;
                ui.onTeamDataUpdate(packet);
            }
        });
    }

    public static void onTeamCreateResponse(TeamCreateResponsePacket packet) {
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> {
            Screen patt4621$temp = mc.f_91080_;
            if (patt4621$temp instanceof TeamCreateUI) {
                TeamCreateUI ui = (TeamCreateUI)patt4621$temp;
                ui.onTeamCreateResponse(packet);
            }
        });
    }

    public static void onRelationSync(RelationSyncPacket packet) {
        Minecraft.m_91087_().execute(() -> {
            ClientRelationHelper.getInstance().updateEnemyRelations(packet.getEnemyUUIDs());
            ClientRelationHelper.getInstance().updateSharedControlRelations(packet.getSharedControlUUIDs());
        });
    }

    public static void onTeamListResponse(TeamListResponsePacket packet) {
        latestTeamListData = packet;
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> {
            Screen patt5357$temp = mc.f_91080_;
            if (patt5357$temp instanceof TeamJoinUI) {
                TeamJoinUI ui = (TeamJoinUI)patt5357$temp;
                ui.onTeamListUpdate(packet);
            }
        });
    }

    public static void onTeamApplicationsResponse(TeamApplicationsResponsePacket packet) {
        latestTeamApplicationsData = packet;
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> {
            Screen patt5742$temp = mc.f_91080_;
            if (patt5742$temp instanceof TeamApplicationsUI) {
                TeamApplicationsUI ui = (TeamApplicationsUI)patt5742$temp;
                ui.onApplicationsDataUpdate(packet);
            }
        });
    }

    public static void onTeamMembersResponse(TeamMembersResponsePacket packet) {
        latestTeamMembersData = packet;
        System.out.println("\u6536\u5230\u56e2\u961f\u6210\u5458\u54cd\u5e94\u5305\uff1a" + packet.getTeamName() + ", \u6210\u5458\u6570\u91cf: " + packet.getMembers().size());
        packet.getMembers().forEach(m -> System.out.println("\u6210\u5458: " + m.getPlayerName() + ", \u89d2\u8272: " + m.getRole()));
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> {
            Screen patt6379$temp = mc.f_91080_;
            if (patt6379$temp instanceof TeamInfoUI) {
                TeamInfoUI ui = (TeamInfoUI)patt6379$temp;
                ui.onMembersDataUpdate(packet);
            } else {
                Screen patt6488$temp = mc.f_91080_;
                if (patt6488$temp instanceof TeamMembersUI) {
                    TeamMembersUI ui = (TeamMembersUI)patt6488$temp;
                    ui.updateMembersFromResponse(packet);
                }
            }
        });
    }

    public static void onTeamRelationResponse(TeamRelationResponsePacket packet) {
        latestTeamRelationData = packet;
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> {
            Screen patt6869$temp = mc.f_91080_;
            if (patt6869$temp instanceof TeamRelationUI) {
                TeamRelationUI ui = (TeamRelationUI)patt6869$temp;
                ui.onTeamRelationDataUpdate(packet);
            }
        });
    }

    public static void onRecruitmentDataResponse(RecruitmentDataResponsePacket packet) {
        latestRecruitmentData.put(packet.getCategoryId(), packet);
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> {
            System.out.println("\u6536\u5230\u62db\u52df\u6570\u636e: " + packet.getCategoryId() + ", \u5175\u79cd\u6570\u91cf: " + packet.getUnitTypes().size());
            Screen patt7558$temp = mc.f_91080_;
            if (patt7558$temp instanceof CommandWheelUI) {
                CommandWheelUI wheelUI = (CommandWheelUI)patt7558$temp;
                CommandWheelTree tree = wheelUI.getCommandWheelTree();
                tree.refreshRecruitmentMenu(packet.getCategoryId());
                wheelUI.refreshUI();
            }
        });
    }

    public static void onOpenManual() {
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> mc.m_91152_((Screen)new ManualUI()));
    }

    public static void sendSelectionPacket(List<UUID> selectedEntityIds) {
        SelectionPacket packet = new SelectionPacket(selectedEntityIds);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendCommandPacket(String command, boolean queueMode) {
        SelectionHandler.clearAllRendering();
        CommandPacket packet = new CommandPacket(command, queueMode);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendMoveCommandPacket(HitResult result, boolean queueMode, boolean formationMode) {
        SelectionHandler.clearAllRendering();
        List<Entity> selectedEntities = SelectionHandler.getInstance().getSelectedEntities();
        BlockHitResult bhr = (BlockHitResult)result;
        if (!formationMode) {
            for (Entity e : selectedEntities) {
                SelectionHandler.getInstance().updateTargetPos(e, bhr.m_82425_());
            }
        } else {
            for (Entity e : selectedEntities) {
                SelectionHandler.getInstance().updateFormTargetPos(e, bhr.m_82425_());
            }
        }
        if (selectedEntities.size() == 1) {
            formationMode = false;
        }
        String formationType = formationMode ? CommandWheelHandler.getInstance().getCurrentFormation() : "loose";
        MoveCommandPacket packet = new MoveCommandPacket(bhr, queueMode, formationMode, formationType);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendTargetUpdatePacket(HitResult result, boolean queueMode) {
        SelectionHandler.clearAllRendering();
        if (result instanceof EntityHitResult) {
            EntityHitResult ehr = (EntityHitResult)result;
            Entity target = ehr.m_82443_();
            UUID targetUUID = target.m_20148_();
            List<Entity> selected = SelectionHandler.getInstance().getSelectedEntities();
            for (Entity e : selected) {
                SelectionHandler.getInstance().updateTarget(e, target);
            }
            TargetUpdatePacket packet = new TargetUpdatePacket(targetUUID, queueMode);
            ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
        }
    }

    public static void sendMoveAttackCommandPacket(HitResult result, boolean queueMode, boolean formationMode) {
        SelectionHandler.clearAllRendering();
        List<Entity> selected = SelectionHandler.getInstance().getSelectedEntities();
        BlockHitResult bhr = (BlockHitResult)result;
        if (!formationMode) {
            for (Entity e : selected) {
                SelectionHandler.getInstance().updateAttackTargetPos(e, bhr.m_82425_());
            }
        } else {
            for (Entity e : selected) {
                SelectionHandler.getInstance().updateFormAttackTargetPos(e, bhr.m_82425_());
            }
        }
        String formationType = formationMode ? CommandWheelHandler.getInstance().getCurrentFormation() : "loose";
        MoveAttackCommandPacket packet = new MoveAttackCommandPacket(bhr, queueMode, formationMode, formationType);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendBuildCommandPacket(BlockPos buildPos, String templateName, Rotation rotation) {
        if (buildPos == null) {
            return;
        }
        BuildCommandPacket packet = new BuildCommandPacket(buildPos, templateName, rotation);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendPatrolPointPacket(BlockHitResult hitResult, boolean queueMode) {
        SelectionHandler.clearAllRendering();
        List<Entity> selected = SelectionHandler.getInstance().getSelectedEntities();
        for (Entity e : selected) {
            SelectionHandler.getInstance().updatePatrolPoint(e, hitResult.m_82425_());
        }
        PatrolPointPacket packet = new PatrolPointPacket(hitResult, queueMode);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendFollowTargetPacket(EntityHitResult hitResult, boolean queueMode) {
        SelectionHandler.clearAllRendering();
        List<Entity> selected = SelectionHandler.getInstance().getSelectedEntities();
        for (Entity e : selected) {
            SelectionHandler.getInstance().updateFollowTarget(e, hitResult.m_82443_());
        }
        FollowTargetPacket packet = new FollowTargetPacket(hitResult.m_82443_().m_20148_(), queueMode);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendPatrolPointsRequestPacket(Entity selectedEntity) {
        PatrolPointsRequestPacket packet = new PatrolPointsRequestPacket(selectedEntity.m_20148_());
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendSquadCreatePacket(int numberPressed) {
        SquadCreatePacket packet = new SquadCreatePacket(numberPressed);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendSelectSquadPacket(int numberPressed) {
        SquadSelectPacket packet = new SquadSelectPacket(numberPressed);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendCommandStaffAddEntityPacket(UUID staffUUID, UUID entityUUID, boolean isAdding) {
        CommandStaffAddEntityPacket packet = new CommandStaffAddEntityPacket(staffUUID, entityUUID, isAdding);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendCommandStaffMovePacket(UUID staffUUID, BlockPos targetPos, int priority) {
        ClientPacketHandler.sendCommandStaffMovePacket(staffUUID, targetPos, priority, false);
    }

    public static void sendCommandStaffMovePacket(UUID staffUUID, BlockPos targetPos, int priority, boolean formationMode) {
        String formationType = formationMode ? CommandWheelHandler.getInstance().getCurrentFormation() : "loose";
        CommandStaffMovePacket packet = new CommandStaffMovePacket(staffUUID, targetPos, priority, formationMode, formationType);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendCommandStaffFollowPacket(UUID staffUUID) {
        CommandStaffFollowPacket packet = new CommandStaffFollowPacket(staffUUID);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendCommandStaffAttackPacket(UUID staffUUID, UUID targetEntityUUID) {
        CommandStaffAttackPacket packet = new CommandStaffAttackPacket(staffUUID, targetEntityUUID);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void requestRelationData() {
        ServerPacketHandler.INSTANCE.sendToServer((Object)new RelationRequestPacket());
    }

    public static void requestTeamData() {
        ServerPacketHandler.INSTANCE.sendToServer((Object)new TeamInfoRequestPacket());
    }

    public static void sendRelationUpdate(RelationUpdatePacket updatePacket) {
        ServerPacketHandler.INSTANCE.sendToServer((Object)updatePacket);
    }

    public static void requestTeamList() {
        ServerPacketHandler.INSTANCE.sendToServer((Object)new TeamListRequestPacket());
    }

    public static void requestTeamApplications() {
        ServerPacketHandler.INSTANCE.sendToServer((Object)new TeamApplicationsRequestPacket());
    }

    public static void requestTeamMembers(UUID teamUUID) {
        ServerPacketHandler.INSTANCE.sendToServer((Object)new TeamMembersRequestPacket(teamUUID));
    }

    public static void requestTeamRelationData(UUID teamUUID) {
        ServerPacketHandler.INSTANCE.sendToServer((Object)new TeamRelationRequestPacket(teamUUID));
    }

    public static void sendTeamRelationUpdate(TeamRelationUpdatePacket updatePacket) {
        ServerPacketHandler.INSTANCE.sendToServer((Object)updatePacket);
    }

    public static void requestCreateTeam(String name) {
        ServerPacketHandler.INSTANCE.sendToServer((Object)new TeamCreateRequestPacket(name));
    }

    public static void requestJoinTeam(UUID uuid) {
        ServerPacketHandler.INSTANCE.sendToServer((Object)new TeamJoinRequestPacket(uuid));
    }

    public static void requestLeaveTeam(UUID uuid) {
        ServerPacketHandler.INSTANCE.sendToServer((Object)new TeamLeaveRequestPacket(uuid));
    }

    public static void requestTeamManage(UUID teamUUID, String action, UUID targetUUID) {
        ServerPacketHandler.INSTANCE.sendToServer((Object)new TeamManageRequestPacket(teamUUID, action, targetUUID));
    }

    public static void sendTeamMemberRolesUpdate(UUID teamUUID, Map<UUID, TeamMembersResponsePacket.Member.Role> changes) {
        changes.forEach((uuid, role) -> {
            String action = switch (role) {
                default -> throw new IncompatibleClassChangeError();
                case TeamMembersResponsePacket.Member.Role.OWNER -> "set_owner";
                case TeamMembersResponsePacket.Member.Role.ADMIN -> "promote";
                case TeamMembersResponsePacket.Member.Role.MEMBER -> "demote";
            };
            ClientPacketHandler.requestTeamManage(teamUUID, action, uuid);
        });
    }

    public static void sendSiegeModeTogglePacket(boolean newState) {
        ServerPacketHandler.INSTANCE.sendToServer((Object)new SiegeModeTogglePacket(newState));
    }

    public static void sendBombardPositionPacket(Vec3 pos) {
        boolean queue = HotKeyManager.getQueueMode();
        if (!queue) {
            SelectionHandler.clearAllRendering();
        }
        if (pos != null) {
            List<Entity> sel = SelectionHandler.getInstance().getSelectedEntities();
            for (Entity e : sel) {
                if (!(e instanceof PositionAttackable)) continue;
                BlockPos bp = new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_);
                SelectionHandler.getInstance().updateBombardTarget(e, bp);
            }
        } else {
            SelectionHandler.getInstance().clearSelectedBombardTargets();
        }
        ServerPacketHandler.INSTANCE.sendToServer((Object)new BombardPositionPacket(pos, pos == null, queue));
    }

    public static void requestRecruitmentData(String categoryId) {
        RecruitmentDataRequestPacket packet = categoryId != null ? new RecruitmentDataRequestPacket(categoryId) : new RecruitmentDataRequestPacket();
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendRecruitmentConfigUpdate(String categoryId, String unitTypeId, int level) {
        RecruitmentConfigUpdatePacket packet = new RecruitmentConfigUpdatePacket(categoryId, unitTypeId, level);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static Entity getEntityByUUID(UUID uuid) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            for (Entity e : level.m_104735_()) {
                if (!e.m_20148_().equals(uuid)) continue;
                return e;
            }
        }
        return null;
    }

    static {
        latestRecruitmentData = new HashMap<String, RecruitmentDataResponsePacket>();
    }
}

