/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.renderer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.Variant;
import ydmsama.hundred_years_war.client.models.HywHorseModel;
import ydmsama.hundred_years_war.client.renderer.layers.FactionTintLayer;
import ydmsama.hundred_years_war.client.renderer.layers.HywHorseArmorLayer;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;

public class HywHorseRenderer
extends MobRenderer<BaseCombatEntity, HywHorseModel> {
    private static final Map<Variant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.m_137469_((Object)Maps.newEnumMap(Variant.class), enumMap -> {
        enumMap.put(Variant.WHITE, new ResourceLocation("textures/entity/horse/horse_white.png"));
        enumMap.put(Variant.CREAMY, new ResourceLocation("textures/entity/horse/horse_creamy.png"));
        enumMap.put(Variant.CHESTNUT, new ResourceLocation("textures/entity/horse/horse_chestnut.png"));
        enumMap.put(Variant.BROWN, new ResourceLocation("textures/entity/horse/horse_brown.png"));
        enumMap.put(Variant.BLACK, new ResourceLocation("textures/entity/horse/horse_black.png"));
        enumMap.put(Variant.GRAY, new ResourceLocation("textures/entity/horse/horse_gray.png"));
        enumMap.put(Variant.DARK_BROWN, new ResourceLocation("textures/entity/horse/horse_darkbrown.png"));
    });
    private final float scale = 1.1f;

    public HywHorseRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new HywHorseModel(context.m_174023_(HywHorseModel.LAYER_LOCATION)), 0.75f);
        this.m_115326_(new HywHorseArmorLayer((RenderLayerParent<BaseCombatEntity, HywHorseModel>)this, context.m_174027_()));
        this.m_115326_(new FactionTintLayer(this));
    }

    protected void scale(BaseCombatEntity entity, PoseStack poseStack, float partialTicks) {
        poseStack.m_85841_(this.scale, this.scale, this.scale);
        super.m_7546_((LivingEntity)entity, poseStack, partialTicks);
    }

    public ResourceLocation getTextureLocation(BaseCombatEntity entity) {
        int skinIndex = entity.getCurrentSkinIndex();
        Variant[] variants = Variant.values();
        Variant variant = variants[skinIndex % variants.length];
        return LOCATION_BY_VARIANT.get(variant);
    }
}

