/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.renderer.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import ydmsama.hundred_years_war.client.models.SpearManModel;
import ydmsama.hundred_years_war.main.entity.entities.SpearManEntity;

public class VerticalItemInHandLayer
extends ItemInHandLayer<SpearManEntity, SpearManModel<SpearManEntity>> {
    private final ItemInHandRenderer itemInHandRenderer;

    public VerticalItemInHandLayer(RenderLayerParent<SpearManEntity, SpearManModel<SpearManEntity>> renderLayerParent, ItemInHandRenderer itemInHandRenderer) {
        super(renderLayerParent, itemInHandRenderer);
        this.itemInHandRenderer = itemInHandRenderer;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, SpearManEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack mainHandStack;
        boolean mainHandRight = entity.m_5737_() == HumanoidArm.RIGHT;
        ItemStack offhandStack = mainHandRight ? entity.m_21206_() : entity.m_21205_();
        ItemStack itemStack = mainHandStack = mainHandRight ? entity.m_21205_() : entity.m_21206_();
        if (!mainHandStack.m_41619_() || !offhandStack.m_41619_()) {
            poseStack.m_85836_();
            this.renderItemInHand(entity, mainHandStack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, poseStack, bufferSource, packedLight);
            this.renderItemInHand(entity, offhandStack, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, HumanoidArm.LEFT, poseStack, bufferSource, packedLight);
            poseStack.m_85849_();
        }
    }

    private void renderItemInHand(SpearManEntity entity, ItemStack stack, ItemDisplayContext displayContext, HumanoidArm arm, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (!stack.m_41619_()) {
            boolean isPikeOrLance;
            poseStack.m_85836_();
            ((SpearManModel)this.m_117386_()).m_6002_(arm, poseStack);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            boolean leftHand = arm == HumanoidArm.LEFT;
            poseStack.m_252880_((float)(leftHand ? -1 : 1) / 16.0f, 0.125f, -0.625f);
            boolean bl = isPikeOrLance = stack.m_41720_().toString().contains("pike") || stack.m_41720_().toString().contains("lance");
            if (entity.shouldHoldWeaponVertically() && arm == HumanoidArm.RIGHT && isPikeOrLance) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(45.0f));
                poseStack.m_252880_(0.0f, 0.5f, 0.0f);
            }
            this.itemInHandRenderer.m_269530_((LivingEntity)entity, stack, displayContext, leftHand, poseStack, bufferSource, packedLight);
            poseStack.m_85849_();
        }
    }
}

