/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.renderer.projectile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ArrowRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.client.models.projectile.SpringaldBulletModel;
import ydmsama.hundred_years_war.main.entity.entities.projectile.SpringaldBulletEntity;

public class SpringaldBulletRenderer
extends ArrowRenderer<SpringaldBulletEntity> {
    private final SpringaldBulletModel<SpringaldBulletEntity> model;

    public SpringaldBulletRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new SpringaldBulletModel(context.m_174023_(SpringaldBulletModel.LAYER_LOCATION));
    }

    public void render(SpringaldBulletEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        Vec3 velocity = entity.m_20184_();
        if (velocity.m_82556_() > 1.0E-7) {
            double horizontalDistance = Math.sqrt(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_);
            float yaw = (float)(Math.atan2(velocity.f_82479_, velocity.f_82481_) * 180.0 / Math.PI);
            float pitch = (float)(-Math.atan2(velocity.f_82480_, horizontalDistance) * 180.0 / Math.PI);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(yaw));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(pitch));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        }
        poseStack.m_85841_(1.0f, 1.0f, 1.0f);
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity)));
        this.model.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    @NotNull
    public ResourceLocation getTextureLocation(SpringaldBulletEntity entity) {
        return new ResourceLocation("hundred_years_war", "textures/entity/springald_bullet.png");
    }
}

