/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.renderer.puppets;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.client.models.PuppetModel;
import ydmsama.hundred_years_war.main.entity.entities.puppets.MeleePuppetEntity;

public class MeleePuppetRenderer
extends HumanoidMobRenderer<MeleePuppetEntity, PuppetModel<MeleePuppetEntity>> {
    private final PuppetModel<MeleePuppetEntity> slimModel;
    private final HumanoidArmorLayer<MeleePuppetEntity, PuppetModel<MeleePuppetEntity>, HumanoidArmorModel<MeleePuppetEntity>> slimArmorLayer;
    private final HumanoidArmorLayer<MeleePuppetEntity, PuppetModel<MeleePuppetEntity>, HumanoidArmorModel<MeleePuppetEntity>> regularArmorLayer;

    public MeleePuppetRenderer(EntityRendererProvider.Context context) {
        super(context, new PuppetModel(context.m_174023_(ModelLayers.f_171162_), false), 0.5f);
        this.slimModel = new PuppetModel(context.m_174023_(ModelLayers.f_171166_), true);
        this.regularArmorLayer = new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new HumanoidArmorModel(context.m_174023_(ModelLayers.f_171164_)), (HumanoidModel)new HumanoidArmorModel(context.m_174023_(ModelLayers.f_171165_)), context.m_266367_());
        this.slimArmorLayer = new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)new HumanoidArmorModel(context.m_174023_(ModelLayers.f_171167_)), (HumanoidModel)new HumanoidArmorModel(context.m_174023_(ModelLayers.f_171168_)), context.m_266367_());
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.m_234598_()));
        this.m_115326_((RenderLayer)new ArrowLayer(context, (LivingEntityRenderer)this));
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.m_174027_(), context.m_234598_()));
    }

    private boolean isSlim(MeleePuppetEntity entity) {
        Player player;
        UUID ownerUUID = entity.getOwnerUUID();
        if (ownerUUID != null && (player = entity.m_9236_().m_46003_(ownerUUID)) instanceof AbstractClientPlayer) {
            AbstractClientPlayer clientPlayer = (AbstractClientPlayer)player;
            return "slim".equals(clientPlayer.m_108564_());
        }
        return false;
    }

    public void render(MeleePuppetEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        HumanoidArmorLayer<MeleePuppetEntity, PuppetModel<MeleePuppetEntity>, HumanoidArmorModel<MeleePuppetEntity>> armorLayer;
        boolean slim = this.isSlim(entity);
        if (slim) {
            this.f_115290_ = this.slimModel;
            armorLayer = this.slimArmorLayer;
        } else {
            this.f_115290_ = (PuppetModel)this.m_7200_();
            armorLayer = this.regularArmorLayer;
        }
        this.m_115326_((RenderLayer)armorLayer);
        super.m_7392_((Mob)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        this.f_115291_.remove(armorLayer);
    }

    @NotNull
    public ResourceLocation getTextureLocation(MeleePuppetEntity entity) {
        Player player;
        UUID ownerUUID = entity.getOwnerUUID();
        if (ownerUUID != null && (player = entity.m_9236_().m_46003_(ownerUUID)) instanceof AbstractClientPlayer) {
            AbstractClientPlayer clientPlayer = (AbstractClientPlayer)player;
            return clientPlayer.m_108560_();
        }
        return new ResourceLocation("textures/entity/steve.png");
    }

    protected void scale(MeleePuppetEntity entity, PoseStack poseStack, float partialTickTime) {
        poseStack.m_85841_(0.9375f, 0.9375f, 0.9375f);
    }
}

