/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.structure;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.client.structure.BuildModeHandler;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class BuildModeRenderer {
    private static Vec3i structureSize;
    private static Rotation rotation;

    public static Vec3i getStructureSize() {
        return structureSize;
    }

    @SubscribeEvent
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_CUTOUT_BLOCKS && BuildModeHandler.isBuildModeEnabled() && BuildModeHandler.getLastHitResult() != null && Freecam.isEnabled() && !Freecam.isRotateCamera()) {
            rotation = BuildModeHandler.getRotation();
            BuildModeRenderer.renderBoundingBox(event);
        }
    }

    public static void updateStructureSize(Vec3i newSize) {
        structureSize = newSize;
    }

    static Vec3i rotateVec3i(Vec3i vec, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_90 -> new Vec3i(-vec.m_123343_(), vec.m_123342_(), vec.m_123341_());
            case Rotation.CLOCKWISE_180 -> new Vec3i(-vec.m_123341_(), vec.m_123342_(), -vec.m_123343_());
            case Rotation.COUNTERCLOCKWISE_90 -> new Vec3i(vec.m_123343_(), vec.m_123342_(), -vec.m_123341_());
            default -> vec;
        };
    }

    private static BlockPos calculateOffset(Vec3i vec, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_90 -> new BlockPos(1, 0, 0);
            case Rotation.CLOCKWISE_180 -> new BlockPos(1, 0, 1);
            case Rotation.COUNTERCLOCKWISE_90 -> new BlockPos(0, 0, 1);
            default -> BlockPos.f_121853_;
        };
    }

    private static void renderBoundingBox(RenderLevelStageEvent event) {
        BlockPos buildPos = BuildModeHandler.getBuildPosition();
        if (buildPos == null) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (structureSize != null && structureSize.m_123341_() > 0 && structureSize.m_123342_() > 0 && structureSize.m_123343_() > 0) {
            BlockPos blockPos = buildPos;
            Vec3 cameraPos = minecraft.f_91063_.m_109153_().m_90583_();
            PoseStack poseStack = event.getPoseStack();
            Vec3i rotatedSize = BuildModeRenderer.rotateVec3i(structureSize, rotation);
            BlockPos offset = BuildModeRenderer.calculateOffset(structureSize, rotation);
            BlockPos adjustedPos = blockPos.m_121955_((Vec3i)offset);
            double startX = (double)adjustedPos.m_123341_() - cameraPos.f_82479_;
            double startY = (double)adjustedPos.m_123342_() - cameraPos.f_82480_;
            double startZ = (double)adjustedPos.m_123343_() - cameraPos.f_82481_;
            double endX = startX + (double)rotatedSize.m_123341_();
            double endY = startY + (double)rotatedSize.m_123342_();
            double endZ = startZ + (double)rotatedSize.m_123343_();
            VertexConsumer buffer = minecraft.m_91269_().m_110104_().m_6299_(RenderType.m_110504_());
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)buffer, (double)startX, (double)startY, (double)startZ, (double)endX, (double)endY, (double)endZ, (float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)buffer, (double)startX, (double)(startY + 1.0), (double)startZ, (double)endX, (double)endY, (double)endZ, (float)0.9f, (float)0.9f, (float)0.9f, (float)1.0f);
            Vec3i frontFaceNormal = switch (rotation) {
                case Rotation.NONE -> new Vec3i(0, 0, -1);
                case Rotation.CLOCKWISE_90 -> new Vec3i(1, 0, 0);
                case Rotation.CLOCKWISE_180 -> new Vec3i(0, 0, 1);
                case Rotation.COUNTERCLOCKWISE_90 -> new Vec3i(-1, 0, 0);
                default -> new Vec3i(0, 0, -1);
            };
            double minX = Math.min(startX, endX);
            double maxX = Math.max(startX, endX);
            double minY = Math.min(startY, endY);
            double maxY = Math.max(startY, endY);
            double minZ = Math.min(startZ, endZ);
            double maxZ = Math.max(startZ, endZ);
            if (frontFaceNormal.m_123343_() != 0) {
                double faceZ = frontFaceNormal.m_123343_() > 0 ? maxZ - 0.5 : minZ + 0.5;
                LevelRenderer.m_109621_((PoseStack)poseStack, (VertexConsumer)buffer, (double)minX, (double)(minY + 1.0), (double)faceZ, (double)maxX, (double)maxY, (double)faceZ, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)0.5f, (float)0.5f, (float)0.5f);
            } else if (frontFaceNormal.m_123341_() != 0) {
                double faceX = frontFaceNormal.m_123341_() > 0 ? maxX - 0.5 : minX + 0.5;
                LevelRenderer.m_109621_((PoseStack)poseStack, (VertexConsumer)buffer, (double)faceX, (double)(minY + 1.0), (double)minZ, (double)faceX, (double)maxY, (double)maxZ, (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)0.5f, (float)0.5f, (float)0.5f);
            }
            minecraft.m_91269_().m_110104_().m_109912_(RenderType.m_110504_());
        }
    }
}

