/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.utils;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

public class ClientRelationHelper {
    private static ClientRelationHelper instance;
    private final Set<UUID> enemyEntityUUIDs = new HashSet<UUID>();
    private final Set<UUID> sharedControlEntityUUIDs = new HashSet<UUID>();

    private ClientRelationHelper() {
    }

    public static ClientRelationHelper getInstance() {
        if (instance == null) {
            instance = new ClientRelationHelper();
        }
        return instance;
    }

    public void clearRelations() {
        this.enemyEntityUUIDs.clear();
        this.sharedControlEntityUUIDs.clear();
    }

    public void updateEnemyRelations(Set<UUID> enemyUUIDs) {
        this.enemyEntityUUIDs.clear();
        this.enemyEntityUUIDs.addAll(enemyUUIDs);
    }

    public void updateSharedControlRelations(Set<UUID> sharedControlUUIDs) {
        this.sharedControlEntityUUIDs.clear();
        this.sharedControlEntityUUIDs.addAll(sharedControlUUIDs);
    }

    public RelationSystem.RelationType getRelationWithPlayer(Entity entity) {
        if (entity instanceof BaseCombatEntity) {
            BaseCombatEntity baseCombatEntity = (BaseCombatEntity)entity;
            UUID entityUUID = baseCombatEntity.getOwnerUUID();
            if (this.enemyEntityUUIDs.contains(entityUUID) || entityUUID == null) {
                return RelationSystem.RelationType.HOSTILE;
            }
            if (this.sharedControlEntityUUIDs.contains(entityUUID) || entityUUID.equals(Minecraft.m_91087_().f_91074_.m_20148_())) {
                return RelationSystem.RelationType.CONTROL;
            }
        }
        return RelationSystem.RelationType.NEUTRAL;
    }
}

