/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main;

import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import ydmsama.hundred_years_war.main.blocks.ModBlockEntities;
import ydmsama.hundred_years_war.main.blocks.ModBlocks;
import ydmsama.hundred_years_war.main.commands.Commands;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.RelationSyncPacket;
import ydmsama.hundred_years_war.main.recruitment.RecruitmentConfigManager;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywEntityRegistry;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;
import ydmsama.hundred_years_war.main.utils.ExpBlacklistManager;
import ydmsama.hundred_years_war.main.utils.FirstJoinHandler;
import ydmsama.hundred_years_war.main.utils.FreecamStateManager;
import ydmsama.hundred_years_war.main.utils.PuppetStateHandler;
import ydmsama.hundred_years_war.main.utils.RelationSystem;
import ydmsama.hundred_years_war.main.utils.TargetListManager;
import ydmsama.hundred_years_war.main.utils.TeamRelationData;

@Mod(value="hundred_years_war")
public class HundredYearsWar {
    public static final String MODID = "hundred_years_war";

    public HundredYearsWar() {
        ServerModConfig.load();
        File configDir = new File("config/hundredyearswar");
        if (!configDir.exists()) {
            configDir.mkdirs();
            System.out.println("\u5df2\u521b\u5efaconfig/hundredyearswar\u76ee\u5f55");
        }
        System.out.println("\u6b63\u5728\u52a0\u8f7dBaseCombatEntity\u76ee\u6807\u5217\u8868...");
        TargetListManager.loadTargetList();
        System.out.println("BaseCombatEntity\u76ee\u6807\u5217\u8868\u52a0\u8f7d\u5b8c\u6210");
        System.out.println("\u6b63\u5728\u52a0\u8f7d\u7ecf\u9a8c\u9ed1\u540d\u5355...");
        ExpBlacklistManager.loadExpBlacklist();
        System.out.println("\u7ecf\u9a8c\u9ed1\u540d\u5355\u52a0\u8f7d\u5b8c\u6210");
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModBlocks.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ServerPacketHandler.register();
        HywAttributes.ATTRIBUTES.register(modEventBus);
        FMLJavaModLoadingContext.get().getModEventBus().register(HywEntityRegistry.class);
        HywItemRegistry.register();
        MinecraftForge.EVENT_BUS.register((Object)this);
        HywEntityRegistry.ENTITY_TYPES.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        Path worldPath = event.getServer().m_129843_(LevelResource.f_78182_);
        FirstJoinHandler.loadFirstJoinData(worldPath);
        Path relationSavePath = event.getServer().m_129843_(LevelResource.f_78182_).resolve("relations.dat");
        RelationSystem.loadRelations(relationSavePath);
        Path squadSavePath = event.getServer().m_129843_(LevelResource.f_78182_).resolve("squads.dat");
        try {
            SelectionSystem.loadSquads(squadSavePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Path puppetStatesPath = event.getServer().m_129843_(LevelResource.f_78182_).resolve("puppet_states.dat");
        try {
            PuppetStateHandler.loadPersistentStates(puppetStatesPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        RecruitmentConfigManager.loadAllConfigs();
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        Path worldPath = event.getServer().m_129843_(LevelResource.f_78182_);
        FirstJoinHandler.saveFirstJoinData(worldPath);
        Path relationSavePath = event.getServer().m_129843_(LevelResource.f_78182_).resolve("relations.dat");
        try {
            RelationSystem.saveRelations(relationSavePath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Path squadSavePath = event.getServer().m_129843_(LevelResource.f_78182_).resolve("squads.dat");
        try {
            SelectionSystem.saveSquads(squadSavePath);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Path puppetStatesPath = event.getServer().m_129843_(LevelResource.f_78182_).resolve("puppet_states.dat");
        try {
            PuppetStateHandler.savePersistentStates(puppetStatesPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        FreecamStateManager.clearAllStates();
        PuppetStateHandler.clearAllTemporaryStates();
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            FirstJoinHandler.handlePlayerFirstJoin(player2);
            UUID playerUUID = player2.m_20148_();
            String playerName = player2.m_7755_().getString();
            RelationSystem.addPlayerAndEnsureRelations(playerUUID, playerName);
            RelationSyncPacket.sendToClient(player2);
            for (UUID teamUUID : RelationSystem.getAllTeams().keySet()) {
                TeamRelationData team = RelationSystem.getTeamRelationData(teamUUID);
                if (team == null || !"Player's Elite Squad".equals(team.getTeamName())) continue;
                boolean hasOwner = false;
                for (Map.Entry<UUID, TeamRelationData.MemberType> entry : team.getAllMembers().entrySet()) {
                    if (entry.getValue() != TeamRelationData.MemberType.OWNER) continue;
                    hasOwner = true;
                    break;
                }
                if (hasOwner) break;
                team.addMember(playerUUID, TeamRelationData.MemberType.OWNER);
                System.out.println("\u73a9\u5bb6 " + playerName + " \u5df2\u88ab\u8bbe\u7f6e\u4e3a\u56e2\u961f Player's Elite Squad \u7684\u6240\u6709\u8005");
                break;
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            UUID playerUUID = player2.m_20148_();
            FreecamStateManager.removePlayerState(playerUUID);
            PuppetStateHandler.clearPlayerState(playerUUID);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        Player player;
        if (event.isWasDeath() && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            UUID playerUUID = player2.m_20148_();
            String playerName = player2.m_7755_().getString();
            RelationSystem.addPlayerAndEnsureRelations(playerUUID, playerName);
            RelationSyncPacket.sendToClient(player2);
        }
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        Commands.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

