/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities;

import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.mounted.NpcHorse;
import ydmsama.hundred_years_war.main.entity.goals.MoveGoal;
import ydmsama.hundred_years_war.main.entity.utils.Rideable;
import ydmsama.hundred_years_war.main.entity.utils.json.EquipmentLevelData;
import ydmsama.hundred_years_war.main.entity.utils.json.EquipmentOption;
import ydmsama.hundred_years_war.main.item.BaseScrollItem;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;

public class HywHorseEntity
extends BaseCombatEntity
implements Rideable {
    protected float MOVEMENT_SPEED = 0.38f;
    private static final EntityDataAccessor<ItemStack> HORSE_ARMOR = SynchedEntityData.m_135353_(HywHorseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final UUID ATTACK_MODIFIER_UUID = UUID.fromString("e8d55f0d-8f97-4c99-86b1-c5cd3b3e9f9f");
    private static final AttributeModifier ATTACK_MODIFIER = new AttributeModifier(ATTACK_MODIFIER_UUID, "Horse Attack Boost", 0.25, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final EntityDataAccessor<Boolean> IS_CHARGING = SynchedEntityData.m_135353_(HywHorseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float currentRot;
    private float targetRot;
    protected float rotationLimit = 20.0f;
    protected float rotationLimitCharge = 5.0f;

    public HywHorseEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
        this.setHorseArmor(new ItemStack((ItemLike)Items.f_42652_));
    }

    public LivingEntity m_6688_() {
        return null;
    }

    public static AttributeSupplier.Builder createHorseAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22279_, (double)0.38f).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22278_, 0.8).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), 55.0);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.syncHealthWithPassenger();
    }

    @Override
    public float getCurrentRot() {
        return this.currentRot;
    }

    @Override
    public float getTargetRot() {
        return this.targetRot;
    }

    private void syncHealthWithPassenger() {
        Entity entity;
        if (!this.m_9236_().f_46443_ && (entity = this.m_146895_()) instanceof LivingEntity) {
            LivingEntity passenger = (LivingEntity)entity;
            float passengerMaxHealth = passenger.m_21233_();
            if (this.m_21233_() != passengerMaxHealth) {
                this.m_21051_(Attributes.f_22276_).m_22100_((double)passengerMaxHealth);
            }
            float passengerHealth = passenger.m_21223_();
            if (this.m_21223_() != passengerHealth) {
                this.m_21153_(passengerHealth);
            }
        }
    }

    public double m_6048_() {
        if (this.m_20197_().get(0) instanceof Player) {
            return (double)this.m_20206_() * 0.9;
        }
        return (double)this.m_20206_() * 0.6;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HORSE_ARMOR, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(IS_CHARGING, (Object)false);
    }

    public ItemStack getHorseArmor() {
        return (ItemStack)this.f_19804_.m_135370_(HORSE_ARMOR);
    }

    public void setHorseArmor(ItemStack horseArmor) {
        this.f_19804_.m_135381_(HORSE_ARMOR, (Object)horseArmor);
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(IS_CHARGING);
    }

    public void setCharging(boolean charging) {
        this.f_19804_.m_135381_(IS_CHARGING, (Object)charging);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        CompoundTag armorTag = new CompoundTag();
        this.getHorseArmor().m_41739_(armorTag);
        compound.m_128365_("HorseArmor", (Tag)armorTag);
        compound.m_128350_("CurrentRot", this.currentRot);
        compound.m_128350_("TargetRot", this.targetRot);
        compound.m_128379_("IsCharging", this.isCharging());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("HorseArmor", 10)) {
            this.setHorseArmor(ItemStack.m_41712_((CompoundTag)compound.m_128469_("HorseArmor")));
        }
        if (compound.m_128441_("CurrentRot")) {
            this.currentRot = compound.m_128457_("CurrentRot");
        }
        if (compound.m_128441_("TargetRot")) {
            this.targetRot = compound.m_128457_("TargetRot");
        }
        if (compound.m_128441_("IsCharging")) {
            this.setCharging(compound.m_128471_("IsCharging"));
        }
    }

    @Override
    protected Item getScrollType() {
        return switch (this.getEquipmentLevel()) {
            case 1 -> (Item)HywItemRegistry.SCROLL_HORSE.get();
            case 2 -> (Item)HywItemRegistry.SCROLL_HORSE_1.get();
            case 3 -> (Item)HywItemRegistry.SCROLL_HORSE_2.get();
            case 4 -> (Item)HywItemRegistry.SCROLL_HORSE_3.get();
            default -> null;
        };
    }

    @Override
    protected void setEquipmentFromLevelData(EquipmentLevelData levelData) {
        super.setEquipmentFromLevelData(levelData);
        EquipmentOption horseArmorOption = this.selectRandomItem(levelData.getHorseArmor());
        ItemStack horseArmorStack = this.createItemStack(horseArmorOption);
        this.setHorseArmor(horseArmorStack);
    }

    @Override
    public int getSkinCounts() {
        return 5;
    }

    @Override
    public float getAttackReach() {
        if (this.m_146895_() != null && this.m_146895_() instanceof BaseCombatEntity) {
            return ((BaseCombatEntity)this.m_146895_()).getAttackReach() * 0.8f;
        }
        return super.getAttackReach();
    }

    @Override
    protected void updateAnimationState() {
        if (!this.f_267362_.m_267780_()) {
            this.moveAnimationState.m_216973_();
            this.attackAnimationState.m_216973_();
            if (!this.idleAnimationState.m_216984_()) {
                this.idleAnimationState.m_216977_(this.f_19797_);
            }
        } else {
            this.attackAnimationState.m_216973_();
            this.idleAnimationState.m_216973_();
            if (!this.moveAnimationState.m_216984_()) {
                this.moveAnimationState.m_216977_(this.f_19797_);
            }
        }
    }

    public int getHorseArmorValue(ItemStack horseArmor) {
        if (horseArmor.m_41619_()) {
            return 0;
        }
        Item item = horseArmor.m_41720_();
        if (item == Items.f_42654_) {
            return 6;
        }
        if (item == Items.f_42651_) {
            return 10;
        }
        if (item == Items.f_42652_) {
            return 10;
        }
        if (item == Items.f_42653_) {
            return 16;
        }
        return 2;
    }

    public int m_21230_() {
        return this.getHorseArmorValue(this.getHorseArmor());
    }

    public void m_20348_(Entity passenger) {
        LivingEntity livingPassenger;
        AttributeInstance attackDamageAttribute;
        super.m_20348_(passenger);
        if (!this.m_9236_().f_46443_ && passenger instanceof LivingEntity && (attackDamageAttribute = (livingPassenger = (LivingEntity)passenger).m_21051_(Attributes.f_22281_)) != null && attackDamageAttribute.m_22111_(ATTACK_MODIFIER_UUID) == null) {
            attackDamageAttribute.m_22118_(ATTACK_MODIFIER);
        }
    }

    public void m_20351_(Entity passenger) {
        LivingEntity livingPassenger;
        AttributeInstance attackDamageAttribute;
        if (!this.m_9236_().f_46443_ && passenger instanceof LivingEntity && (attackDamageAttribute = (livingPassenger = (LivingEntity)passenger).m_21051_(Attributes.f_22281_)) != null) {
            attackDamageAttribute.m_22120_(ATTACK_MODIFIER_UUID);
        }
        super.m_20351_(passenger);
    }

    @Override
    public double getDesiredDistance() {
        return 2.5;
    }

    @Override
    public double getArrivalThreshold() {
        return 0.5;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        Entity playerItem;
        Player player;
        Entity entity = source.m_7639_();
        if (entity instanceof Player && (player = (Player)entity).m_6144_() && ServerRelationHelper.hasControlOver(player, (Entity)this) && ServerModConfig.INSTANCE.isAllowEquipmentChange()) {
            ItemStack horseArmor;
            playerItem = player.m_21120_(InteractionHand.MAIN_HAND);
            if (playerItem.m_41619_() && !(horseArmor = this.getHorseArmor()).m_41619_()) {
                this.m_19983_(horseArmor);
                this.setHorseArmor(ItemStack.f_41583_);
                return false;
            }
            if (playerItem.m_41720_() instanceof HorseArmorItem) {
                ItemStack entityHorseArmor = this.getHorseArmor();
                this.setHorseArmor(playerItem.m_41777_());
                player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                if (!entityHorseArmor.m_41619_()) {
                    player.m_21008_(InteractionHand.MAIN_HAND, entityHorseArmor);
                }
                return false;
            }
        }
        if (!this.m_9236_().f_46443_ && (playerItem = this.m_146895_()) instanceof LivingEntity) {
            Player player2;
            LivingEntity passenger = (LivingEntity)playerItem;
            Entity entity2 = source.m_7639_();
            if (!(entity2 instanceof Player && (player2 = (Player)entity2).m_6144_() && ServerRelationHelper.hasControlOver(player2, (Entity)this))) {
                passenger.m_6469_(source, amount);
                return super.m_6469_(source, 0.0f);
            }
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this instanceof NpcHorse) {
            return super.m_6071_(player, hand);
        }
        if (!this.m_9236_().f_46443_ && player.m_6144_() && ServerRelationHelper.hasControlOver(player, (Entity)this)) {
            if (ServerModConfig.INSTANCE.isAllowSoldierRecall() && this.getScrollType() != null) {
                ItemStack stack = new ItemStack((ItemLike)this.getScrollType());
                CompoundTag entityData = new CompoundTag();
                this.m_20240_(entityData);
                ((BaseScrollItem)stack.m_41720_()).saveEntityDataToItem(stack, entityData);
                if (!player.m_150109_().m_36054_(stack)) {
                    player.m_36176_(stack, false);
                }
                this.spawnDespawnParticles();
                this.m_146870_();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private void spawnDespawnParticles() {
        int particleCount = 40;
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < particleCount; ++i) {
                double offsetX = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 1.0;
                double offsetY = this.m_9236_().f_46441_.m_188500_() * 0.5 + 0.5;
                double offsetZ = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 1.0;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 1, offsetX, offsetY, offsetZ, 0.0);
            }
        }
    }

    public float getMOVEMENT_SPEED() {
        return this.MOVEMENT_SPEED;
    }

    @Override
    public boolean shouldMoveOnly() {
        return this.getCurrentCommandedGoal() != null && this.getCurrentCommandedGoal().goal instanceof MoveGoal && this.getCurrentCommandedGoal().priority == 1;
    }

    @Override
    public float getRotationLimit() {
        if (this.isCharging()) {
            return this.rotationLimitCharge;
        }
        return this.rotationLimit;
    }
}

