/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities;

import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterHeavy;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterSiege;
import ydmsama.hundred_years_war.main.entity.entities.tags.LightUnit;
import ydmsama.hundred_years_war.main.entity.goals.HywWaterAvoidingRandomStrollGoal;
import ydmsama.hundred_years_war.main.entity.utils.Rider;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class WarriorEntity
extends BaseCombatEntity
implements Rider,
LightUnit,
CounterHeavy,
CounterSiege {
    private static final float ATTACK_REACH = 2.5f;
    private static final float MOVEMENT_SPEED = 0.32f;

    public WarriorEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
    }

    public static AttributeSupplier.Builder createWarriorAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, (double)0.32f).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22278_, 0.3).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), 2.5);
    }

    @Override
    protected void setDefaultEquipment() {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42386_));
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42468_));
        this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42469_));
        this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42470_));
        this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42471_));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 10;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 5;
    }

    @Override
    public int getAttackCoolDownDuration() {
        Random random = new Random();
        return 1 + random.nextInt(6);
    }

    protected void m_6677_(DamageSource damageSource) {
        SoundEvent soundEvent = this.m_7975_(damageSource);
        if (soundEvent != null) {
            this.m_5496_(soundEvent, this.m_6121_(), this.m_6100_());
        }
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new HywWaterAvoidingRandomStrollGoal(this, 0.75));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        super.m_8099_();
    }

    @Override
    protected Item getScrollType() {
        return switch (this.getEquipmentLevel()) {
            case 1 -> (Item)HywItemRegistry.SCROLL_WARRIOR.get();
            case 2 -> (Item)HywItemRegistry.SCROLL_WARRIOR_1.get();
            case 3 -> (Item)HywItemRegistry.SCROLL_WARRIOR_2.get();
            case 4 -> (Item)HywItemRegistry.SCROLL_WARRIOR_3.get();
            default -> null;
        };
    }

    @Override
    protected void increaseStatsOnLevelUp() {
        AttributeInstance attackDamage;
        AttributeInstance maxHealth = this.m_21051_(Attributes.f_22276_);
        if (maxHealth != null) {
            maxHealth.m_22100_(maxHealth.m_22115_() + 1.0);
            this.m_5634_(1.0f);
        }
        if ((attackDamage = this.m_21051_(Attributes.f_22281_)) != null) {
            attackDamage.m_22100_(attackDamage.m_22115_() + 0.5);
        }
    }

    @Override
    public double getLightDamageModifier() {
        return 0.5;
    }

    @Override
    public double getHeavyDamageModifier() {
        return 1.5;
    }

    @Override
    public double getSiegeDamageModifier() {
        return 1.5;
    }
}

