/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.mounted;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.HywHorseEntity;
import ydmsama.hundred_years_war.main.entity.entities.mounted.MountedArcherRiderEntity;
import ydmsama.hundred_years_war.main.entity.entities.mounted.NpcHorse;
import ydmsama.hundred_years_war.main.entity.entities.tags.CavalryUnit;
import ydmsama.hundred_years_war.main.entity.entities.tags.LightUnit;
import ydmsama.hundred_years_war.main.registry.HywEntityRegistry;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;

public class MountedArcherHorseEntity
extends HywHorseEntity
implements NpcHorse,
CavalryUnit,
LightUnit {
    private boolean riderSpawned = false;
    private CompoundTag riderData = null;
    private MountedArcherRiderEntity rider;

    public MountedArcherHorseEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createMountedArcherHorseAttributes() {
        return HywHorseEntity.createHorseAttributes();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && !this.riderSpawned) {
            this.spawnRider();
        }
    }

    private void spawnRider() {
        this.rider = (MountedArcherRiderEntity)((EntityType)HywEntityRegistry.MOUNTED_ARCHER_RIDER.get()).m_20615_(this.m_9236_());
        if (this.rider != null) {
            if (this.riderData != null) {
                this.rider.m_7378_(this.riderData);
            } else {
                this.rider.setEquipment(this.getEquipmentLevel());
            }
            this.rider.setOwnerUUID(this.getOwnerUUID());
            this.rider.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.rider.m_7998_((Entity)this, true);
            this.m_9236_().m_7967_((Entity)this.rider);
            this.riderSpawned = true;
        }
    }

    private void saveRiderData() {
        if (this.rider != null) {
            this.riderData = new CompoundTag();
            this.rider.m_7380_(this.riderData);
        }
    }

    private void loadRiderData(CompoundTag compound) {
        if (compound.m_128441_("RiderData")) {
            this.riderData = compound.m_128469_("RiderData");
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("RiderSpawned", this.riderSpawned);
        this.saveRiderData();
        if (this.riderData != null) {
            compound.m_128365_("RiderData", (Tag)this.riderData);
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.riderSpawned = compound.m_128471_("RiderSpawned");
        this.loadRiderData(compound);
    }

    @Override
    protected Item getScrollType() {
        return switch (this.getEquipmentLevel()) {
            case 1 -> (Item)HywItemRegistry.SCROLL_MOUNTED_ARCHER.get();
            case 2 -> (Item)HywItemRegistry.SCROLL_MOUNTED_ARCHER_1.get();
            case 3 -> (Item)HywItemRegistry.SCROLL_MOUNTED_ARCHER_2.get();
            case 4 -> (Item)HywItemRegistry.SCROLL_MOUNTED_ARCHER_3.get();
            default -> null;
        };
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!this.m_9236_().f_46443_ && player.m_6144_() && (ServerRelationHelper.hasControlOver(player, (Entity)this) || player.m_7500_())) {
            this.riderSpawned = false;
            if (this.m_146895_() != null) {
                this.m_146895_().m_146870_();
            }
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public void m_20351_(Entity passenger) {
        super.m_20351_(passenger);
        if (!this.m_9236_().m_5776_() && passenger instanceof BaseCombatEntity) {
            ((BaseCombatEntity)passenger).setHywTarget(null);
        }
    }

    @Override
    protected String getEquipmentJsonPath() {
        String equipmentFile = ServerModConfig.getCurrentEquipmentFileName();
        return "hundred_years_war:hyw/npc/hyw_horse/" + equipmentFile;
    }
}

