/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.mounted;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.HywHorseEntity;
import ydmsama.hundred_years_war.main.entity.entities.mounted.NpcHorse;
import ydmsama.hundred_years_war.main.entity.entities.tags.CavalryUnit;
import ydmsama.hundred_years_war.main.entity.entities.tags.HeavyUnit;
import ydmsama.hundred_years_war.main.registry.HywEntityRegistry;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;

public class MountedLancerHorseEntity
extends HywHorseEntity
implements NpcHorse,
CavalryUnit,
HeavyUnit {
    protected boolean riderSpawned = false;
    protected CompoundTag riderData = null;
    protected BaseCombatEntity rider;

    public MountedLancerHorseEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createMountedLancerHorseAttributes() {
        return HywHorseEntity.createHorseAttributes();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && !this.riderSpawned && this.m_6084_()) {
            this.spawnRider();
        }
    }

    protected BaseCombatEntity createRiderEntity() {
        return (BaseCombatEntity)((EntityType)HywEntityRegistry.MOUNTED_LANCER_RIDER.get()).m_20615_(this.m_9236_());
    }

    protected void spawnRider() {
        this.rider = this.createRiderEntity();
        if (this.rider != null) {
            if (this.riderData != null) {
                this.rider.m_7378_(this.riderData);
            } else {
                this.rider.setEquipment(this.getEquipmentLevel());
            }
            this.rider.setOwnerUUID(this.getOwnerUUID());
            this.rider.m_6034_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.rider.m_7998_((Entity)this, true);
            this.m_9236_().m_7967_((Entity)this.rider);
            this.riderSpawned = true;
        }
    }

    protected void saveRiderData() {
        if (this.rider != null && this.rider.m_6084_()) {
            this.riderData = new CompoundTag();
            this.rider.m_7380_(this.riderData);
        } else {
            this.riderData = null;
        }
    }

    protected void loadRiderData(CompoundTag compound) {
        if (compound.m_128441_("RiderData")) {
            this.riderData = compound.m_128469_("RiderData");
        }
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        this.saveRiderData();
        compound.m_128379_("RiderSpawned", this.riderSpawned);
        if (this.riderData != null) {
            compound.m_128365_("RiderData", (Tag)this.riderData);
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.loadRiderData(compound);
        this.riderSpawned = compound.m_128471_("RiderSpawned");
    }

    @Override
    protected Item getScrollType() {
        return switch (this.getEquipmentLevel()) {
            case 1 -> (Item)HywItemRegistry.SCROLL_MOUNTED_LANCER.get();
            case 2 -> (Item)HywItemRegistry.SCROLL_MOUNTED_LANCER_1.get();
            case 3 -> (Item)HywItemRegistry.SCROLL_MOUNTED_LANCER_2.get();
            case 4 -> (Item)HywItemRegistry.SCROLL_MOUNTED_LANCER_3.get();
            default -> null;
        };
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!this.m_9236_().f_46443_ && player.m_6144_() && hand == InteractionHand.MAIN_HAND && (ServerRelationHelper.hasControlOver(player, (Entity)this) || player.m_7500_())) {
            Item scrollItemType = this.getScrollType();
            if (scrollItemType == null) {
                return InteractionResult.PASS;
            }
            ItemStack scrollItemStack = new ItemStack((ItemLike)scrollItemType);
            CompoundTag entityDataForScroll = new CompoundTag();
            Entity actualRiderPassenger = null;
            for (Entity passenger : this.m_20197_()) {
                BaseCombatEntity templateRider = this.createRiderEntity();
                if (templateRider == null || !((Object)((Object)templateRider)).getClass().isInstance(passenger) || !passenger.m_6084_()) continue;
                actualRiderPassenger = passenger;
                break;
            }
            if (actualRiderPassenger instanceof BaseCombatEntity) {
                this.riderData = new CompoundTag();
                ((BaseCombatEntity)actualRiderPassenger).m_7380_(this.riderData);
                if (this.rider != actualRiderPassenger) {
                    this.rider = (BaseCombatEntity)actualRiderPassenger;
                    this.riderSpawned = true;
                }
            } else {
                this.riderData = null;
                this.rider = null;
                this.riderSpawned = false;
            }
            this.m_7380_(entityDataForScroll);
            entityDataForScroll.m_128473_("RiderSpawned");
            scrollItemStack.m_41784_().m_128365_("EntityData", (Tag)entityDataForScroll);
            if (!player.m_150109_().m_36054_(scrollItemStack)) {
                player.m_36176_(scrollItemStack, false);
            }
            if (actualRiderPassenger != null) {
                actualRiderPassenger.m_146870_();
            }
            this.spawnDespawnParticles();
            this.m_146870_();
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    protected void spawnDespawnParticles() {
        Level level;
        if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int particleCount = 40;
            for (int i = 0; i < particleCount; ++i) {
                double offsetX = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 1.0;
                double offsetY = this.m_9236_().f_46441_.m_188500_() * 0.5 + 0.5;
                double offsetZ = (this.m_9236_().f_46441_.m_188500_() - 0.5) * 1.0;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 1, offsetX, offsetY, offsetZ, 0.0);
            }
        }
    }

    @Override
    protected String getEquipmentJsonPath() {
        String equipmentFile = ServerModConfig.getCurrentEquipmentFileName();
        return "hundred_years_war:hyw/npc/hyw_horse/" + equipmentFile;
    }
}

