/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.mounted;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import ydmsama.hundred_years_war.main.entity.entities.mounted.MountedLancerRiderEntity;
import ydmsama.hundred_years_war.main.entity.entities.tags.CavalryUnit;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterRanged;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterSiege;
import ydmsama.hundred_years_war.main.entity.entities.tags.LightUnit;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class MountedLightLancerRiderEntity
extends MountedLancerRiderEntity
implements CavalryUnit,
LightUnit,
CounterRanged,
CounterSiege {
    private static final float ATTACK_REACH = 3.0f;
    private static final float LIGHT_LANCER_CHARGE_ATTACK_REACH = 3.5f;
    private static final float MOVEMENT_SPEED = 0.35f;
    private static final int LIGHT_LANCER_CHARGE_COOLDOWN_TICKS = 180;
    private static final float LIGHT_LANCER_CHARGE_SPEED_MULTIPLIER = 0.3f;
    private static final float LIGHT_LANCER_CHARGE_DAMAGE_MULTIPLIER = 1.0f;
    private static final float LIGHT_LANCER_CHARGE_KNOCKBACK_STRENGTH = 1.2f;

    public MountedLightLancerRiderEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
    }

    @Override
    protected void setDefaultEquipment() {
        this.setMainWeapon(this.getDefaultMainWeapon());
        this.setChargeWeapon(this.getDefaultChargeWeapon());
        this.setUsingChargeWeapon(false);
        this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42740_));
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42468_));
        this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42469_));
        this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42470_));
        this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42471_));
    }

    @Override
    protected ItemStack getDefaultChargeWeapon() {
        return new ItemStack((ItemLike)HywItemRegistry.IRON_PIKE.get());
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
    }

    @Override
    protected float getMinChargeDistanceSquared() {
        return 25.0f;
    }

    @Override
    protected float getMaxChargeDistanceSquared() {
        return 900.0f;
    }

    @Override
    protected int getChargeCooldownTicks() {
        return 180;
    }

    @Override
    protected int getMaxChargeDurationTicks() {
        return 160;
    }

    @Override
    protected float getChargeSpeedMultiplier() {
        return 0.3f;
    }

    @Override
    protected float getChargeDamageMultiplier() {
        return 3.0f;
    }

    @Override
    protected float getChargeKnockbackStrength() {
        return 1.2f;
    }

    @Override
    protected int getReadyStanceDelay() {
        return 40;
    }

    @Override
    public float getChargeAttackReach() {
        return 3.5f;
    }

    @Override
    protected void increaseStatsOnLevelUp() {
        AttributeInstance attackDamage;
        AttributeInstance maxHealth = this.m_21051_(Attributes.f_22276_);
        if (maxHealth != null) {
            maxHealth.m_22100_(maxHealth.m_22115_() + 2.0);
            this.m_5634_(2.0f);
        }
        if ((attackDamage = this.m_21051_(Attributes.f_22281_)) != null) {
            attackDamage.m_22100_(attackDamage.m_22115_() + 0.25);
        }
    }

    public static AttributeSupplier.Builder createMountedLightLancerRiderAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22278_, 0.3).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), 3.0);
    }

    @Override
    protected boolean isChargeWeaponItem(ItemStack stack) {
        return stack.m_150930_((Item)HywItemRegistry.WOODEN_PIKE_CHARGE.get()) || stack.m_150930_((Item)HywItemRegistry.STONE_PIKE_CHARGE.get()) || stack.m_150930_((Item)HywItemRegistry.IRON_PIKE_CHARGE.get()) || stack.m_150930_((Item)HywItemRegistry.GOLDEN_PIKE_CHARGE.get()) || stack.m_150930_((Item)HywItemRegistry.DIAMOND_PIKE_CHARGE.get()) || stack.m_150930_((Item)HywItemRegistry.NETHERITE_PIKE_CHARGE.get());
    }

    @Override
    public double getRangedDamageModifier() {
        return 2.0;
    }

    @Override
    public double getSiegeDamageModifier() {
        return 1.5;
    }
}

