/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.puppets;

import java.util.Random;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.main.entity.entities.ShieldmanEntity;
import ydmsama.hundred_years_war.main.entity.entities.puppets.IPuppet;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.utils.PuppetUtils;

public class MeleePuppetEntity
extends ShieldmanEntity
implements IPuppet {
    private static final float ATTACK_REACH = 2.5f;
    private static final float MOVEMENT_SPEED = 0.3f;

    public MeleePuppetEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    public JumpControl m_21569_() {
        return new PuppetUtils.FreecamJumpControl((Mob)this);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.checkOwnerFreecamStatus();
            this.syncHealthWithPassenger();
        }
    }

    @Override
    public void syncHealthWithPassenger() {
        PuppetUtils.syncHealthWithPassenger(this);
    }

    @Override
    public void checkOwnerFreecamStatus() {
        PuppetUtils.checkOwnerFreecamStatus(this);
    }

    @Override
    public void removePuppetSafely() {
        PuppetUtils.removePuppetSafely(this);
    }

    @Override
    public Entity m_146895_() {
        return super.m_146895_();
    }

    public static AttributeSupplier.Builder createMeleePuppetAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), 2.5);
    }

    public double m_6048_() {
        return PuppetUtils.getPassengersRidingOffset();
    }

    @NotNull
    public Vec3 m_7688_(LivingEntity passenger) {
        return PuppetUtils.getDismountLocationForPassenger(this, passenger);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity;
        if (this.m_6844_(EquipmentSlot.OFFHAND).m_41720_() instanceof ShieldItem && this.m_6117_() && new Random().nextInt(100) < 50) {
            amount *= 0.2f;
            this.m_5496_(SoundEvents.f_12346_, this.m_6121_(), this.m_6100_());
        }
        if ((entity = source.m_7640_()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            this.m_6728_(livingEntity);
        }
        return PuppetUtils.handleHurt(this, source, amount);
    }

    @Override
    public boolean isValidTarget(LivingEntity potentialTarget) {
        ItemStack mainHandItem = this.m_6844_(EquipmentSlot.MAINHAND);
        if (mainHandItem.m_41619_()) {
            return false;
        }
        return super.isValidTarget(potentialTarget);
    }
}

