/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.siege;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.main.entity.action.Action;
import ydmsama.hundred_years_war.main.entity.action.PositionAttackAction;
import ydmsama.hundred_years_war.main.entity.action.SiegeModeAction;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.projectile.BlockBreakable;
import ydmsama.hundred_years_war.main.entity.entities.projectile.MangonelsBulletEntity;
import ydmsama.hundred_years_war.main.entity.entities.siege.PositionAttackable;
import ydmsama.hundred_years_war.main.entity.entities.siege.SiegeMode;
import ydmsama.hundred_years_war.main.entity.entities.tags.SiegeUnit;
import ydmsama.hundred_years_war.main.entity.goals.BaseCombatEntityAttackGoal;
import ydmsama.hundred_years_war.main.entity.goals.FollowEntityGoal;
import ydmsama.hundred_years_war.main.entity.goals.PatrolGoal;
import ydmsama.hundred_years_war.main.entity.goals.ReturnToHomeGoal;
import ydmsama.hundred_years_war.main.entity.goals.SkyExposedTargetGoal;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywEntityRegistry;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class MangonelsEntity
extends BaseCombatEntity
implements RangedAttackMob,
SiegeUnit,
SiegeMode,
PositionAttackable {
    private static final float ATTACK_REACH = 100.0f;
    private static final float MOVEMENT_SPEED = 0.2f;
    private static final float BASE_RANGED_ATTACK_DAMAGE = 60.0f;
    private float leftWheelRotation;
    private float rightWheelRotation;
    private static final EntityDataAccessor<Boolean> SHOW_BULLETS = SynchedEntityData.m_135353_(MangonelsEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<BlockPos> TARGET_POS = SynchedEntityData.m_135353_(MangonelsEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(MangonelsEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SIEGE_MODE = SynchedEntityData.m_135353_(MangonelsEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_POSITION_TARGET = SynchedEntityData.m_135353_(MangonelsEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private Vec3 positionTarget;
    private SiegeModeAction siegeModeAction;
    private PositionAttackAction positionAttackAction;
    private int packingProgress = 0;
    private int assemblingProgress = 0;
    private int assemblingWait = 10;
    private int bulletHideTimer = 0;

    public MangonelsEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TARGET_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(STATE, (Object)MangonelsState.PACKED.ordinal());
        this.f_19804_.m_135372_(SHOW_BULLETS, (Object)true);
        this.f_19804_.m_135372_(SIEGE_MODE, (Object)false);
        this.f_19804_.m_135372_(HAS_POSITION_TARGET, (Object)false);
        this.siegeModeAction = new SiegeModeAction(false);
        this.positionAttackAction = new PositionAttackAction();
        this.positionTarget = null;
    }

    @Override
    public List<Action> getActions() {
        ArrayList<Action> actions = new ArrayList<Action>(super.getActions());
        this.siegeModeAction.setCurrentState(this.isSiegeModeEnabled());
        actions.add(this.siegeModeAction);
        actions.add(this.positionAttackAction);
        return actions;
    }

    @Override
    public boolean isSiegeModeEnabled() {
        return (Boolean)this.f_19804_.m_135370_(SIEGE_MODE);
    }

    @Override
    public void setSiegeModeEnabled(boolean enabled) {
        this.f_19804_.m_135381_(SIEGE_MODE, (Object)enabled);
        if (!this.m_9236_().f_46443_) {
            this.siegeModeAction.setCurrentState(enabled);
        }
    }

    public static AttributeSupplier.Builder createMangonelsAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 100.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22276_, 75.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), 100.0).m_22268_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get(), 60.0);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.bulletHideTimer > 0) {
            --this.bulletHideTimer;
            if (this.bulletHideTimer == 0 && !this.m_9236_().f_46443_) {
                this.setShowBullets(true);
            }
        }
        if (!this.m_9236_().f_46443_) {
            if (this.hasPositionTarget() && this.getPositionTarget() != null) {
                BlockPos targetBlockPos = new BlockPos((int)this.getPositionTarget().f_82479_, (int)this.getPositionTarget().f_82480_, (int)this.getPositionTarget().f_82481_);
                this.setTargetPosition(targetBlockPos);
            } else if (this.getHywTarget() != null) {
                this.setTargetPosition(this.getHywTarget().m_20183_());
            } else {
                this.setTargetPosition(BlockPos.f_121853_);
            }
        }
        double velocityX = this.m_20184_().f_82479_;
        double velocityZ = this.m_20184_().f_82481_;
        double speedSq = velocityX * velocityX + velocityZ * velocityZ;
        double speedThreshold = 1.0E-4;
        if (!this.m_9236_().f_46443_) {
            this.manageState();
            if (speedSq < speedThreshold && this.getCurrentState() == MangonelsState.PACKED) {
                if (this.assemblingWait > 0) {
                    --this.assemblingWait;
                } else {
                    this.startAssembling();
                    this.assemblingWait = 10;
                }
            }
            if (speedSq > speedThreshold && this.getCurrentState() == MangonelsState.ASSEMBLING) {
                this.setCurrentState(MangonelsState.PACKED);
            }
            if (!this.m_21573_().m_26571_() && this.getCurrentState() == MangonelsState.ASSEMBLED) {
                this.startPacking();
            }
        }
    }

    private void manageState() {
        switch (this.getCurrentState()) {
            case PACKED: {
                this.setAttributeBaseValue(Attributes.f_22279_, 0.2f);
                break;
            }
            case ASSEMBLED: {
                this.setAttributeBaseValue(Attributes.f_22279_, 0.0);
                break;
            }
            case PACKING: {
                if (this.packingProgress > 0) {
                    --this.packingProgress;
                    break;
                }
                this.setCurrentState(MangonelsState.PACKED);
                this.setAttributeBaseValue(Attributes.f_22279_, 0.2f);
                break;
            }
            case ASSEMBLING: {
                if (this.assemblingProgress > 0) {
                    --this.assemblingProgress;
                    break;
                }
                this.setCurrentState(MangonelsState.ASSEMBLED);
            }
        }
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 100;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 5;
    }

    @Override
    public int getAttackCoolDownDuration() {
        Random random = new Random();
        return 5 + random.nextInt(20);
    }

    @Override
    public float getRotationLimit() {
        return 0.75f;
    }

    @Override
    protected void increaseStatsOnLevelUp() {
    }

    @Override
    public double getDesiredDistance() {
        return 2.5;
    }

    public void m_6504_(LivingEntity target, float pullProgress) {
        this.PerformRangedAttackBoth(null, target);
    }

    @Override
    public void performPositionAttack(Vec3 targetPosition, float pullProgress) {
        this.PerformRangedAttackBoth(targetPosition, null);
    }

    @Override
    public void PerformRangedAttackBoth(Vec3 targetPosition, LivingEntity target) {
        if (targetPosition == null && target != null) {
            targetPosition = new Vec3(target.m_20185_(), target.m_20227_(0.5), target.m_20189_());
        }
        if (targetPosition == null) {
            return;
        }
        if (target != null && !this.canFireAtTarget(target) || target == null && !this.canFireAtPosition(targetPosition)) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            double horizontalDistance;
            MangonelsBulletEntity bullet = new MangonelsBulletEntity((EntityType<? extends MangonelsBulletEntity>)((EntityType)HywEntityRegistry.MANGONELS_BULLET_ENTITY.get()), (LivingEntity)this, this.m_9236_());
            bullet.m_36781_(this.m_21133_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get()));
            if (bullet instanceof BlockBreakable) {
                bullet.setCanBreakBlocks(this.isSiegeModeEnabled());
            }
            float yBodyRot = this.getTrueYBodyRot() + 90.0f;
            double offsetX = Math.cos(Math.toRadians(yBodyRot)) * 0.5;
            double offsetZ = Math.sin(Math.toRadians(yBodyRot)) * 0.5;
            double randomOffsetX = this.getRandomInRange(-0.5, 0.5);
            double randomOffsetY = this.getRandomInRange(-0.5, 0.5);
            bullet.m_6034_(this.m_20185_() + offsetX + randomOffsetX, this.m_20186_() + randomOffsetY, this.m_20189_() + offsetZ);
            bullet.m_146884_(bullet.m_20182_().m_82549_(new Vec3(0.0, 4.0, 0.0)));
            double dx = targetPosition.f_82479_ - bullet.m_20185_();
            double dz = targetPosition.f_82481_ - bullet.m_20189_();
            double dy = targetPosition.f_82480_ - bullet.m_20186_();
            double distance = Math.sqrt(dx * dx + dz * dz + dy * dy);
            if (distance == 0.0) continue;
            float speed = 1.5f;
            double gravity = 0.05;
            double angle = Double.NaN;
            float maxArrowSpeed = 5.0f;
            float miss = 4.0f + (float)this.getRandomInRange(-2.0, 2.0);
            while (speed <= maxArrowSpeed) {
                double[] angles = this.calculateLaunchAngles(speed, gravity, distance, dy);
                if (!Double.isNaN(angles[0])) {
                    angle = angles[0];
                    break;
                }
                if (!((speed += 0.25f) > maxArrowSpeed)) continue;
                break;
            }
            if (Double.isNaN(angle)) continue;
            double randomSpeedOffset = this.getRandomInRange(-0.25, 0.5);
            if (target != null) {
                double timeToTarget = distance / (((double)speed - randomSpeedOffset) * Math.cos(angle));
                double targetVelocityX = target.m_20184_().m_7096_();
                double targetVelocityZ = target.m_20184_().m_7094_();
                double predictedX = target.m_20185_() + targetVelocityX * timeToTarget;
                double predictedZ = target.m_20189_() + targetVelocityZ * timeToTarget;
                double predictedDistance = Math.sqrt((predictedX - bullet.m_20185_()) * (predictedX - bullet.m_20185_()) + (predictedZ - bullet.m_20189_()) * (predictedZ - bullet.m_20189_()));
                double[] recalculatedAngles = this.calculateLaunchAngles(speed, gravity, predictedDistance, dy);
                if (Double.isNaN(recalculatedAngles[0])) continue;
                angle = recalculatedAngles[0];
                double randomTargetOffsetX = this.getRandomInRange(-5.0, 5.0);
                double randomTargetOffsetZ = this.getRandomInRange(-5.0, 5.0);
                dx = predictedX + randomTargetOffsetX - bullet.m_20185_();
                dz = predictedZ + randomTargetOffsetZ - bullet.m_20189_();
            }
            if ((horizontalDistance = Math.sqrt(dx * dx + dz * dz)) == 0.0) continue;
            double horizontalSpeed = (double)speed * Math.cos(angle);
            double verticalSpeed = (double)speed * Math.sin(angle);
            float velocityX = (float)(dx / horizontalDistance * horizontalSpeed);
            float velocityY = (float)verticalSpeed;
            float velocityZ = (float)(dz / horizontalDistance * horizontalSpeed);
            bullet.m_6686_(velocityX, velocityY, velocityZ, speed, miss);
            this.m_9236_().m_7967_((Entity)bullet);
        }
        this.setShowBullets(false);
        this.bulletHideTimer = 100;
        this.m_5810_();
    }

    @Override
    public boolean canFireAtTarget(LivingEntity target) {
        if (this.getCurrentState() != MangonelsState.ASSEMBLED) {
            return false;
        }
        Vec3 targetPosition = new Vec3(target.m_20185_(), target.m_20186_(), target.m_20189_());
        return this.canFireAtPosition(targetPosition);
    }

    @Override
    public boolean canFireAtPosition(Vec3 targetPosition) {
        if (targetPosition == null || this.getCurrentState() != MangonelsState.ASSEMBLED) {
            return false;
        }
        float allowedRotationDifference = 15.0f;
        double dx = targetPosition.f_82479_ - this.m_20185_();
        double dz = targetPosition.f_82481_ - this.m_20189_();
        float actualTargetRot = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
        float actualRotDifference = Mth.m_14177_((float)(actualTargetRot - this.currentRot));
        float rotationDifference = Mth.m_14177_((float)(this.targetRot - this.currentRot));
        return Math.abs(rotationDifference) <= allowedRotationDifference && Math.abs(actualRotDifference) <= allowedRotationDifference;
    }

    private boolean isPathClear(AbstractArrow arrow, double angle, float speed, double dx, double dy, double dz, double distance, LivingEntity target) {
        Vec3 startPos = this.m_146892_();
        Vec3 direction = new Vec3(dx / distance, Math.tan(angle), dz / distance).m_82541_();
        Vec3 endPos = startPos.m_82549_(direction.m_82490_(5.0));
        BlockHitResult hitResult = this.m_9236_().m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)arrow));
        return hitResult.m_6662_() == HitResult.Type.MISS;
    }

    private double[] calculateLaunchAngles(double speed, double gravity, double distance, double heightDifference) {
        double discriminant = speed * speed * speed * speed - gravity * (gravity * distance * distance + 2.0 * heightDifference * speed * speed);
        if (discriminant < 0.0) {
            return new double[]{Double.NaN, Double.NaN};
        }
        double angle1 = Math.atan2(speed * speed + Math.sqrt(discriminant), gravity * distance);
        double angle2 = Math.atan2(speed * speed - Math.sqrt(discriminant), gravity * distance);
        return new double[]{angle1, angle2};
    }

    private double getRandomInRange(double min, double max) {
        return min + (max - min) * this.m_217043_().m_188500_();
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FollowEntityGoal(this, 1.0, 5.0, 20.0, 25.0, 50.0));
        this.f_21345_.m_25352_(2, (Goal)new BaseCombatEntityAttackGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new PatrolGoal(this, 1.0, 40));
        this.f_21345_.m_25352_(3, (Goal)new FollowEntityGoal(this, 1.0, 5.0, 5.0, Double.MAX_VALUE, 0.0));
        this.f_21345_.m_25352_(4, (Goal)new ReturnToHomeGoal(this, 1.0));
        this.addTargetSelector();
    }

    @Override
    public boolean isValidTarget(LivingEntity potentialTarget) {
        double minimumAttackDistance = 5.0;
        double distanceToTarget = this.m_20275_(potentialTarget.m_20185_(), potentialTarget.m_20186_(), potentialTarget.m_20189_());
        if (distanceToTarget < minimumAttackDistance * minimumAttackDistance) {
            return false;
        }
        return super.isValidTarget(potentialTarget);
    }

    public void setTargetPosition(BlockPos pos) {
        this.f_19804_.m_135381_(TARGET_POS, (Object)pos);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("SiegeMode", this.isSiegeModeEnabled());
        compound.m_128379_("HasPositionTarget", this.hasPositionTarget());
        if (this.hasPositionTarget() && this.positionTarget != null) {
            compound.m_128347_("PositionTargetX", this.positionTarget.f_82479_);
            compound.m_128347_("PositionTargetY", this.positionTarget.f_82480_);
            compound.m_128347_("PositionTargetZ", this.positionTarget.f_82481_);
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("SiegeMode")) {
            this.setSiegeModeEnabled(compound.m_128471_("SiegeMode"));
        }
        if (compound.m_128441_("HasPositionTarget") && compound.m_128471_("HasPositionTarget")) {
            double x = compound.m_128459_("PositionTargetX");
            double y = compound.m_128459_("PositionTargetY");
            double z = compound.m_128459_("PositionTargetZ");
            this.setPositionTarget(new Vec3(x, y, z));
        } else {
            this.setPositionTarget(null);
        }
    }

    private void spawnParticles(Level world, double x, double y, double z) {
    }

    public <T extends ParticleOptions> int sendParticlesToAllNearby(ServerLevel serverLevel, T particleOptions, double x, double y, double z, int count, double xOffset, double yOffset, double zOffset, double speed) {
        ClientboundLevelParticlesPacket packet = new ClientboundLevelParticlesPacket(particleOptions, true, x, y, z, (float)xOffset, (float)yOffset, (float)zOffset, (float)speed, count);
        int sentCount = 0;
        for (ServerPlayer serverPlayer : serverLevel.m_6907_()) {
            if (!this.sendParticlesToPlayer(serverLevel, serverPlayer, x, y, z, (Packet<?>)packet)) continue;
            ++sentCount;
        }
        return sentCount;
    }

    private boolean sendParticlesToPlayer(ServerLevel serverLevel, ServerPlayer serverPlayer, double x, double y, double z, Packet<?> packet) {
        if (serverPlayer.m_9236_() != serverLevel) {
            return false;
        }
        double distanceSquared = serverPlayer.m_20182_().m_82557_(new Vec3(x, y, z));
        if (distanceSquared < 262144.0) {
            serverPlayer.f_8906_.m_9829_(packet);
            return true;
        }
        return false;
    }

    public MangonelsState getCurrentState() {
        return MangonelsState.values()[(Integer)this.f_19804_.m_135370_(STATE)];
    }

    private void setCurrentState(MangonelsState state) {
        this.f_19804_.m_135381_(STATE, (Object)state.ordinal());
    }

    public void startPacking() {
        if (this.getCurrentState() == MangonelsState.ASSEMBLED) {
            this.setCurrentState(MangonelsState.PACKING);
            this.packingProgress = 10;
        }
    }

    public void startAssembling() {
        if (this.getCurrentState() == MangonelsState.PACKED) {
            this.setCurrentState(MangonelsState.ASSEMBLING);
            this.assemblingProgress = 100;
        }
    }

    public float getLeftWheelRotation() {
        return this.leftWheelRotation;
    }

    public void setLeftWheelRotation(float leftWheelRotation) {
        this.leftWheelRotation = leftWheelRotation;
    }

    public float getRightWheelRotation() {
        return this.rightWheelRotation;
    }

    public void setRightWheelRotation(float rightWheelRotation) {
        this.rightWheelRotation = rightWheelRotation;
    }

    public int getPackingProgress() {
        return this.packingProgress;
    }

    public int getAssemblingProgress() {
        return this.assemblingProgress;
    }

    public void setPackingProgress(int packingProgress) {
        this.packingProgress = packingProgress;
    }

    public void setAssemblingProgress(int assemblingProgress) {
        this.assemblingProgress = assemblingProgress;
    }

    @Override
    public double getArrivalThreshold() {
        return 2.0;
    }

    public void m_6478_(MoverType type, Vec3 displacement) {
        if (this.getCurrentState() != MangonelsState.PACKED) {
            displacement = displacement.f_82480_ > 0.0 ? displacement.m_82490_(0.0) : new Vec3(0.0, displacement.f_82480_, 0.0);
        }
        super.m_6478_(type, displacement);
    }

    @Override
    protected Item getScrollType() {
        return (Item)HywItemRegistry.MANGONELS.get();
    }

    @Override
    public void addTargetSelector() {
        Predicate<LivingEntity> unifiedPredicate = this::isValidTarget;
        this.f_21346_.m_25352_(1, (Goal)new SkyExposedTargetGoal(this, LivingEntity.class, 10, true, false, unifiedPredicate));
    }

    public boolean shouldShowBullets() {
        return (Boolean)this.f_19804_.m_135370_(SHOW_BULLETS);
    }

    public void setShowBullets(boolean showBullets) {
        this.f_19804_.m_135381_(SHOW_BULLETS, (Object)showBullets);
    }

    @Override
    public boolean hasPositionTarget() {
        return (Boolean)this.f_19804_.m_135370_(HAS_POSITION_TARGET);
    }

    @Override
    public Vec3 getPositionTarget() {
        return this.positionTarget;
    }

    @Override
    public void setPositionTarget(Vec3 targetPosition) {
        this.positionTarget = targetPosition;
        this.f_19804_.m_135381_(HAS_POSITION_TARGET, (Object)(targetPosition != null ? 1 : 0));
        if (targetPosition != null) {
            this.setTargetPosition(new BlockPos((int)targetPosition.f_82479_, (int)targetPosition.f_82480_, (int)targetPosition.f_82481_));
        } else {
            this.setTargetPosition(BlockPos.f_121853_);
        }
    }

    public static enum MangonelsState {
        PACKED,
        ASSEMBLED,
        PACKING,
        ASSEMBLING;

    }
}

