/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.goals;

import java.util.EnumSet;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.main.entity.entities.ArcherEntity;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.HywHorseEntity;
import ydmsama.hundred_years_war.main.entity.entities.tags.SiegeUnit;
import ydmsama.hundred_years_war.main.entity.goals.MoveGoal;
import ydmsama.hundred_years_war.main.entity.utils.PathingTask;
import ydmsama.hundred_years_war.main.entity.utils.PathingTaskManager;
import ydmsama.hundred_years_war.main.entity.utils.PathingTaskManagerRegistry;
import ydmsama.hundred_years_war.main.entity.utils.Rideable;
import ydmsama.hundred_years_war.main.entity.utils.Rider;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;

public class FollowEntityGoal
extends Goal
implements MoveGoal {
    private final BaseCombatEntity mob;
    private final double speed;
    private LivingEntity targetEntity;
    private final double followRange;
    private final double triggerRange;
    private final double teleportRange;
    private final double maxTeleportRange;
    private boolean shouldRemove;
    private boolean tryRiding;
    private Path currentPath;
    private boolean pathGenerated = false;

    public FollowEntityGoal(BaseCombatEntity mob, double speed, double followRange, double triggerRange, double teleportRange, double maxTeleportRange) {
        this.mob = mob;
        this.speed = speed;
        this.followRange = followRange;
        this.triggerRange = triggerRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.shouldRemove = true;
        this.teleportRange = teleportRange;
        this.maxTeleportRange = maxTeleportRange;
    }

    public boolean m_8036_() {
        if (this.mob instanceof Rider && this.targetEntity instanceof Rideable) {
            this.tryRiding = true;
        }
        this.targetEntity = this.mob.getFollowTarget();
        if (this.targetEntity == null || !this.targetEntity.m_6084_()) {
            return false;
        }
        double distanceToTarget = this.mob.m_20280_((Entity)this.targetEntity);
        return distanceToTarget > this.triggerRange * this.triggerRange || !this.shouldRemove || this.tryRiding && !this.mob.m_20159_();
    }

    public boolean m_8045_() {
        if (this.mob instanceof ArcherEntity && this.targetEntity instanceof HywHorseEntity) {
            this.tryRiding = true;
        }
        this.targetEntity = this.mob.getFollowTarget();
        if (this.targetEntity == null || !this.targetEntity.m_6084_()) {
            return false;
        }
        double distanceToTarget = this.mob.m_20280_((Entity)this.targetEntity);
        return distanceToTarget > this.triggerRange * this.triggerRange || !this.shouldRemove || this.tryRiding;
    }

    public void m_8056_() {
        this.mob.setHomePosition(null);
        this.targetEntity = this.mob.getFollowTarget();
        if (!this.mob.commandHold()) {
            this.mob.setCommandHold(false);
        }
        this.shouldRemove = false;
        this.updatePath();
    }

    public void m_8041_() {
        this.mob.m_21573_().m_26573_();
    }

    public void m_8037_() {
        LivingEntity livingEntity;
        this.targetEntity = this.mob.getFollowTarget();
        if (this.targetEntity == null) {
            return;
        }
        double distanceToTarget = this.mob.m_20280_((Entity)this.targetEntity);
        if (distanceToTarget > this.followRange * this.followRange) {
            this.mob.m_21573_().m_5624_((Entity)this.targetEntity, this.speed);
        } else {
            if (this.tryRiding && this.mob instanceof Rider && this.targetEntity instanceof Rideable && !this.mob.m_20159_() && this.targetEntity.m_20197_().isEmpty()) {
                this.mob.m_7998_((Entity)this.targetEntity, true);
                SelectionSystem.clearEntityFromAllSelections(this.mob);
                this.tryRiding = false;
            }
            this.shouldRemove = true;
        }
        if (distanceToTarget > this.teleportRange * this.teleportRange && distanceToTarget < this.maxTeleportRange * this.maxTeleportRange && (livingEntity = this.targetEntity) instanceof Player) {
            Player player = (Player)livingEntity;
            if (!(this.mob instanceof SiegeUnit) && ServerRelationHelper.hasControlOver(player, (Entity)this.mob)) {
                Vec3 teleportPos = this.findSafeTeleportPosition();
                if (teleportPos != null) {
                    this.mob.m_6021_(teleportPos.f_82479_, teleportPos.f_82480_, teleportPos.f_82481_);
                    this.currentPath = null;
                }
                this.shouldRemove = true;
            }
        }
    }

    private void updatePath() {
        if (this.pathGenerated) {
            if (this.currentPath == null || this.currentPath.m_77392_() || !this.mob.m_21573_().m_26572_()) {
                this.currentPath = this.mob.m_21573_().m_148218_(this.targetEntity.m_20183_(), 0, 16);
            }
        } else {
            this.createPathingTask(this.mob, this.targetEntity);
        }
    }

    private void createPathingTask(BaseCombatEntity mob, LivingEntity target) {
        Consumer<Path> pathConsumer = path -> {
            this.currentPath = path;
            this.pathGenerated = true;
        };
        PathingTask task = new PathingTask(mob, target.m_20183_(), pathConsumer);
        PathingTaskManagerRegistry registry = PathingTaskManagerRegistry.getInstance();
        PathingTaskManager manager = registry.getTaskManager(mob.getOwnerUUID());
        manager.addTask(task);
    }

    private Vec3 findSafeTeleportPosition() {
        BlockPos pos;
        int yOffset;
        double distanceToNewPos;
        int newZ;
        int newX;
        int offsetZ;
        int offsetX;
        int i;
        BlockPos targetPos = this.targetEntity.m_20183_();
        BlockPos mobPos = this.mob.m_20183_();
        int range = 10;
        int heightLimit = 5;
        double distanceToTarget = Math.sqrt(this.mob.m_20280_((Entity)this.targetEntity));
        for (i = 0; i < 10; ++i) {
            offsetX = this.mob.m_217043_().m_188503_(range * 2) - range;
            offsetZ = this.mob.m_217043_().m_188503_(range * 2) - range;
            newX = targetPos.m_123341_() + offsetX;
            newZ = targetPos.m_123343_() + offsetZ;
            distanceToNewPos = Math.sqrt(mobPos.m_123331_((Vec3i)new BlockPos(newX, targetPos.m_123342_(), newZ)));
            if (distanceToNewPos > distanceToTarget) continue;
            for (yOffset = 1; yOffset <= heightLimit; ++yOffset) {
                pos = new BlockPos(newX, targetPos.m_123342_() + yOffset, newZ);
                if (!this.isSafeTeleportLocation(pos, false)) continue;
                return new Vec3((double)newX + 0.5, (double)pos.m_123342_(), (double)newZ + 0.5);
            }
            for (yOffset = 0; yOffset < heightLimit; ++yOffset) {
                pos = new BlockPos(newX, targetPos.m_123342_() - yOffset, newZ);
                if (!this.isSafeTeleportLocation(pos, false)) continue;
                return new Vec3((double)newX + 0.5, (double)pos.m_123342_(), (double)newZ + 0.5);
            }
        }
        for (i = 0; i < 10; ++i) {
            offsetX = this.mob.m_217043_().m_188503_(range * 2) - range;
            offsetZ = this.mob.m_217043_().m_188503_(range * 2) - range;
            newX = targetPos.m_123341_() + offsetX;
            newZ = targetPos.m_123343_() + offsetZ;
            distanceToNewPos = Math.sqrt(mobPos.m_123331_((Vec3i)new BlockPos(newX, targetPos.m_123342_(), newZ)));
            if (distanceToNewPos > distanceToTarget) continue;
            for (yOffset = 1; yOffset <= heightLimit; ++yOffset) {
                pos = new BlockPos(newX, targetPos.m_123342_() + yOffset, newZ);
                if (!this.isSafeTeleportLocation(pos, true)) continue;
                return new Vec3((double)newX + 0.5, (double)pos.m_123342_(), (double)newZ + 0.5);
            }
            for (yOffset = 0; yOffset < heightLimit; ++yOffset) {
                pos = new BlockPos(newX, targetPos.m_123342_() - yOffset, newZ);
                if (!this.isSafeTeleportLocation(pos, true)) continue;
                return new Vec3((double)newX + 0.5, (double)pos.m_123342_(), (double)newZ + 0.5);
            }
        }
        return null;
    }

    private boolean isSafeTeleportLocation(BlockPos pos, boolean allowWater) {
        double entityWidth = this.mob.m_20205_();
        double entityHeight = this.mob.m_20206_();
        BlockState blockStateBelow = this.mob.m_9236_().m_8055_(pos.m_7495_());
        if (!(blockStateBelow.m_280296_() || allowWater && blockStateBelow.m_60713_(Blocks.f_49990_))) {
            return false;
        }
        Vec3 minPos = new Vec3((double)pos.m_123341_() - entityWidth / 2.0, (double)pos.m_123342_(), (double)pos.m_123343_() - entityWidth / 2.0);
        Vec3 maxPos = new Vec3((double)pos.m_123341_() + entityWidth / 2.0, (double)pos.m_123342_() + entityHeight, (double)pos.m_123343_() + entityWidth / 2.0);
        for (double x = minPos.f_82479_; x <= maxPos.f_82479_; x += 1.0) {
            for (double z = minPos.f_82481_; z <= maxPos.f_82481_; z += 1.0) {
                for (double y = minPos.f_82480_; y <= maxPos.f_82480_; y += 1.0) {
                    BlockPos checkPos = new BlockPos((int)x, (int)y, (int)z);
                    BlockState blockState = this.mob.m_9236_().m_8055_(checkPos);
                    if (blockState.m_60795_() || allowWater && blockState.m_60713_(Blocks.f_49990_)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

