/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.goals;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.goals.CommandedGoal;
import ydmsama.hundred_years_war.main.entity.goals.MoveGoal;
import ydmsama.hundred_years_war.main.entity.utils.FormationManager;
import ydmsama.hundred_years_war.main.mixins.EntityAccessor;

public class FormMoveGoal
extends Goal
implements CommandedGoal,
MoveGoal {
    private Path currentPath;
    private boolean init = true;
    private double formationSpeed;
    private double totalMovedDistance = 0.0;
    private final UUID FormationUUID;
    private FormationManager.FormationStatus status;
    private boolean formCompleted = false;
    private boolean shouldRemove = false;
    private final int waitLimitTicks = 60;
    private int waitLimit = -1;
    private BaseCombatEntity mob;
    private final double speed;
    private BlockPos targetPos;
    private double newTargetX;
    private double newTargetY;
    private double newTargetZ;
    private static final double ARRIVAL_THRESHOLD = 5.0;
    private double minSpeed;
    private static final double SMALL_FORM_DISTANCE_THRESHOLD = 5.0;
    private static final UUID FORMATION_SPEED_MODIFIER_UUID = UUID.fromString("550e8400-e29b-41d4-a716-446655440001");

    public FormMoveGoal(BaseCombatEntity mob, double speed, UUID formationUUID, double minSpeed) {
        this.mob = mob;
        this.speed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.FormationUUID = formationUUID;
        this.formationSpeed = mob.m_21133_(Attributes.f_22279_);
        this.minSpeed = minSpeed;
    }

    public void setTargetPos(BlockPos targetPos) {
        this.targetPos = targetPos.m_7494_();
    }

    public boolean m_8036_() {
        if (this.targetPos == null) {
            return false;
        }
        return !this.shouldRemove && !this.mob.m_20159_();
    }

    public boolean m_8045_() {
        return !this.shouldRemove;
    }

    public void m_8056_() {
        if (this.init) {
            double formDistance = FormationManager.getFormationStatus(this.FormationUUID).getFormDistance();
            Vec3 formDirection = FormationManager.getFormationStatus(this.FormationUUID).getFormDirection();
            Vec3 movementVector = formDirection.m_82490_(formDistance);
            BlockPos homePos = new BlockPos((int)((double)this.targetPos.m_123341_() + movementVector.f_82479_), this.targetPos.m_123342_(), (int)((double)this.targetPos.m_123343_() + movementVector.f_82481_));
            this.mob.setHomePosition(homePos);
            this.mob.setFormationUUID(this.FormationUUID);
            if (this.FormationUUID != null) {
                this.status = FormationManager.getFormationStatus(this.FormationUUID);
            }
            this.newTargetX = this.targetPos.m_123341_();
            this.newTargetZ = this.targetPos.m_123343_();
            this.mob.setCommandHold(false);
            this.init = false;
        }
    }

    public void m_8041_() {
        AttributeInstance speedAttr;
        if (this.mob != null && (speedAttr = this.mob.m_21051_(Attributes.f_22279_)) != null && speedAttr.m_22111_(FORMATION_SPEED_MODIFIER_UUID) != null) {
            speedAttr.m_22120_(FORMATION_SPEED_MODIFIER_UUID);
        }
        this.mob.m_21573_().m_26573_();
        FormationManager.getFormationStatus(this.FormationUUID).markEntityReady(this.mob);
    }

    public void m_8037_() {
        BlockPos currentHorizontalPos;
        if (this.targetPos == null) {
            return;
        }
        this.updateTargetPos();
        if (this.status != null) {
            if (this.waitLimit == -1) {
                int size = this.status.getFormationSize();
                this.waitLimit = Math.max(2 * size, 60);
            }
            if (!this.status.getFormationReadyEntities().isEmpty()) {
                --this.waitLimit;
            }
        }
        if ((currentHorizontalPos = new BlockPos((int)Math.floor(this.mob.m_20185_()), this.targetPos.m_123342_(), (int)Math.floor(this.mob.m_20189_()))).m_123314_((Vec3i)this.targetPos, 5.0)) {
            FormationManager.markEntityReady(this.FormationUUID, this.mob);
            if (this.formCompleted) {
                FormationManager.getFormationStatus(this.FormationUUID).markTargetReached(this.mob);
                this.shouldRemove = true;
                this.executeNext();
            } else {
                this.startMove(this.mob, this.speed - (double)0.2f);
            }
            if (FormationManager.FormationReadyAll(this.FormationUUID) || this.waitLimit == 0) {
                this.formCompleted = true;
            }
        } else {
            if (this.formCompleted) {
                this.setEntitySpeed(this.mob, this.minSpeed);
                this.startMove(this.mob, this.speed);
            } else if (this.shouldSpeedUp(this.status, currentHorizontalPos)) {
                this.startMove(this.mob, this.speed + 0.25);
            } else {
                this.startMove(this.mob, this.speed);
            }
            if (!this.formCompleted && this.waitLimit <= 0) {
                if (FormationManager.shouldTeleport(this.FormationUUID) && this.inTeleportRange(this.status, currentHorizontalPos)) {
                    this.safeTeleport(this.mob, this.FormationUUID);
                    FormationManager.markEntityReady(this.FormationUUID, this.mob);
                }
                FormationManager.markEntityReady(this.FormationUUID, this.mob);
            }
        }
    }

    private boolean shouldSpeedUp(FormationManager.FormationStatus status, BlockPos currentHorizontalPos) {
        return currentHorizontalPos.m_123314_((Vec3i)this.targetPos, (double)(2 * status.getFormationSize()));
    }

    private boolean inTeleportRange(FormationManager.FormationStatus status, BlockPos currentHorizontalPos) {
        return currentHorizontalPos.m_123314_((Vec3i)this.targetPos, (double)(10 * status.getFormationSize()));
    }

    private void safeTeleport(BaseCombatEntity mob, UUID formationUUID) {
        BlockPos position;
        BlockPos safePosition;
        Set<BaseCombatEntity> formationReadyEntities = FormationManager.getFormationStatus(formationUUID).getFormationReadyEntities();
        ArrayList<BaseCombatEntity> entityList = new ArrayList<BaseCombatEntity>(formationReadyEntities);
        BaseCombatEntity closestEntity = null;
        double closestDistance = Double.MAX_VALUE;
        BlockPos mobPosition = mob.m_20183_();
        for (BaseCombatEntity entity : entityList) {
            double distance = mobPosition.m_123331_((Vec3i)entity.m_20183_());
            if (!(distance < closestDistance)) continue;
            closestDistance = distance;
            closestEntity = entity;
        }
        if (closestEntity != null && (safePosition = this.findSafePosition(position = closestEntity.m_20183_(), mob)) != null) {
            mob.m_6021_(safePosition.m_123341_(), safePosition.m_123342_(), safePosition.m_123343_());
        }
        if (FormationManager.FormationReadyAll(formationUUID)) {
            this.formCompleted = true;
        }
    }

    private BlockPos findSafePosition(BlockPos position, BaseCombatEntity mob) {
        Level level = ((EntityAccessor)((Object)mob)).getLevel();
        int radius = 5;
        if (this.isPositionSafe(level, position, mob)) {
            return position;
        }
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos newPos = position.m_7918_(dx, dy, dz);
                    if (!this.isPositionSafe(level, newPos, mob)) continue;
                    return newPos;
                }
            }
        }
        return null;
    }

    private boolean isPositionSafe(Level level, BlockPos position, BaseCombatEntity mob) {
        AABB boundingBox = mob.m_20191_().m_82386_((double)position.m_123341_() - mob.m_20185_(), (double)position.m_123342_() - mob.m_20186_(), (double)position.m_123343_() - mob.m_20189_());
        return level.m_45756_((Entity)mob, boundingBox);
    }

    private void startMove(BaseCombatEntity mob, double speed) {
        if (!this.formCompleted) {
            mob.m_21573_().m_26519_((double)this.targetPos.m_123341_(), (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_(), speed);
        } else {
            if (this.currentPath == null || this.currentPath.m_77392_() || !mob.m_21573_().m_26572_()) {
                this.currentPath = mob.m_21573_().m_148218_(this.targetPos, 0, 16);
            }
            mob.m_21573_().m_26536_(this.currentPath, speed);
        }
    }

    private void updateTargetPos() {
        FormationManager.FormationStatus formationStatus = FormationManager.getFormationStatus(this.FormationUUID);
        double formDistance = formationStatus.getFormDistance();
        if (this.totalMovedDistance >= formDistance) {
            return;
        }
        if (formDistance < 5.0) {
            Vec3 formDirection = formationStatus.getFormDirection();
            Vec3 finalTarget = new Vec3((double)this.targetPos.m_123341_(), (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_()).m_82549_(formDirection.m_82490_(formDistance));
            this.newTargetX = finalTarget.f_82479_;
            this.newTargetZ = finalTarget.f_82481_;
            this.targetPos = new BlockPos((int)this.newTargetX, this.targetPos.m_123342_(), (int)this.newTargetZ);
            this.totalMovedDistance = formDistance;
            Level level = ((EntityAccessor)((Object)this.mob)).getLevel();
            this.targetPos = this.adjustYCoordinate(this.targetPos, level, 10);
            return;
        }
        double targetSpeed = this.formCompleted ? this.formationSpeed * 3.0 : (this.speed - (double)0.2f) * this.formationSpeed;
        Vec3 formDirection = formationStatus.getFormDirection();
        Vec3 movementVector = formDirection.m_82490_(targetSpeed);
        double movementDistance = movementVector.m_82553_();
        if (this.totalMovedDistance + movementDistance <= formDistance) {
            this.newTargetX += movementVector.f_82479_;
            this.newTargetZ += movementVector.f_82481_;
            this.targetPos = new BlockPos((int)this.newTargetX, this.targetPos.m_123342_(), (int)this.newTargetZ);
            this.totalMovedDistance += movementDistance;
        } else {
            this.updatePositionWithRemainingDistance(formDirection, targetSpeed, formDistance, movementDistance);
        }
        if (this.formCompleted) {
            this.updatePositionWithRemainingDistance(formDirection, targetSpeed, formDistance, movementDistance);
        }
        Level level = ((EntityAccessor)((Object)this.mob)).getLevel();
        this.targetPos = this.adjustYCoordinate(this.targetPos, level, 10);
    }

    private void updatePositionWithRemainingDistance(Vec3 formDirection, double targetSpeed, double formDistance, double movementDistance) {
        double remainingDistance = formDistance - this.totalMovedDistance;
        if (remainingDistance > 0.0) {
            Vec3 adjustedMovementVector = formDirection.m_82490_(remainingDistance / movementDistance * targetSpeed);
            this.newTargetX += adjustedMovementVector.f_82479_;
            this.newTargetZ += adjustedMovementVector.f_82481_;
            this.targetPos = new BlockPos((int)this.newTargetX, this.targetPos.m_123342_(), (int)this.newTargetZ);
            this.totalMovedDistance = formDistance;
        }
    }

    private BlockPos adjustYCoordinate(BlockPos pos, Level level, int maxCheckRange) {
        for (int i = 0; i < maxCheckRange; ++i) {
            BlockPos up = pos.m_6630_(i);
            if (!level.m_46859_(up) || level.m_46859_(up.m_7495_()) || !this.isPositionSafe(level, up, this.mob)) continue;
            return up;
        }
        return pos;
    }

    private void setEntitySpeed(BaseCombatEntity entity, double speedValue) {
        AttributeInstance speedAttr = entity.m_21051_(Attributes.f_22279_);
        if (speedAttr == null) {
            return;
        }
        AttributeModifier existingModifier = speedAttr.m_22111_(FORMATION_SPEED_MODIFIER_UUID);
        if (existingModifier != null) {
            speedAttr.m_22120_(FORMATION_SPEED_MODIFIER_UUID);
        }
        double baseValue = speedAttr.m_22115_();
        double multiplier = speedValue / baseValue - 1.0;
        speedAttr.m_22118_(new AttributeModifier(FORMATION_SPEED_MODIFIER_UUID, "Formation movement speed", multiplier, AttributeModifier.Operation.MULTIPLY_TOTAL));
    }

    @Override
    public void executeNext() {
        this.mob.setShouldExecuteNext(true);
        this.mob.goalFinished();
    }

    public UUID getFormationUUID() {
        return this.FormationUUID;
    }

    @Override
    public void updateEntityReference(BaseCombatEntity newEntity) {
        FormationManager.FormationStatus formationStatus;
        this.mob = newEntity;
        this.mob.setFormationUUID(this.FormationUUID);
        if (this.FormationUUID != null && (formationStatus = FormationManager.getFormationStatus(this.FormationUUID)) != null) {
            formationStatus.getEntities().add(newEntity);
            int currentSize = formationStatus.getEntities().size();
            formationStatus.setFormationSize(currentSize);
        }
    }
}

