/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.goals;

import java.util.EnumSet;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Path;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.goals.CommandedGoal;
import ydmsama.hundred_years_war.main.entity.goals.MoveGoal;
import ydmsama.hundred_years_war.main.entity.utils.FormationManager;
import ydmsama.hundred_years_war.main.entity.utils.PathingTask;
import ydmsama.hundred_years_war.main.entity.utils.PathingTaskManager;
import ydmsama.hundred_years_war.main.entity.utils.PathingTaskManagerRegistry;
import ydmsama.hundred_years_war.main.mixins.EntityAccessor;

public class MoveToBlockGoal
extends Goal
implements CommandedGoal,
MoveGoal {
    private boolean init = true;
    private final UUID FormationUUID;
    private boolean shouldRemove = false;
    private BaseCombatEntity mob;
    private final double speed;
    private BlockPos targetPos;
    private Path currentPath;
    private boolean pathGenerated = false;

    public MoveToBlockGoal(BaseCombatEntity mob, double speed, UUID formationUUID) {
        this.mob = mob;
        this.speed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.FormationUUID = formationUUID;
    }

    public void setTargetPos(BlockPos targetPos) {
        BlockState blockState = ((EntityAccessor)((Object)this.mob)).getLevel().m_8055_(targetPos);
        this.targetPos = !blockState.m_60804_((BlockGetter)((EntityAccessor)((Object)this.mob)).getLevel(), targetPos) || blockState.m_60795_() ? targetPos : targetPos.m_7494_();
    }

    public boolean m_8036_() {
        if (this.targetPos == null) {
            return false;
        }
        return !this.shouldRemove && !this.mob.m_20159_();
    }

    public boolean m_8045_() {
        return !this.shouldRemove;
    }

    public void m_8056_() {
        if (this.init) {
            this.mob.setHomePosition(this.targetPos);
            this.mob.setFormationUUID(this.FormationUUID);
            this.createPathingTask(this.mob);
            this.mob.setCommandHold(false);
            this.init = false;
        } else {
            this.currentPath = null;
        }
    }

    public void m_8041_() {
        this.mob.m_21573_().m_26573_();
    }

    public void m_8037_() {
        if (this.targetPos == null) {
            return;
        }
        BlockPos currentHorizontalPos = new BlockPos((int)Math.floor(this.mob.m_20185_()), this.targetPos.m_123342_(), (int)Math.floor(this.mob.m_20189_()));
        double verticalDistance = Math.abs(this.mob.m_20186_() - (double)this.targetPos.m_123342_());
        if (currentHorizontalPos.m_123314_((Vec3i)this.targetPos, this.mob.getArrivalThreshold()) && verticalDistance < 1.0 + this.mob.getArrivalThreshold()) {
            this.shouldRemove = true;
            this.executeNext();
        } else {
            this.startMove(this.mob, this.speed);
        }
    }

    private void createPathingTask(BaseCombatEntity mob) {
        Consumer<Path> pathConsumer = path -> {
            this.currentPath = path;
            this.pathGenerated = true;
        };
        PathingTask task = new PathingTask(mob, this.targetPos, pathConsumer);
        PathingTaskManagerRegistry registry = PathingTaskManagerRegistry.getInstance();
        PathingTaskManager manager = registry.getTaskManager(mob.getOwnerUUID());
        manager.addTask(task);
    }

    private void startMove(BaseCombatEntity mob, double speed) {
        double deltaZ;
        double deltaX;
        double distance;
        if (this.pathGenerated && (this.currentPath == null || this.currentPath.m_77392_() || !mob.m_21573_().m_26572_())) {
            this.currentPath = mob.m_21573_().m_148218_(this.targetPos, 0, 16);
        }
        mob.m_21573_().m_26536_(this.currentPath, speed);
        if (!mob.m_21573_().m_26572_() && (distance = Math.sqrt((deltaX = (double)this.targetPos.m_123341_() - mob.m_20185_()) * deltaX + (deltaZ = (double)this.targetPos.m_123343_() - mob.m_20189_()) * deltaZ)) < 10.0 * mob.getArrivalThreshold() && distance > 0.01) {
            double smallMoveSpeed = 0.05;
            mob.m_20334_(deltaX / distance * smallMoveSpeed, mob.m_20184_().f_82480_, deltaZ / distance * smallMoveSpeed);
        }
    }

    @Override
    public void executeNext() {
        this.mob.setShouldExecuteNext(true);
        this.mob.goalFinished();
    }

    @Override
    public void updateEntityReference(BaseCombatEntity newEntity) {
        FormationManager.FormationStatus formationStatus;
        this.mob = newEntity;
        this.mob.setFormationUUID(this.FormationUUID);
        if (this.FormationUUID != null && (formationStatus = FormationManager.getFormationStatus(this.FormationUUID)) != null) {
            formationStatus.getEntities().add(newEntity);
            int currentSize = formationStatus.getEntities().size();
            formationStatus.setFormationSize(currentSize);
        }
    }
}

